/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.apache.yoko.rmi.impl.MethodDescriptor;
import org.apache.yoko.rmi.impl.RMIRemoteStub;
import org.apache.yoko.rmi.impl.RMIServant;
import org.apache.yoko.rmi.impl.RMIState;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.impl.RemoteInterfaceDescriptor;
import org.apache.yoko.rmi.impl.StubHandler;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.UtilImpl;
import org.apache.yoko.rmi.util.ClientUtil;
import org.apache.yoko.rmi.util.GetSystemPropertyAction;
import org.apache.yoko.rmi.util.stub.MethodRef;
import org.apache.yoko.rmi.util.stub.StubClass;
import org.apache.yoko.rmi.util.stub.StubInitializer;
import org.apache.yoko.rmispec.util.UtilLoader;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA_2_3.portable.ObjectImpl;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class PortableRemoteObjectImpl
implements PortableRemoteObjectDelegate {
    static final Logger LOGGER = Logger.getLogger(PortableRemoteObjectImpl.class.getName());
    static java.lang.Object[] NO_ARG;
    private static Method stub_write_replace;
    private static Method poa_stub_invoke_method;
    private static StubInitializer initializer;
    private static final String defaultInitializer = "org.apache.yoko.rmi.impl.RMIStubInitializer";

    static ORB getORB() {
        return RMIState.current().getORB();
    }

    static POA getPOA() {
        return RMIState.current().getPOA();
    }

    static ClassLoader getClassLoader() {
        return RMIState.current().getClassLoader();
    }

    public void connect(Remote target, Remote source) throws RemoteException {
        org.omg.CORBA.portable.ObjectImpl obj;
        if (!(source instanceof Stub)) {
            source = this.toStub(source);
        }
        if (target instanceof org.omg.CORBA.portable.ObjectImpl) {
            obj = (org.omg.CORBA.portable.ObjectImpl)target;
        } else {
            try {
                this.exportObject(target);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            try {
                obj = (org.omg.CORBA.portable.ObjectImpl)this.toStub(target);
            }
            catch (NoSuchObjectException ex) {
                throw (RemoteException)new RemoteException("cannot convert to stub!").initCause(ex);
            }
        }
        try {
            ((Stub)source).connect(obj._orb());
        }
        catch (BAD_OPERATION bad_operation) {
            throw (RemoteException)new RemoteException(bad_operation.getMessage()).initCause(bad_operation);
        }
    }

    private java.lang.Object narrowRMI(org.omg.CORBA.portable.ObjectImpl narrowFrom, Class<?> narrowTo) {
        Delegate delegate;
        Stub stub;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("RMI narrowing %s => %s", narrowFrom.getClass().getName(), narrowTo.getName()));
        }
        org.omg.CORBA.portable.ObjectImpl object = narrowFrom;
        String codebase = this.getCodebase(narrowFrom);
        RMIState state = RMIState.current();
        try {
            stub = PortableRemoteObjectImpl.createStub(state, codebase, narrowTo);
        }
        catch (ClassNotFoundException ex) {
            throw (ClassCastException)new ClassCastException(narrowTo.getName()).initCause(ex);
        }
        try {
            delegate = object._get_delegate();
        }
        catch (BAD_OPERATION ex) {
            delegate = null;
        }
        stub._set_delegate(delegate);
        return stub;
    }

    private String getCodebase(org.omg.CORBA.portable.ObjectImpl narrowFrom) {
        String codebase;
        if (narrowFrom instanceof ObjectImpl) {
            ObjectImpl object_2_3 = (ObjectImpl)narrowFrom;
            try {
                codebase = object_2_3._get_codebase();
            }
            catch (BAD_OPERATION ex) {
                codebase = null;
            }
        } else {
            codebase = null;
        }
        return codebase;
    }

    private java.lang.Object narrowIDL(org.omg.CORBA.portable.ObjectImpl narrowFrom, Class<?> narrowTo) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("IDL narrowing %s => %s", narrowFrom.getClass().getName(), narrowTo.getName()));
        }
        ClassLoader idlClassLoader = UtilImpl.getClassLoader(narrowTo);
        String codebase = this.getCodebase(narrowFrom);
        String helperClassName = narrowTo.getName() + "Helper";
        try {
            final Class helperClass = Util.loadClass((String)helperClassName, (String)codebase, (ClassLoader)idlClassLoader);
            Method helperNarrow = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return helperClass.getMethod("narrow", Object.class);
                }
            });
            return helperNarrow.invoke(null, narrowFrom);
        }
        catch (PrivilegedActionException e) {
            throw (ClassCastException)new ClassCastException(narrowTo.getName()).initCause(e.getCause());
        }
        catch (Exception e) {
            throw (ClassCastException)new ClassCastException(narrowTo.getName()).initCause(e);
        }
    }

    public java.lang.Object narrow(java.lang.Object narrowFrom, Class narrowTo) throws ClassCastException {
        if (narrowFrom == null) {
            return null;
        }
        if (narrowTo.isInstance(narrowFrom)) {
            return narrowFrom;
        }
        String fromClassName = narrowFrom.getClass().getName();
        String toClassName = narrowTo.getName();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.finer(String.format("narrow %s => %s", fromClassName, toClassName));
        }
        if (!(narrowFrom instanceof org.omg.CORBA.portable.ObjectImpl)) {
            throw new ClassCastException(String.format("object to narrow (runtime type %s) is not an instance of %s", fromClassName, org.omg.CORBA.portable.ObjectImpl.class.getName()));
        }
        if (!narrowTo.isInterface()) {
            throw new ClassCastException(String.format("%s is not an interface", toClassName));
        }
        boolean isRemote = Remote.class.isAssignableFrom(narrowTo);
        boolean isIDLEntity = IDLEntity.class.isAssignableFrom(narrowTo);
        if (isRemote && isIDLEntity) {
            throw new ClassCastException(String.format("%s invalidly extends both %s and %s", toClassName, Remote.class.getName(), IDLEntity.class.getName()));
        }
        if (isRemote) {
            return this.narrowRMI((org.omg.CORBA.portable.ObjectImpl)narrowFrom, narrowTo);
        }
        if (isIDLEntity) {
            return this.narrowIDL((org.omg.CORBA.portable.ObjectImpl)narrowFrom, narrowTo);
        }
        throw new ClassCastException(String.format("%s extends neither %s nor %s", toClassName, Remote.class.getName(), IDLEntity.class.getName()));
    }

    static Remote narrow1(RMIState state, org.omg.CORBA.portable.ObjectImpl object, Class<?> narrowTo) throws ClassCastException {
        Delegate delegate;
        Stub stub;
        try {
            stub = PortableRemoteObjectImpl.createStub(state, null, narrowTo);
        }
        catch (ClassNotFoundException ex) {
            throw (ClassCastException)new ClassCastException(narrowTo.getName()).initCause(ex);
        }
        try {
            delegate = object._get_delegate();
        }
        catch (BAD_OPERATION ex) {
            delegate = null;
        }
        stub._set_delegate(delegate);
        return (Remote)stub;
    }

    private static Stub createStub(RMIState state, String codebase, Class<?> type) throws ClassNotFoundException {
        Stub stub;
        if (Remote.class == type) {
            return new RMIRemoteStub();
        }
        if (ClientUtil.isRunningAsClientContainer() && (stub = state.getStaticStub(codebase, type)) != null) {
            return stub;
        }
        return PortableRemoteObjectImpl.createRMIStub(state, type);
    }

    static Stub createRMIStub(RMIState state, Class<?> type) throws ClassNotFoundException {
        if (!type.isInterface()) {
            throw new RuntimeException("non-interfaces not supported");
        }
        LOGGER.fine("Creating RMI stub for class " + type.getName());
        Constructor<? extends Stub> cons = PortableRemoteObjectImpl.getRMIStubClassConstructor(state, type);
        try {
            Stub result = cons.newInstance(NO_ARG);
            return result;
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("internal problem: cannot instantiate stub", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("internal problem: cannot instantiate stub", ex.getCause());
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("internal problem: cannot instantiate stub", ex);
        }
    }

    static synchronized Class<?> getRMIStubClass(RMIState state, Class<?> type) throws ClassNotFoundException {
        return PortableRemoteObjectImpl.getRMIStubClassConstructor(state, type).getDeclaringClass();
    }

    static Constructor<? extends Stub> getRMIStubClassConstructor(RMIState state, Class<?> type) throws ClassNotFoundException {
        LOGGER.fine("Requesting stub constructor of class " + type.getName());
        Constructor cons = (Constructor)state.stub_map.get(type);
        if (cons != null) {
            LOGGER.fine("Returning cached constructor of class " + cons.getDeclaringClass().getName());
            return cons;
        }
        TypeRepository repository = state.repo;
        RemoteInterfaceDescriptor desc = repository.getRemoteInterface(type);
        MethodDescriptor[] mdesc = desc.getMethods();
        java.lang.Object[] descriptors = new MethodDescriptor[mdesc.length + 1];
        for (int i = 0; i < mdesc.length; ++i) {
            descriptors[i] = mdesc[i];
        }
        LOGGER.finer("TYPE ----> " + type);
        LOGGER.finer("LOADER --> " + UtilImpl.getClassLoader(type));
        LOGGER.finer("CONTEXT -> " + PortableRemoteObjectImpl.getClassLoader());
        MethodRef[] methods = new MethodRef[descriptors.length];
        for (int i = 0; i < mdesc.length; ++i) {
            Method m = descriptors[i].getReflectedMethod();
            LOGGER.finer("Method ----> " + m);
            methods[i] = new MethodRef(m);
        }
        methods[mdesc.length] = new MethodRef(stub_write_replace);
        Class clazz = null;
        try {
            clazz = StubClass.make(UtilImpl.getClassLoader(type), RMIStub.class, new Class[]{type}, methods, null, descriptors, PortableRemoteObjectImpl.getPOAStubInvokeMethod(), PortableRemoteObjectImpl.getPackageName(type), PortableRemoteObjectImpl.getRMIStubInitializer());
        }
        catch (NoClassDefFoundError ex) {
            clazz = StubClass.make(PortableRemoteObjectImpl.getClassLoader(), RMIStub.class, new Class[]{type}, methods, null, descriptors, PortableRemoteObjectImpl.getPOAStubInvokeMethod(), PortableRemoteObjectImpl.getPackageName(type), PortableRemoteObjectImpl.getRMIStubInitializer());
        }
        if (clazz != null) {
            try {
                cons = clazz.getConstructor(new Class[0]);
                state.stub_map.put(type, cons);
            }
            catch (NoSuchMethodException e) {
                LOGGER.log(Level.FINER, "constructed stub has no default constructor", e);
            }
        }
        return cons;
    }

    static String getPackageName(Class clazz) {
        String class_name = clazz.getName();
        int idx = class_name.lastIndexOf(46);
        if (idx == -1) {
            return null;
        }
        return class_name.substring(0, idx);
    }

    static Method getPOAStubInvokeMethod() {
        if (poa_stub_invoke_method == null) {
            try {
                poa_stub_invoke_method = StubHandler.class.getDeclaredMethod("invoke", RMIStub.class, MethodDescriptor.class, java.lang.Object[].class);
            }
            catch (NoSuchMethodException ex) {
                throw new Error("cannot find RMI Stub handler invoke method", ex);
            }
        }
        return poa_stub_invoke_method;
    }

    public Remote toStub(Remote value) throws NoSuchObjectException {
        if (value instanceof Stub) {
            return value;
        }
        Tie tie = Util.getTie((Remote)value);
        if (tie == null) {
            throw new NoSuchObjectException("object not exported");
        }
        RMIServant servant = (RMIServant)tie;
        try {
            POA poa = servant.getRMIState().getPOA();
            Object ref = poa.servant_to_reference((Servant)servant);
            return (Remote)this.narrow(ref, servant.getJavaClass());
        }
        catch (ServantNotActive ex) {
            throw new RuntimeException("internal error: " + ex.getMessage(), ex);
        }
        catch (WrongPolicy ex) {
            throw new RuntimeException("internal error: " + ex.getMessage(), ex);
        }
    }

    public void exportObject(Remote obj) throws RemoteException {
        RMIState state = RMIState.current();
        try {
            state.checkShutDown();
        }
        catch (BAD_INV_ORDER ex) {
            throw new RemoteException("RMIState is deactivated", ex);
        }
        Tie tie = Util.getTie((Remote)obj);
        if (tie != null) {
            throw new RemoteException("object already exported");
        }
        RMIServant servant = new RMIServant(state);
        Util.registerTarget((Tie)servant, (Remote)obj);
        LOGGER.finer("exporting instance of " + obj.getClass().getName() + " in " + state.getName());
        try {
            servant._id = state.getPOA().activate_object((Servant)servant);
        }
        catch (ServantAlreadyActive ex) {
            throw new RemoteException("internal error: " + ex.getMessage(), ex);
        }
        catch (WrongPolicy ex) {
            throw new RemoteException("internal error: " + ex.getMessage(), ex);
        }
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        Util.unexportObject((Remote)obj);
    }

    private static StubInitializer getRMIStubInitializer() {
        if (initializer == null) {
            String factory = AccessController.doPrivileged(new GetSystemPropertyAction("org.apache.yoko.rmi.RMIStubInitializerClass", defaultInitializer));
            try {
                initializer = (StubInitializer)UtilLoader.loadServiceClass((String)factory, (String)"org.apache.yoko.rmi.RMIStubInitializerClass").newInstance();
            }
            catch (Exception e) {
                throw (INITIALIZE)new INITIALIZE("Can not create RMIStubInitializer: " + factory).initCause((Throwable)e);
            }
        }
        return initializer;
    }

    static {
        PortableRemoteObjectImpl.getRMIStubInitializer();
        NO_ARG = new java.lang.Object[0];
        try {
            stub_write_replace = RMIStub.class.getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.WARNING, "cannot initialize: \n" + ex.getMessage(), ex);
            throw new Error("cannot initialize", ex);
        }
        initializer = null;
    }
}

