/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import org.apache.yoko.rmi.impl.ArrayDescriptor;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

class ByteArrayDescriptor
extends ArrayDescriptor {
    ByteArrayDescriptor(Class type, Class elemType, TypeRepository rep) {
        super(type, elemType, rep);
    }

    public Serializable readValue(InputStream in, Map offsetMap, Integer key) {
        byte[] arr = new byte[in.read_long()];
        offsetMap.put(key, arr);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = in.read_octet();
        }
        return arr;
    }

    @Override
    public void writeValue(OutputStream out, Serializable value) {
        byte[] arr = (byte[])value;
        out.write_long(arr.length);
        out.write_octet_array(arr, 0, arr.length);
    }

    @Override
    Object copyObject(Object value, CopyState state) {
        if (((byte[])value).length == 0) {
            return value;
        }
        Object copy = ((byte[])value).clone();
        state.put(value, copy);
        return copy;
    }

    @Override
    void printFields(PrintWriter pw, Map recurse, Object val) {
        byte[] arr = (byte[])val;
        pw.print("length=" + arr.length + "; ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                pw.print(", ");
            }
            pw.print(arr[i]);
        }
    }
}

