/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.internal.classloader;

import com.ibm.ws.kernel.internal.classloader.DirectoryResourceHandler;
import com.ibm.ws.kernel.internal.classloader.JarFileClassLoader;
import com.ibm.ws.kernel.internal.classloader.ResourceEntry;
import com.ibm.ws.kernel.internal.classloader.ResourceHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.Manifest;

public class DirectoryResourceEntry
implements ResourceEntry {
    private final DirectoryResourceHandler handler;
    private final File file;

    public DirectoryResourceEntry(DirectoryResourceHandler handler, File file) {
        this.handler = handler;
        this.file = file;
    }

    @Override
    public ResourceHandler getResourceHandler() {
        return this.handler;
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.handler.getManifest();
    }

    @Override
    public Certificate[] getCertificates() {
        return null;
    }

    @Override
    public byte[] getBytes() throws IOException {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            byArray = JarFileClassLoader.getBytes(in, this.file.length());
        }
        catch (Throwable throwable) {
            JarFileClassLoader.close(in);
            throw throwable;
        }
        JarFileClassLoader.close(in);
        return byArray;
    }

    @Override
    public URL toURL() {
        return JarFileClassLoader.toURL(this.file);
    }
}

