/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.EmbeddedServerImpl;
import com.ibm.ws.kernel.boot.LaunchArguments;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import com.ibm.ws.kernel.boot.internal.ServerLock;
import com.ibm.ws.kernel.boot.internal.commands.ArchiveProcessor;
import com.ibm.ws.kernel.boot.internal.commands.PackageProcessor;
import com.ibm.ws.kernel.boot.logging.TextFileOutputStreamFactory;
import com.ibm.wsspi.kernel.embeddable.Server;
import com.ibm.wsspi.kernel.embeddable.ServerBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PackageCommand {
    final String serverName;
    final File wlpOutputRoot;
    final String serverConfigDir;
    final String serverOutputDir;
    final String osRequest;
    final BootstrapConfig bootProps;
    final String includeOption;
    final String archiveOption;

    public PackageCommand(BootstrapConfig bootProps, LaunchArguments launchArgs) {
        this.serverName = bootProps.getProcessName();
        this.bootProps = bootProps;
        this.serverConfigDir = bootProps.get("server.config.dir");
        this.serverOutputDir = bootProps.get("server.output.dir");
        this.wlpOutputRoot = bootProps.getCommonOutputRoot();
        this.osRequest = launchArgs.getOption("os");
        this.includeOption = launchArgs.getOption("include");
        this.archiveOption = launchArgs.getOption("archive");
    }

    public ReturnCode doPackage() {
        boolean isClient;
        boolean bl = isClient = this.bootProps.getProcessType() == "client";
        if (isClient) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.clientPackaging"), this.serverName));
        } else {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverPackaging"), this.serverName));
        }
        ServerLock serverLock = ServerLock.createServerLock(this.bootProps);
        ReturnCode packageRc = ReturnCode.PACKAGE_ACTION;
        SimpleDateFormat sdf = new SimpleDateFormat("yy.MM.dd_HH.mm.ss");
        Date date = new Date();
        String packageTimestamp = sdf.format(date);
        File archive = null;
        if (serverLock.testServerRunning()) {
            packageRc = ReturnCode.SERVER_ACTIVE_STATUS;
        } else {
            archive = this.getArchive(this.serverName, new File(this.serverOutputDir));
            File packageInfoFile = new File(this.serverOutputDir, "package_" + packageTimestamp + ".txt");
            this.generatePackageInfo(packageInfoFile, this.serverName, date);
            packageRc = this.packageServerRuntime(archive, false);
            FileUtils.recursiveClean(packageInfoFile);
        }
        if (isClient) {
            if (packageRc == ReturnCode.OK) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.clientPackageComplete"), this.serverName, archive.getAbsolutePath()));
            } else if (packageRc == ReturnCode.SERVER_ACTIVE_STATUS) {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.clientIsRunning"), this.serverName));
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.clientPackageUnreachable"), this.serverName));
            } else {
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.clientPackageException"), this.serverName));
            }
        } else if (packageRc == ReturnCode.OK) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverPackageComplete"), this.serverName, archive.getAbsolutePath()));
        } else if (packageRc == ReturnCode.SERVER_ACTIVE_STATUS) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverIsRunning"), this.serverName));
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverPackageUnreachable"), this.serverName));
        } else {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverPackageException"), this.serverName));
        }
        return packageRc;
    }

    private File getArchive(String archiveBaseName, File outputDir) {
        File archive;
        String packageTarget = this.archiveOption;
        if (packageTarget == null || packageTarget.isEmpty()) {
            packageTarget = archiveBaseName + "." + this.getDefaultPackageFormat();
            archive = new File(outputDir, packageTarget);
        } else {
            archive = new File(packageTarget = this.normalizePackageTargetName(packageTarget));
            if (!archive.isAbsolute()) {
                archive = new File(outputDir, packageTarget);
            }
        }
        return archive;
    }

    public ReturnCode doPackageRuntimeOnly() {
        System.out.println(BootstrapConstants.messages.getString("info.runtimePackaging"));
        File archive = this.getArchive("wlp", this.wlpOutputRoot);
        ReturnCode packageRc = this.packageServerRuntime(archive, true);
        if (packageRc == ReturnCode.OK) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.runtimePackageComplete"), archive.getAbsolutePath()));
        } else {
            System.out.println(BootstrapConstants.messages.getString("info.runtimePackageException"));
        }
        return packageRc;
    }

    private boolean includeMinifyorMinifyRunnable(String val) {
        if (PackageProcessor.IncludeOption.MINIFY.getValue().equals(val)) {
            return true;
        }
        return PackageProcessor.IncludeOption.MINIFYRUNNABLE.getValue().equals(val);
    }

    public ReturnCode packageServerRuntime(File packageFile, boolean runtimeOnly) {
        PackageProcessor processor;
        String includeValue = this.includeOption;
        Set<String> libertyFiles = null;
        if (this.includeMinifyorMinifyRunnable(includeValue)) {
            try {
                libertyFiles = this.getMinifyPathsForPackage();
            }
            catch (FailedWithReturnCodeException fwrc) {
                return fwrc.getReturnCode();
            }
            catch (FileNotFoundException fnf) {
                Debug.printStackTrace(fnf);
                String osMsg = this.osRequest;
                if (osMsg == null) {
                    osMsg = "any";
                }
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("unable.to.package.missing.file"), this.serverName, osMsg, fnf.getMessage()));
                return ReturnCode.ERROR_SERVER_PACKAGE;
            }
            catch (IOException e) {
                Debug.printStackTrace(e);
                System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.unable.to.package"), this.serverName, e));
                return ReturnCode.ERROR_SERVER_PACKAGE;
            }
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverPackagingBuildingArchive"), this.serverName));
        } else if (this.osRequest != null) {
            System.out.println(BootstrapConstants.messages.getString("error.os.without.include"));
            return ReturnCode.ERROR_SERVER_PACKAGE;
        }
        if (null != includeValue) {
            ArrayList<ArchiveProcessor.Pair<PackageProcessor.PackageOption, String>> options = new ArrayList<ArchiveProcessor.Pair<PackageProcessor.PackageOption, String>>();
            options.add(new ArchiveProcessor.Pair<PackageProcessor.PackageOption, String>(PackageProcessor.PackageOption.INCLUDE, includeValue));
            processor = new PackageProcessor(this.serverName, packageFile, this.bootProps, options, libertyFiles);
        } else {
            processor = new PackageProcessor(this.serverName, packageFile, this.bootProps, null, libertyFiles);
        }
        return processor.execute(runtimeOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePackageInfo(File packageInfoFile, String serverName, Date date) {
        BufferedWriter writer = null;
        try {
            FileOutputStream packageInfoStream = TextFileOutputStreamFactory.createOutputStream(packageInfoFile);
            writer = new BufferedWriter(new OutputStreamWriter(packageInfoStream));
            String includeValue = this.includeOption;
            if (null != includeValue) {
                if (null != this.osRequest) {
                    writer.append("Package server " + serverName + " with include option \"" + includeValue + "\" and os " + this.osRequest + " at " + date.toString() + ".\n");
                } else {
                    writer.append("Package server " + serverName + " with include option \"" + includeValue + "\" at " + date.toString() + ".\n");
                }
            } else {
                writer.append("Package server " + serverName + " all at " + date.toString() + ".\n");
            }
            Utils.tryToClose(writer);
        }
        catch (IOException e) {
            Debug.printStackTrace(e);
        }
        finally {
            Utils.tryToClose(writer);
        }
    }

    private String getDefaultPackageFormat() {
        if ("z/OS".equalsIgnoreCase(this.bootProps.get("os.name"))) {
            return "pax";
        }
        return "zip";
    }

    private String normalizePackageTargetName(String packageTarget) {
        if (packageTarget.contains(".")) {
            int poz = packageTarget.lastIndexOf(".");
            String ext = packageTarget.substring(poz);
            if (ext.equalsIgnoreCase(".zip") || ext.equalsIgnoreCase(".pax")) {
                return packageTarget.substring(0, poz) + "." + this.getDefaultPackageFormat();
            }
            if (ext.equalsIgnoreCase(".jar") && "zip".equals(this.getDefaultPackageFormat())) {
                return packageTarget;
            }
        }
        return packageTarget + "." + this.getDefaultPackageFormat();
    }

    private Set<String> getMinifyPathsForPackage() throws FileNotFoundException, IOException, FailedWithReturnCodeException {
        Set<String> results = null;
        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("info.serverPackagingCollectingInformation"), this.serverName));
        EmbeddedServerImpl server = (EmbeddedServerImpl)new ServerBuilder().setName(this.serverName).setOutputDir(new File(this.serverOutputDir).getParentFile()).setUserDir(this.bootProps.getUserRoot()).build();
        HashMap<String, String> minifyServerProps = new HashMap<String, String>();
        minifyServerProps.put("com.ibm.ws.liberty.content.request", "1.0.0");
        Future<Server.Result> launchFuture = server.start(minifyServerProps, new String[0]);
        boolean startProblem = false;
        try {
            Server.Result rc = launchFuture.get(10L, TimeUnit.MINUTES);
            if (rc == null || !rc.successful()) {
                if (rc != null) {
                    Debug.println(rc.getReturnCode());
                    if (rc.getException() != null) {
                        Debug.printStackTrace(rc.getException());
                    }
                }
                startProblem = true;
            }
        }
        catch (TimeoutException to) {
            Debug.printStackTrace(to);
            startProblem = true;
        }
        catch (InterruptedException e) {
            Debug.printStackTrace(e);
            startProblem = true;
        }
        catch (ExecutionException e) {
            Debug.printStackTrace(e);
            startProblem = true;
        }
        if (startProblem) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.minify.unable.to.start.server"), this.serverName));
            throw new FailedWithReturnCodeException(ReturnCode.ERROR_SERVER_PACKAGE);
        }
        results = server.getServerContent(this.osRequest);
        if (null == results) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.minify.unable.to.determine.features"), this.serverName));
            throw new FailedWithReturnCodeException(ReturnCode.ERROR_SERVER_PACKAGE);
        }
        Future<Server.Result> stopFuture = server.stop(new String[0]);
        boolean stopProblem = false;
        try {
            Server.Result rc = stopFuture.get(60L, TimeUnit.SECONDS);
            if (rc == null || !rc.successful()) {
                if (rc != null) {
                    Debug.println(rc.getReturnCode());
                    if (rc.getException() != null) {
                        Debug.printStackTrace(rc.getException());
                    }
                }
                stopProblem = true;
            }
        }
        catch (TimeoutException to) {
            Debug.printStackTrace(to);
            stopProblem = true;
        }
        catch (InterruptedException e) {
            Debug.printStackTrace(e);
            stopProblem = true;
        }
        catch (ExecutionException e) {
            Debug.printStackTrace(e);
            stopProblem = true;
        }
        if (stopProblem) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.minify.unable.to.stop.server"), this.serverName));
            throw new FailedWithReturnCodeException(ReturnCode.ERROR_SERVER_PACKAGE);
        }
        return results;
    }

    private static class FailedWithReturnCodeException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final ReturnCode rc;

        FailedWithReturnCodeException(ReturnCode rc) {
            this.rc = rc;
        }

        ReturnCode getReturnCode() {
            return this.rc;
        }
    }
}

