/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.weld;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.impl.ResourceInjectionBag;
import com.ibm.ws.cdi.interfaces.AbstractCDIArchive;
import com.ibm.ws.cdi.interfaces.Application;
import com.ibm.ws.cdi.interfaces.ArchiveType;
import com.ibm.ws.cdi.interfaces.CDIArchive;
import com.ibm.ws.cdi.interfaces.CDIRuntime;
import com.ibm.ws.cdi.interfaces.CDIUtils;
import com.ibm.ws.cdi.interfaces.Resource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.MetaData;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OnDemandArchive
extends AbstractCDIArchive
implements CDIArchive {
    private final Class<?> initialClass;
    private final Application application;
    private static final Map<Object, String> bdaNameCache;
    private static final String FALLBACK_BDA_NAME = "No_bundle_BDA";
    private static final String NULL_KEY = "NULL_KEY";
    static final long serialVersionUID = 7081600154303959004L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OnDemandArchive(CDIRuntime cdiRuntime, Application application, Class<?> initialClass) {
        super(OnDemandArchive.createName(initialClass), cdiRuntime);
        this.application = application;
        this.initialClass = initialClass;
    }

    private static String createName(Class<?> initialClass) {
        Object mapKey;
        String toReturn = null;
        Object object = mapKey = initialClass.getClassLoader() == null ? NULL_KEY : initialClass.getClassLoader();
        if (mapKey == NULL_KEY) {
            toReturn = "BdaForClassesLoadedByRootClassLoader";
        } else if (bdaNameCache.containsKey(mapKey)) {
            toReturn = bdaNameCache.get(mapKey);
        } else {
            Bundle bundle = FrameworkUtil.getBundle(initialClass);
            if (bundle == null) {
                toReturn = FALLBACK_BDA_NAME;
                bdaNameCache.put(mapKey, toReturn);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(CDIUtils.getSymbolicNameWithoutMinorOrMicroVersionPart(bundle.getSymbolicName()));
                sb.append("_");
                sb.append(CDIUtils.getOSGIVersionForBndName(bundle.getVersion()));
                toReturn = sb.toString();
                bdaNameCache.put(mapKey, toReturn);
            }
        }
        return toReturn;
    }

    @Override
    public J2EEName getJ2EEName() {
        return null;
    }

    @Override
    public ArchiveType getType() {
        return ArchiveType.ON_DEMAND_LIB;
    }

    @Override
    public ClassLoader getClassLoader() throws CDIException {
        ClassLoader classLoader = this.initialClass.getClassLoader();
        if (classLoader == null) {
            classLoader = this.application.getClassLoader();
        }
        return classLoader;
    }

    @Override
    public Set<String> getClassNames() {
        return Collections.singleton(this.initialClass.getName());
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public String getClientModuleMainClass() throws CDIException {
        return null;
    }

    @Override
    public List<String> getInjectionClassList() throws CDIException {
        return Collections.emptyList();
    }

    @Override
    public MetaData getMetaData() throws CDIException {
        return null;
    }

    @Override
    public ResourceInjectionBag getAllBindings() throws CDIException {
        return null;
    }

    @Override
    public String getClientAppCallbackHandlerName() throws CDIException {
        return null;
    }

    @Override
    public Set<String> getExtensionClasses() {
        return Collections.emptySet();
    }

    @Override
    public String getPath() {
        return null;
    }

    public Set<CDIArchive> getModuleLibraryArchives() throws CDIException {
        return Collections.emptySet();
    }

    @Override
    public Resource getResource(String path) {
        return null;
    }

    @Override
    public Set<String> getBeanDefiningAnnotations() throws CDIException {
        Annotation[] annotations;
        HashSet<String> beanDefiningAnnotations = new HashSet<String>();
        for (Annotation annotation : annotations = this.initialClass.getAnnotations()) {
            if (!CDIUtils.BEAN_DEFINING_META_ANNOTATIONS.contains(annotation.annotationType())) continue;
            beanDefiningAnnotations.add(this.initialClass.getName());
            break;
        }
        return beanDefiningAnnotations;
    }

    @Override
    public Set<String> getAnnotatedClasses(Set<String> annotations) throws CDIException {
        Annotation[] classAnnotations;
        HashSet<String> annotatedClasses = new HashSet<String>();
        for (Annotation annotation : classAnnotations = this.initialClass.getAnnotations()) {
            if (!annotations.contains(annotation.annotationType().getName())) continue;
            annotatedClasses.add(this.initialClass.getName());
            break;
        }
        return annotatedClasses;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(OnDemandArchive.class);
        bdaNameCache = new WeakHashMap<Object, String>();
    }
}

