/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.managedobject;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.impl.managedobject.AbstractManagedObjectFactory;
import com.ibm.ws.cdi.impl.managedobject.CDIManagedObjectState;
import com.ibm.ws.cdi.impl.managedobject.EJBInterceptorAroundConstructCallback;
import com.ibm.ws.cdi.impl.weld.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.interfaces.CDIRuntime;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectInvocationContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.manager.api.WeldManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CDIEJBManagedObjectFactoryImpl<T>
extends AbstractManagedObjectFactory<T>
implements ManagedObjectFactory<T> {
    private static final TraceComponent tc = Tr.register(CDIEJBManagedObjectFactoryImpl.class);
    private String _ejbName = null;
    private ManagedObjectFactory<T> defaultEJBManagedObjectFactory = null;
    private EjbDescriptor<T> _ejbDescriptor;
    static final long serialVersionUID = -6264855853762029490L;

    public CDIEJBManagedObjectFactoryImpl(Class<T> classToManage, String ejbName, CDIRuntime cdiRuntime, ManagedObjectFactory<T> defaultEJBManagedObjectFactory) {
        super(classToManage, cdiRuntime, false);
        this._ejbName = ejbName;
        this.defaultEJBManagedObjectFactory = defaultEJBManagedObjectFactory;
    }

    @Override
    protected synchronized WeldManager getBeanManager() {
        if (this._beanManager == null) {
            this.getEjbDescriptor();
        }
        return this._beanManager;
    }

    @Override
    protected synchronized WebSphereBeanDeploymentArchive getCurrentBeanDeploymentArchive() {
        if (this._bda == null) {
            this.getEjbDescriptor();
        }
        return this._bda;
    }

    @Override
    public ManagedObjectContext createContext() {
        Bean<T> bean = null;
        EjbDescriptor<T> ejbDescriptor = this.getEjbDescriptor();
        if (!ejbDescriptor.isMessageDriven()) {
            bean = this.getBean();
        }
        WeldManager beanManager = this.getBeanManager();
        WeldCreationalContext creationalContext = beanManager.createCreationalContext(bean);
        CDIManagedObjectState managedObjectContext = new CDIManagedObjectState(creationalContext);
        return managedObjectContext;
    }

    @Override
    protected synchronized Bean<T> getBean() {
        if (!this._beanLookupComplete) {
            EjbDescriptor<T> ejbDescriptor;
            WeldManager beanManager = this.getBeanManager();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Looking for EJB Bean: " + this._ejbName), (Object[])new Object[0]);
            }
            if ((ejbDescriptor = this.getEjbDescriptor()) != null) {
                this._bean = beanManager.getBean(ejbDescriptor);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this._bean != null) {
                    Tr.debug((TraceComponent)tc, (String)("Found EJB Bean: " + this._bean), (Object[])new Object[0]);
                }
            }
            this._beanLookupComplete = true;
            if (this._bean != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found a bean of class : " + this._bean.getBeanClass()), (Object[])new Object[0]);
                }
                if (!this._bean.getBeanClass().equals(this.getManagedObjectClass())) {
                    throw new IllegalStateException("Managed Class {" + this.getManagedObjectClass().getName() + "} does not match Bean Class {" + this._bean.getBeanClass().getName() + "}");
                }
            }
        }
        return this._bean;
    }

    private synchronized EjbDescriptor<T> getEjbDescriptor() {
        if (this._ejbDescriptor == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Looking for EJB Bean: " + this._ejbName), (Object[])new Object[0]);
            }
            WebSphereBeanDeploymentArchive bda = super.getCurrentBeanDeploymentArchive();
            WeldManager beanManager = null;
            beanManager = bda != null ? (WeldManager)bda.getBeanManager() : (WeldManager)this.cdiRuntime.getCurrentBeanManager();
            EjbDescriptor ejbDescriptor = beanManager.getEjbDescriptor(this._ejbName);
            if (ejbDescriptor == null) {
                Set<WebSphereBeanDeploymentArchive> children = bda.getDescendantBdas();
                Iterator<WebSphereBeanDeploymentArchive> itr = children.iterator();
                while (ejbDescriptor == null && itr.hasNext()) {
                    bda = itr.next();
                    beanManager = (WeldManager)bda.getBeanManager();
                    ejbDescriptor = beanManager.getEjbDescriptor(this._ejbName);
                }
                if (ejbDescriptor == null) {
                    children = bda.getWebSphereBeanDeploymentArchives();
                    itr = children.iterator();
                    while (ejbDescriptor == null && itr.hasNext()) {
                        bda = itr.next();
                        beanManager = (WeldManager)bda.getBeanManager();
                        ejbDescriptor = beanManager.getEjbDescriptor(this._ejbName);
                    }
                }
            }
            if (ejbDescriptor != null) {
                this._ejbDescriptor = ejbDescriptor;
                this._beanManager = beanManager;
                this._bda = bda;
            }
        }
        return this._ejbDescriptor;
    }

    @Override
    public ManagedObject<T> createManagedObject() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public ManagedObject<T> createManagedObject(ManagedObjectInvocationContext<T> invocationContext) throws Exception {
        if (this.getBean() == null) {
            return this.defaultEJBManagedObjectFactory.createManagedObject(invocationContext);
        }
        return super.createManagedObject(invocationContext);
    }

    @Override
    protected InjectionTarget<T> getInjectionTarget(boolean nonContextual) {
        EjbDescriptor<T> ejbDescriptor = this.getEjbDescriptor();
        InjectionTarget injectionTarget = this.getBeanManager().createInjectionTarget(ejbDescriptor);
        return injectionTarget;
    }

    @Override
    protected WeldCreationalContext<T> getCreationalContext(ManagedObjectInvocationContext<T> invocationContext) {
        ManagedObjectContext managedObjectContext = invocationContext.getManagedObjectContext();
        WeldCreationalContext creationalContext = (WeldCreationalContext)managedObjectContext.getContextData(WeldCreationalContext.class);
        EJBInterceptorAroundConstructCallback<T> callback = new EJBInterceptorAroundConstructCallback<T>(invocationContext);
        creationalContext.registerAroundConstructCallback(callback);
        creationalContext.setConstructorInterceptionSuppressed(true);
        return creationalContext;
    }

    public String toString() {
        return "CDI EJB Managed Object Factory for class: " + this._managedClass.getName();
    }
}

