/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractUtils;

public final class ChangeHistory {
    private final Stack history = new Stack();

    public void createdFile(final String filePath) {
        this.history.push(new Action(){

            public ReturnCode execute() {
                File file = new File(filePath);
                if (file.delete()) {
                    return ReturnCode.OK;
                }
                return new ReturnCode(3);
            }
        });
    }

    public void deletedFile(final String filePath, final byte[] originalFile) {
        this.history.push(new Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ReturnCode execute() {
                ReturnCode returnCode;
                FileOutputStream stream = null;
                try {
                    stream = new FileOutputStream(filePath);
                    stream.write(originalFile);
                    returnCode = ReturnCode.OK;
                }
                catch (IOException e) {
                    ReturnCode returnCode2;
                    try {
                        returnCode2 = new ReturnCode(3);
                    }
                    catch (Throwable throwable) {
                        SelfExtractUtils.tryToClose(stream);
                        throw throwable;
                    }
                    SelfExtractUtils.tryToClose(stream);
                    return returnCode2;
                }
                SelfExtractUtils.tryToClose(stream);
                return returnCode;
            }
        });
    }

    public void changedProps(final String filePath, final Map props) {
        this.history.push(new Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ReturnCode execute() {
                ReturnCode returnCode;
                File file = new File(filePath);
                Properties propsObj = new Properties();
                FileInputStream is = null;
                FileOutputStream os = null;
                try {
                    is = new FileInputStream(file);
                    propsObj.load(is);
                    Iterator entries = props.entrySet().iterator();
                    while (entries.hasNext()) {
                        Map.Entry entry = entries.next();
                        String key = (String)entry.getKey();
                        String value = ((String[])entry.getValue())[0];
                        propsObj.setProperty(key, value);
                    }
                    os = new FileOutputStream(file);
                    propsObj.store(os, null);
                    returnCode = ReturnCode.OK;
                }
                catch (IOException ioe) {
                    ReturnCode returnCode2;
                    try {
                        returnCode2 = new ReturnCode(3);
                    }
                    catch (Throwable throwable) {
                        SelfExtractUtils.tryToClose(is);
                        SelfExtractUtils.tryToClose(os);
                        throw throwable;
                    }
                    SelfExtractUtils.tryToClose(is);
                    SelfExtractUtils.tryToClose(os);
                    return returnCode2;
                }
                SelfExtractUtils.tryToClose(is);
                SelfExtractUtils.tryToClose(os);
                return returnCode;
            }
        });
    }

    public ReturnCode rollback() {
        while (!this.history.isEmpty()) {
            Action action = (Action)this.history.pop();
            ReturnCode ret = action.execute();
            if (ret.getCode() == 0) continue;
            return ret;
        }
        return ReturnCode.OK;
    }

    static interface Action {
        public ReturnCode execute();
    }
}

