/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.index;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.utils.index.FilteredIndexIterator;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.processor.utils.linkedlist.Cursor;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleLinkedListEntry;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;

public class Index {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(Index.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected LinkedList list;
    protected HashMap index;

    public Index() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Index");
        }
        this.list = new LinkedList();
        this.index = new HashMap(10);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Index", (Object)this);
        }
    }

    public synchronized Entry put(Object key, Object data) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{data});
        }
        Entry entry = this.put(key, data, new Type());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)entry);
        }
        return entry;
    }

    protected synchronized Entry put(Object key, Object data, Type type) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{data, type});
        }
        Entry entry = new Entry(key, data, type);
        this.add(entry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)entry);
        }
        return entry;
    }

    public synchronized Entry add(Entry entry) {
        Entry old;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"add", (Object)new Object[]{entry});
        }
        if ((old = (Entry)this.index.get(entry.key)) != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"removing old entry from index");
            }
            this.list.remove(old);
        }
        this.list.insertAtBottom(entry);
        this.index.put(entry.key, entry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"add", (Object)entry);
        }
        return entry;
    }

    public synchronized Object remove(Object key) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{key});
        }
        Object data = null;
        Entry entry = (Entry)this.index.remove(key);
        if (entry != null) {
            this.list.remove(entry);
            data = entry.data;
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"null entry - cannot remove from list");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove", (Object)data);
        }
        return data;
    }

    public synchronized boolean containsKey(Object key) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"containsKey", (Object)new Object[]{key});
        }
        boolean res = this.index.containsKey(key);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"containsKey", (Object)new Boolean(res));
        }
        return res;
    }

    public synchronized Object get(Object key) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"get", (Object)new Object[]{key});
        }
        Object data = this.get(key, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get", (Object)data);
        }
        return data;
    }

    public synchronized Object get(Object key, IndexFilter filter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"get", (Object)new Object[]{key, filter});
        }
        Object data = null;
        Entry entry = (Entry)this.index.get(key);
        if (entry != null && (filter == null || filter.matches(entry.type))) {
            data = entry.data;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get", (Object)data);
        }
        return data;
    }

    public synchronized Type getType(Object key) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getType", (Object)new Object[]{key});
        }
        Entry entry = (Entry)this.index.get(key);
        Type type = null;
        if (entry != null) {
            type = entry.type;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getType", (Object)type);
        }
        return type;
    }

    public synchronized void setType(Object key, Type type) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setType", (Object)new Object[]{key, type});
        }
        Entry entry = (Entry)this.index.get(key);
        entry.type = (Type)type.clone();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setType");
        }
    }

    public synchronized Cursor newCursor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newCursor");
        }
        Cursor cursor = this.list.newCursor("Index Cursor");
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newCursor", (Object)cursor);
        }
        return cursor;
    }

    public synchronized SIMPIterator iterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"iterator");
        }
        FilteredIndexIterator itr = new FilteredIndexIterator(this, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"iterator", (Object)itr);
        }
        return itr;
    }

    public synchronized SIMPIterator iterator(IndexFilter filter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"iterator", (Object)filter);
        }
        FilteredIndexIterator itr = new FilteredIndexIterator(this, filter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"iterator", (Object)itr);
        }
        return itr;
    }

    protected synchronized void remove(Entry entry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{entry});
        }
        this.list.remove(entry);
        this.index.remove(entry.key);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized int size() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"size");
        }
        int size = this.index.size();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"size", (Object)new Integer(size));
        }
        return size;
    }

    public synchronized boolean isEmpty() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isEmpty");
        }
        boolean isEmpty = this.index.isEmpty();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isEmpty", (Object)new Boolean(isEmpty));
        }
        return isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer("Index\n");
        Index index = this;
        synchronized (index) {
            for (Object key : this.index.keySet()) {
                buffer.append(key);
                buffer.append(" --> ");
                buffer.append(this.index.get(key));
                buffer.append("\n");
            }
            buffer.append("------------\n");
            buffer.append("Full List\n");
            for (Entry entry = (Entry)this.list.getFirst(); entry != null; entry = (Entry)entry.getNext()) {
                buffer.append(entry);
                buffer.append("\n");
            }
            buffer.append("------------\n");
        }
        return buffer.toString();
    }

    public static class Entry
    extends SimpleLinkedListEntry {
        public Object key;
        public Type type;

        protected Entry(Object key, Object data, Type type) {
            super(data);
            this.key = key;
            this.type = type;
        }
    }

    public static class Type
    implements Cloneable {
        public Object clone() {
            Object clone = null;
            try {
                clone = super.clone();
            }
            catch (CloneNotSupportedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.index.Type.clone", (String)"1:80:1.17", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.index.Index", "1:86:1.17"});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.utils.LockManager", "1:93:1.17", e}, null), (Throwable)e);
            }
            return clone;
        }
    }
}

