/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.service;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.AliasDestination;
import com.ibm.ws.sib.admin.BaseDestination;
import com.ibm.ws.sib.admin.InvalidFileStoreConfigurationException;
import com.ibm.ws.sib.admin.JsMEConfig;
import com.ibm.ws.sib.admin.JsMainAdminService;
import com.ibm.ws.sib.admin.SIBDestination;
import com.ibm.ws.sib.admin.SIBFileStore;
import com.ibm.ws.sib.admin.SIBLocalizationPoint;
import com.ibm.ws.sib.admin.SIBMessagingEngine;
import com.ibm.ws.sib.admin.SIBus;
import com.ibm.ws.sib.admin.internal.AliasDestinationImpl;
import com.ibm.ws.sib.admin.internal.JsAdminConstants;
import com.ibm.ws.sib.admin.internal.JsMainImpl;
import com.ibm.ws.sib.admin.internal.SIBDestinationImpl;
import com.ibm.ws.sib.admin.internal.SIBFileStoreImpl;
import com.ibm.ws.sib.admin.internal.SIBLocalizationPointImpl;
import com.ibm.ws.sib.admin.internal.SIBMessagingEngineImpl;
import com.ibm.ws.sib.admin.internal.SIBusImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.sib.core.DestinationType;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.component.ComponentContext;

public class JsMainAdminServiceImpl
extends JsMainAdminService {
    private static final TraceComponent tc = SibTr.register(JsMainAdminServiceImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static JsMEConfig jsMEConfig = new JsMEConfig();
    private String _state = JsAdminConstants.ME_STATE.STOPPED.toString();
    private JsMainImpl _jsMainImpl = null;
    private volatile Map<String, Object> properties;
    private final Set<String> pids = new HashSet<String>();

    public void activate(ComponentContext context, Map<String, Object> properties, ConfigurationAdmin configAdmin) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"activate", (Object)new Object[]{context, properties, configAdmin});
        }
        try {
            this._state = JsAdminConstants.ME_STATE.STARTING.toString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Starting the JMS server.");
            }
            this.initialize(context, properties, configAdmin);
            this._jsMainImpl = new JsMainImpl(context.getBundleContext());
            this._jsMainImpl.initialize(jsMEConfig);
            this._jsMainImpl.start();
            this._state = JsAdminConstants.ME_STATE.STARTED.toString();
            SibTr.info((TraceComponent)tc, (String)"ME_STARTED_SIAS0108");
        }
        catch (InvalidFileStoreConfigurationException ifs) {
            this._state = JsAdminConstants.ME_STATE.STOPPED.toString();
            SibTr.error((TraceComponent)tc, (String)"ME_STOPPED_SIAS0109");
            SibTr.exception((TraceComponent)tc, (Exception)((Object)ifs));
            FFDCFilter.processException((Throwable)ifs, (String)"com.ibm.ws.messaging.service.JsMainAdminServiceImpl", (String)"132", (Object)((Object)this));
        }
        catch (Exception e) {
            this._state = JsAdminConstants.ME_STATE.STOPPED.toString();
            SibTr.error((TraceComponent)tc, (String)"ME_STOPPED_SIAS0109");
            SibTr.exception((TraceComponent)tc, (Exception)e);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.messaging.service.JsMainAdminServiceImpl", (String)"139", (Object)((Object)this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"activate");
        }
    }

    private void initialize(ComponentContext context, Map<String, Object> properties, ConfigurationAdmin configAdmin) throws InvalidFileStoreConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize", (Object)new Object[]{context, properties});
        }
        this.properties = properties;
        SIBFileStoreImpl filestore = new SIBFileStoreImpl();
        this.populateFileStore(properties, filestore, configAdmin);
        SIBusImpl bus = new SIBusImpl();
        SIBMessagingEngineImpl messagingEngine = new SIBMessagingEngineImpl();
        messagingEngine.setHighMessageThreshold((Long)properties.get("highMessageThreshold"));
        HashMap<String, BaseDestination> destinationList = new HashMap<String, BaseDestination>();
        HashMap<String, SIBLocalizationPoint> destinationLocalizationList = new HashMap<String, SIBLocalizationPoint>();
        this.populateDestinations(properties, destinationList, destinationLocalizationList, messagingEngine.getName(), "queue", configAdmin, false);
        this.populateDestinations(properties, destinationList, destinationLocalizationList, messagingEngine.getName(), "topicSpace", configAdmin, false);
        this.populateAliasDestinations(properties, destinationList, configAdmin);
        messagingEngine.setDestinationList(destinationList);
        messagingEngine.setSibLocalizationPointList(destinationLocalizationList);
        jsMEConfig.setMessagingEngine((SIBMessagingEngine)messagingEngine);
        jsMEConfig.setSIBFilestore((SIBFileStore)filestore);
        jsMEConfig.setSIBus((SIBus)bus);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    private void populateDestinations(Map<String, Object> properties, HashMap<String, BaseDestination> destinationList, HashMap<String, SIBLocalizationPoint> destinationLocalizationList, String meName, String destinationType, ConfigurationAdmin configAdmin, boolean modified) {
        boolean exceptionDestinationProvided;
        boolean defaultQueueTopicProvided;
        block26: {
            block21: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"populateDestinations", (Object)new Object[]{properties, destinationList, destinationLocalizationList, meName, destinationType, configAdmin});
                }
                String[] destinations = (String[])properties.get(destinationType);
                defaultQueueTopicProvided = false;
                exceptionDestinationProvided = false;
                if (destinations == null) break block21;
                for (String destinationPid : destinations) {
                    block22: {
                        SIBLocalizationPointImpl destinationLocalization;
                        SIBDestinationImpl destination;
                        Dictionary destinationProperties;
                        block25: {
                            block23: {
                                String failedDeliveryPolicy;
                                block24: {
                                    String forceReliability;
                                    String destinationName;
                                    this.pids.add(destinationPid);
                                    Configuration config = null;
                                    try {
                                        config = configAdmin.getConfiguration(destinationPid);
                                    }
                                    catch (IOException e) {
                                        SibTr.exception((TraceComponent)tc, (Exception)e);
                                        FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"369", (Object)((Object)this));
                                    }
                                    destinationProperties = config.getProperties();
                                    destination = new SIBDestinationImpl();
                                    destinationLocalization = new SIBLocalizationPointImpl();
                                    if (destinationProperties == null) break block22;
                                    if (destinationProperties.get("id") == null || destinationProperties.get("id").toString().trim().isEmpty()) break block23;
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Destination ID :  " + destinationProperties.get("id")));
                                    }
                                    if (destinationList.containsKey(destinationName = (String)destinationProperties.get("id"))) {
                                        SibTr.warning((TraceComponent)tc, (String)"SAME_DEST_ID_SIAS0123", (Object)new Object[]{destinationName});
                                        continue;
                                    }
                                    destination.setName(destinationName);
                                    if (destinationType.equals("queue")) {
                                        destination.setDestinationType(DestinationType.QUEUE);
                                        if (destinationProperties.get("id").equals("Default.Queue")) {
                                            defaultQueueTopicProvided = true;
                                        }
                                        if (destinationProperties.get("id").equals("_SYSTEM.Exception.Destination")) {
                                            exceptionDestinationProvided = true;
                                        }
                                    } else {
                                        destination.setDestinationType(DestinationType.TOPICSPACE);
                                        if (destinationProperties.get("id").equals("Default.Topic.Space")) {
                                            defaultQueueTopicProvided = true;
                                        }
                                    }
                                    destination.setLocal(true);
                                    destination.setAlias(false);
                                    String defaultReliability = forceReliability = (String)destinationProperties.get("forceReliability");
                                    String maxReliability = forceReliability;
                                    destination.setDefaultAndMaxReliability(defaultReliability, maxReliability, jsMEConfig, modified);
                                    String exceptionDest = (String)destinationProperties.get("exceptionDestination");
                                    if (exceptionDest.trim().isEmpty()) {
                                        destination.setExceptionDestination("_SYSTEM.Exception.Destination");
                                    } else {
                                        destination.setExceptionDestination(exceptionDest);
                                    }
                                    failedDeliveryPolicy = (String)destinationProperties.get("failedDeliveryPolicy");
                                    Long redeliveryInterval = (Long)destinationProperties.get("redeliveryInterval");
                                    if (redeliveryInterval < 1L) {
                                        redeliveryInterval = 5000L;
                                    }
                                    destination.setBlockedRetryTimeout(redeliveryInterval);
                                    if (!failedDeliveryPolicy.equals("KEEP_TRYING")) break block24;
                                    destination.setFailedDeliveryPolicy(failedDeliveryPolicy);
                                    destination.setExceptionDestination(null);
                                    break block25;
                                }
                                if (!failedDeliveryPolicy.equals("DISCARD")) break block25;
                                destination.setExceptionDestination(null);
                                destination.setExceptionDiscardReliability("AssuredPersistent");
                                break block25;
                            }
                            SibTr.error((TraceComponent)tc, (String)"NO_ID_PROVIDED_SIAS0102", (Object)new Object[]{destinationType});
                            continue;
                        }
                        Integer maxRedeliveryCount = (Integer)destinationProperties.get("maxRedeliveryCount");
                        destination.setMaxFailedDeliveries(maxRedeliveryCount);
                        destination.setSendAllowed((Boolean)destinationProperties.get("sendAllowed"));
                        destination.setReceiveAllowed((Boolean)destinationProperties.get("receiveAllowed"));
                        Boolean maintainStrictOrder = (Boolean)destinationProperties.get("maintainStrictOrder");
                        destination.setMaintainStrictOrder(maintainStrictOrder);
                        destination.setReceiveExclusive(maintainStrictOrder);
                        Long maxQueueDepth = (Long)destinationProperties.get("maxMessageDepth");
                        destination.setHighMessageThreshold(maxQueueDepth);
                        destinationLocalization.setIdentifier(destination.getName() + "@" + meName);
                        destinationLocalization.setSendAllowed(destination.isSendAllowed());
                        destinationLocalization.setHighMsgThreshold(destination.getHighMessageThreshold());
                        destinationList.put(destination.getName(), destination);
                        destinationLocalizationList.put(destination.getName() + "@" + meName, destinationLocalization);
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) continue;
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"destinationProperties is null");
                }
                break block26;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("No " + destinationType + "defined in server.xml"));
            }
        }
        if (destinationType.equals("queue") && !exceptionDestinationProvided && !modified) {
            SIBDestinationImpl exceptionDest = new SIBDestinationImpl("_SYSTEM.Exception.Destination", DestinationType.QUEUE);
            exceptionDest.setExceptionDestination(null);
            SIBLocalizationPointImpl exceptionDestLocalization = new SIBLocalizationPointImpl();
            exceptionDestLocalization.setIdentifier(exceptionDest.getName() + "@" + meName);
            exceptionDestLocalization.setSendAllowed(exceptionDest.isSendAllowed());
            exceptionDestLocalization.setHighMsgThreshold(exceptionDest.getHighMessageThreshold());
            destinationList.put(exceptionDest.getName(), exceptionDest);
            destinationLocalizationList.put(exceptionDest.getName() + "@" + meName, exceptionDestLocalization);
        }
        if (destinationType.equals("queue") && !defaultQueueTopicProvided) {
            if (!modified) {
                SIBDestinationImpl defaultQueue = new SIBDestinationImpl("Default.Queue", DestinationType.QUEUE);
                SIBLocalizationPointImpl defaultQueueLocalization = new SIBLocalizationPointImpl();
                defaultQueueLocalization.setIdentifier(defaultQueue.getName() + "@" + meName);
                defaultQueueLocalization.setSendAllowed(defaultQueue.isSendAllowed());
                defaultQueueLocalization.setHighMsgThreshold(defaultQueue.getHighMessageThreshold());
                destinationList.put(defaultQueue.getName(), defaultQueue);
                destinationLocalizationList.put(defaultQueue.getName() + "@" + meName, defaultQueueLocalization);
            }
        } else if (destinationType.equals("topicSpace") && !defaultQueueTopicProvided && !modified) {
            SIBDestinationImpl defaultTopic = new SIBDestinationImpl("Default.Topic.Space", DestinationType.TOPICSPACE);
            SIBLocalizationPointImpl defaultTopicLocalization = new SIBLocalizationPointImpl();
            defaultTopicLocalization.setIdentifier(defaultTopic.getName() + "@" + meName);
            defaultTopicLocalization.setSendAllowed(defaultTopic.isSendAllowed());
            defaultTopicLocalization.setHighMsgThreshold(defaultTopic.getHighMessageThreshold());
            destinationList.put(defaultTopic.getName(), defaultTopic);
            destinationLocalizationList.put(defaultTopic.getName() + "@" + meName, defaultTopicLocalization);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"populateDestiantions", (Object)new Object[]{destinationList});
        }
    }

    private void populateAliasDestinations(Map<String, Object> properties, HashMap<String, BaseDestination> destinationList, ConfigurationAdmin configAdmin) {
        String[] aliasDestinations;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"populateAliasDestinations", (Object)new Object[]{properties, destinationList, configAdmin});
        }
        if ((aliasDestinations = (String[])properties.get("alias")) != null) {
            for (String aliasDestinationPid : aliasDestinations) {
                String receiveAllowed;
                String sendAllowed;
                this.pids.add(aliasDestinationPid);
                Configuration config = null;
                try {
                    config = configAdmin.getConfiguration(aliasDestinationPid);
                }
                catch (IOException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"561", (Object)((Object)this));
                }
                Dictionary aliasDestinationProperties = config.getProperties();
                AliasDestinationImpl aliasDest = new AliasDestinationImpl();
                String aliasDestinationName = (String)aliasDestinationProperties.get("id");
                String targetDestinationName = (String)aliasDestinationProperties.get("targetDestination");
                if (destinationList.containsKey(aliasDestinationName)) {
                    SibTr.error((TraceComponent)tc, (String)"ALIAS_SAME_DEST_ID_SIAS0125", (Object)new Object[]{aliasDestinationName});
                    continue;
                }
                if (aliasDestinationName != null && !aliasDestinationName.toString().trim().isEmpty()) {
                    if (targetDestinationName == null || targetDestinationName.toString().trim().isEmpty()) {
                        SibTr.error((TraceComponent)tc, (String)"INVALID_TARGET_DEST_SIAS0110", (Object)new Object[]{aliasDestinationProperties.get("id")});
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Destination ID :  " + aliasDestinationProperties.get("id")));
                    }
                    aliasDest.setName(aliasDestinationName);
                    aliasDest.setTargetDestination(targetDestinationName);
                    aliasDest.setLocal(false);
                    aliasDest.setAlias(true);
                    String forceReliablility = (String)aliasDestinationProperties.get("forceReliability");
                    aliasDest.setDefaultReliability(forceReliablility);
                    aliasDest.setMaximumReliability(forceReliablility);
                    sendAllowed = "false";
                    receiveAllowed = "false";
                    if (destinationList.get(targetDestinationName) instanceof SIBDestination) {
                        SIBDestination targetDestination = (SIBDestination)destinationList.get(targetDestinationName);
                        if (targetDestination.isSendAllowed()) {
                            sendAllowed = (String)aliasDestinationProperties.get("sendAllowed");
                        }
                        receiveAllowed = String.valueOf(targetDestination.isReceiveAllowed());
                    }
                } else {
                    SibTr.error((TraceComponent)tc, (String)"NO_ID_PROVIDED_SIAS0102", (Object)new Object[]{"alias"});
                    continue;
                }
                aliasDest.setSendAllowed(sendAllowed);
                aliasDest.setReceiveAllowed(receiveAllowed);
                destinationList.put(aliasDest.getName(), aliasDest);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"populateAliasDestinations", (Object)new Object[]{destinationList});
        }
    }

    private void populateFileStore(Map<String, Object> properties, SIBFileStore filestore, ConfigurationAdmin configAdmin) throws InvalidFileStoreConfigurationException {
        String[] sFileStore;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"populateFileStore", (Object)new Object[]{properties, filestore, configAdmin});
        }
        if ((sFileStore = (String[])properties.get("fileStore")) == null) {
            String path = null;
            path = this.resolveFileStorePath(filestore.getPath());
            filestore.setPath(path);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("The filestore path: " + path));
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"FileStore tag has not been defined in the server.xml file, hence defaults will be considered.");
            }
        } else {
            this.pids.add(sFileStore[0]);
            Configuration config = null;
            try {
                config = configAdmin.getConfiguration(sFileStore[0]);
            }
            catch (IOException e) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"671", (Object)((Object)this));
            }
            Dictionary fsProp = config.getProperties();
            String fsPath = (String)fsProp.get("path");
            File dummyFile = new File(fsPath);
            if (dummyFile.isAbsolute()) {
                filestore.setPath(fsPath);
            } else {
                String completePath = "${server.output.dir}//messaging/" + fsPath;
                filestore.setPath(this.resolveFileStorePath(completePath));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("The filestore path: " + filestore.getPath()));
            }
            filestore.setFileStoreSize((Long)fsProp.get("fileStoreSize") * 1024L * 1024L);
            filestore.setLogFileSize((Long)fsProp.get("logFileSize") * 1024L * 1024L);
            filestore.validateFileStoreSettings();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"populateFileStore");
        }
    }

    private String resolveFileStorePath(String fileStorePath) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolveFileStorePath", (Object)new Object[]{fileStorePath});
        }
        String filePath = null;
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(WsLocationAdmin.class).getBundleContext();
            ServiceReference locationAdminRef = bundleContext.getServiceReference(WsLocationAdmin.class);
            WsLocationAdmin locationAdmin = (WsLocationAdmin)bundleContext.getService(locationAdminRef);
            filePath = locationAdmin.resolveString(fileStorePath);
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
            FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"720", (Object)((Object)this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resolveFileStorePath", (Object)new Object[]{filePath});
        }
        return filePath;
    }

    public void modified(ComponentContext context, Map<String, Object> properties, ConfigurationAdmin configAdmin) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"modified", (Object)new Object[]{context, properties, configAdmin});
        }
        this.properties = properties;
        this.internalModify(configAdmin);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"modified");
        }
    }

    private synchronized void internalModify(ConfigurationAdmin configAdmin) {
        this.pids.clear();
        try {
            String localizationName;
            JsMEConfig newConfig = new JsMEConfig();
            SIBMessagingEngineImpl messagingEngine = new SIBMessagingEngineImpl();
            messagingEngine.setHighMessageThreshold((Long)this.properties.get("highMessageThreshold"));
            HashMap<String, BaseDestination> destinationList = new HashMap<String, BaseDestination>();
            HashMap<String, SIBLocalizationPoint> destinationLocalizationList = new HashMap<String, SIBLocalizationPoint>();
            this.populateDestinations(this.properties, destinationList, destinationLocalizationList, messagingEngine.getName(), "queue", configAdmin, true);
            this.populateDestinations(this.properties, destinationList, destinationLocalizationList, messagingEngine.getName(), "topicSpace", configAdmin, true);
            if (!destinationList.containsKey("Default.Queue")) {
                destinationList.put("Default.Queue", (BaseDestination)jsMEConfig.getMessagingEngine().getDestinationList().get("Default.Queue"));
                localizationName = "Default.Queue@" + messagingEngine.getName();
                destinationLocalizationList.put(localizationName, (SIBLocalizationPoint)jsMEConfig.getMessagingEngine().getSibLocalizationPointList().get(localizationName));
            }
            if (!destinationList.containsKey("Default.Topic.Space")) {
                destinationList.put("Default.Topic.Space", (BaseDestination)jsMEConfig.getMessagingEngine().getDestinationList().get("Default.Topic.Space"));
                localizationName = "Default.Topic.Space@" + messagingEngine.getName();
                destinationLocalizationList.put(localizationName, (SIBLocalizationPoint)jsMEConfig.getMessagingEngine().getSibLocalizationPointList().get(localizationName));
            }
            if (!destinationList.containsKey("_SYSTEM.Exception.Destination")) {
                destinationList.put("_SYSTEM.Exception.Destination", (BaseDestination)jsMEConfig.getMessagingEngine().getDestinationList().get("_SYSTEM.Exception.Destination"));
                localizationName = "_SYSTEM.Exception.Destination@" + messagingEngine.getName();
                destinationLocalizationList.put(localizationName, (SIBLocalizationPoint)jsMEConfig.getMessagingEngine().getSibLocalizationPointList().get(localizationName));
            }
            this.populateAliasDestinations(this.properties, destinationList, configAdmin);
            messagingEngine.setDestinationList(destinationList);
            messagingEngine.setSibLocalizationPointList(destinationLocalizationList);
            newConfig.setMessagingEngine((SIBMessagingEngine)messagingEngine);
            newConfig.setSIBFilestore(jsMEConfig.getSibFilestore());
            newConfig.setSIBus(jsMEConfig.getSIBus());
            this.compareAndTakeAction(newConfig);
            jsMEConfig = newConfig;
        }
        catch (Exception e) {
            SibTr.error((TraceComponent)tc, (String)"MODIFICATION_UNSUCCESSFUL_SIAS0117");
            SibTr.exception((TraceComponent)tc, (Exception)e);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.messaging.service.JsMainAdminServiceImpl", (String)"852", (Object)((Object)this));
        }
    }

    private void compareAndTakeAction(JsMEConfig newConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"compareAndTakeAction", (Object)newConfig);
        }
        TreeSet newDestinationSet = new TreeSet(newConfig.getMessagingEngine().getDestinationList().keySet());
        TreeSet oldDestinationSet = new TreeSet(jsMEConfig.getMessagingEngine().getDestinationList().keySet());
        TreeSet completeDestinationSet = new TreeSet();
        TreeSet<String> deletedDestinationSet = new TreeSet<String>();
        TreeSet<String> addedDestinationSet = new TreeSet<String>();
        TreeSet<String> modifiedDestinationSet = new TreeSet<String>();
        completeDestinationSet.addAll(oldDestinationSet);
        completeDestinationSet.addAll(newDestinationSet);
        for (String key : completeDestinationSet) {
            if (jsMEConfig.getMessagingEngine().getDestinationList().containsKey(key)) {
                if (newConfig.getMessagingEngine().getDestinationList().containsKey(key)) {
                    modifiedDestinationSet.add(key);
                    continue;
                }
                deletedDestinationSet.add(key);
                continue;
            }
            addedDestinationSet.add(key);
        }
        Iterator mit = modifiedDestinationSet.iterator();
        while (mit.hasNext()) {
            String meName = newConfig.getMessagingEngine().getName();
            String destinationName = (String)mit.next();
            ((BaseDestination)newConfig.getMessagingEngine().getDestinationList().get(destinationName)).setUUID(((BaseDestination)jsMEConfig.getMessagingEngine().getDestinationList().get(destinationName)).getUUID());
            BaseDestination bd = (BaseDestination)newConfig.getMessagingEngine().getDestinationList().get(destinationName);
            if (!bd.isLocal()) continue;
            String uuid = ((SIBLocalizationPoint)jsMEConfig.getMessagingEngine().getSibLocalizationPointList().get(destinationName + "@" + meName)).getUuid();
            String targetUuid = ((SIBLocalizationPoint)jsMEConfig.getMessagingEngine().getSibLocalizationPointList().get(destinationName + "@" + meName)).getTargetUuid();
            ((SIBLocalizationPoint)newConfig.getMessagingEngine().getSibLocalizationPointList().get(destinationName + "@" + meName)).setUuid(uuid);
            ((SIBLocalizationPoint)newConfig.getMessagingEngine().getSibLocalizationPointList().get(destinationName + "@" + meName)).setTargetUuid(targetUuid);
        }
        mit = modifiedDestinationSet.iterator();
        while (mit.hasNext()) {
            String key = (String)mit.next();
            BaseDestination modifiedDestination = (BaseDestination)newConfig.getMessagingEngine().getDestinationList().get(key);
            BaseDestination oldDestination = (BaseDestination)jsMEConfig.getMessagingEngine().getDestinationList().get(key);
            if (modifiedDestination.isLocal()) {
                if (!((SIBDestination)modifiedDestination).equals(oldDestination)) continue;
                mit.remove();
                continue;
            }
            if (!modifiedDestination.isAlias() || !((AliasDestination)modifiedDestination).equals(oldDestination)) continue;
            mit.remove();
        }
        if (jsMEConfig.getMessagingEngine().getHighMessageThreshold() != newConfig.getMessagingEngine().getHighMessageThreshold()) {
            try {
                this._jsMainImpl.reloadEngine(newConfig.getMessagingEngine().getHighMessageThreshold());
            }
            catch (Exception e) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"972", (Object)((Object)this));
            }
        }
        for (String key : deletedDestinationSet) {
            try {
                this._jsMainImpl.deleteDestinationLocalization((BaseDestination)jsMEConfig.getMessagingEngine().getDestinationList().get(key));
            }
            catch (Exception e) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"974", (Object)((Object)this));
            }
        }
        for (String key : addedDestinationSet) {
            try {
                this._jsMainImpl.createDestinationLocalization((BaseDestination)newConfig.getMessagingEngine().getDestinationList().get(key));
            }
            catch (Exception e) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"992", (Object)((Object)this));
            }
        }
        for (String key : modifiedDestinationSet) {
            try {
                this._jsMainImpl.alterDestinationLocalization((BaseDestination)newConfig.getMessagingEngine().getDestinationList().get(key));
            }
            catch (Exception e) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"1010", (Object)((Object)this));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"compareAndTakeAction");
        }
    }

    public void deactivate(ComponentContext context, Map<String, Object> properties) {
        try {
            this._jsMainImpl.stop();
            this._jsMainImpl.destroy();
            SibTr.info((TraceComponent)tc, (String)"ME_STOPPED_SIAS0121");
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
    }

    public String getMeState() {
        return this._state;
    }

    public void setMeState(String state) {
        this._state = state;
    }

    public void configurationEvent(ConfigurationEvent event, ConfigurationAdmin configAdmin) {
        if (event.getType() == 1 && this.pids.contains(event.getPid())) {
            this.internalModify(configAdmin);
        }
    }
}

