/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.utils;

import com.ibm.crypto.provider.IBMJCE;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkRejectionException;
import com.ibm.security.certclient.util.PkCertUtils;
import com.ibm.security.certclient.util.PkNewCertFactory;
import com.ibm.security.certclient.util.PkNewCertificate;
import com.ibm.security.certclient.util.PkSsCertFactory;
import com.ibm.security.certclient.util.PkSsCertificate;
import com.ibm.ws.collective.utility.ICertificateUtility;
import com.ibm.ws.collective.utility.utils.CommandUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;

public class CertificateUtility
implements ICertificateUtility {
    static final String SLASH = String.valueOf(File.separatorChar);
    private static final String JKS_STORE_TYPE = "jks";
    private final PrintStream stdout;
    private final PrintStream stderr;

    public CertificateUtility(PrintStream stdout, PrintStream stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
        Security.addProvider((Provider)new IBMJCE());
    }

    private String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    @Override
    public KeyStore createKeystore(File ksFile, char[] ksPassword) {
        KeyStore ks = null;
        try {
            ks = PkCertUtils.keyStore((String)JKS_STORE_TYPE, (String)ksFile.getCanonicalPath(), (char[])ksPassword);
        }
        catch (PkException e) {
            e.printStackTrace(this.stderr);
        }
        catch (IOException e) {
            e.printStackTrace(this.stderr);
        }
        return ks;
    }

    @Override
    public PkSsCertificate createSelfSignedCACert(String subjectDN, int validity) {
        int keySize = 2048;
        Date notBefore = null;
        boolean useShortSubjectKId = false;
        List subjectAltNames = null;
        List kUsage = null;
        List extKUsage = null;
        String provider = "IBMJCE";
        KeyPair keyPair = null;
        boolean CA = true;
        String keyType = "RSA";
        String sigAlg = "SHA256withRSA";
        try {
            return PkSsCertFactory.newSsCert((int)keySize, (String)keyType, (String)sigAlg, (String)subjectDN, (int)validity, notBefore, (boolean)useShortSubjectKId, subjectAltNames, kUsage, extKUsage, (String)provider, keyPair, (boolean)CA);
        }
        catch (PkRejectionException e) {
            e.printStackTrace(this.stderr);
            return null;
        }
    }

    @Override
    public PkNewCertificate createSignedCert(String subjectDN, int validity, PkSsCertificate signingCert) {
        int keySize = 2048;
        Date notBefore = null;
        boolean useShortSubjectKId = false;
        String provider = "IBMJCE";
        X509Certificate[] signing_cert_chain = new X509Certificate[]{signingCert.getCertificate()};
        PrivateKey signing_cert_private_key = signingCert.getKey();
        try {
            return PkNewCertFactory.newCert((int)keySize, (String)subjectDN, (int)validity, notBefore, (boolean)useShortSubjectKId, (String)provider, (X509Certificate[])signing_cert_chain, (PrivateKey)signing_cert_private_key);
        }
        catch (PkRejectionException e) {
            e.printStackTrace(this.stderr);
            return null;
        }
    }

    @Override
    public boolean setToKeyStore(PkSsCertificate ssCert, KeyStore ks, String keyPassword, String alias) {
        try {
            ssCert.setToKeyStore(alias, keyPassword, ks);
            return true;
        }
        catch (PkException e) {
            e.printStackTrace(this.stderr);
            return false;
        }
    }

    @Override
    public boolean setToKeyStore(PkNewCertificate ssCert, KeyStore ks, String keyPassword, String alias) {
        try {
            ssCert.setToKeyStore(alias, keyPassword, ks);
            return true;
        }
        catch (PkException e) {
            e.printStackTrace(this.stderr);
            return false;
        }
    }

    @Override
    public boolean setCertToKeyStore(X509Certificate cert, KeyStore ks, String alias) {
        try {
            ks.setCertificateEntry(alias, cert);
            return true;
        }
        catch (KeyStoreException e) {
            e.printStackTrace(this.stderr);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveKeyStore(KeyStore ks, File ksFile, String ksPassword) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(ksFile);
            ks.store(os, ksPassword.toCharArray());
            os.flush();
            boolean bl = true;
            return bl;
        }
        catch (KeyStoreException e) {
            e.printStackTrace(this.stderr);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace(this.stderr);
        }
        catch (CertificateException e) {
            e.printStackTrace(this.stderr);
        }
        catch (IOException e) {
            e.printStackTrace(this.stderr);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    e.printStackTrace(this.stderr);
                }
            }
        }
        this.stdout.println(this.getMessage("create.failedKSSave", ksFile.getAbsolutePath()));
        return false;
    }
}

