/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyGenerator;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utils.PasswordMaskUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Map;
import javax.management.RuntimeMBeanException;

public class UpdateHostTask
extends BaseCommandTask {
    private static final TraceComponent tc = Tr.register(UpdateHostTask.class);
    private final SSHKeyGenerator sshKeyGen;
    private final SSHKeyUtility sshKeyUtil;
    private final ICollectiveRegistrationMBeanConnection registrationMBean;

    public UpdateHostTask(String scriptName, IFileUtility fileUtility, SSHKeyGenerator sshKeyGen, SSHKeyUtility sshKeyUtil, ICollectiveRegistrationMBeanConnection registrationMBean) {
        super(tc, scriptName, fileUtility);
        this.sshKeyGen = sshKeyGen;
        this.sshKeyUtil = sshKeyUtil;
        this.registrationMBean = registrationMBean;
        this.reqArgs.add("--host");
        this.reqArgs.add("--port");
        this.reqArgs.add("--user");
        this.reqArgs.add("--password");
        this.promptableArgs.add("--password");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.addHostAuthInfoArgs(true);
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "updateHost";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("updateHost.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("hostAuthInfo.option-key.", "hostAuthInfo.option-desc.") + this.buildScriptOptions("hostOnly.option-key.", "hostOnly.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + NL + NL + this.getOption("sslTrust.autoAccept", "com.ibm.websphere.collective.utility.autoAcceptCertificates");
        return this.getTaskHelp("updateHost.desc", "updateHost.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("updateHost.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("updateHost.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
        this.stdout.println(this.getMessage("updateHost.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    private boolean updateHost(String host, int port, String user, String password, String hostName, Map<String, Object> hostAuthInfo) throws TaskErrorException {
        try {
            this.registrationMBean.updateHost(host, port, user, password, hostName, hostAuthInfo);
            this.stdout.println(this.getMessage("updateHost.updateSuccess", hostName));
            return true;
        }
        catch (RuntimeMBeanException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught RuntimeMBeanException, this may be expected, but here's the stack incase it helps.", (Object[])new Object[]{e});
            }
            if (e.getCause() instanceof IllegalStateException) {
                this.abort(this.getMessage("updateHost.notRegistered", hostName));
            } else if (e.getCause() instanceof IllegalArgumentException) {
                this.abort(this.getMessage("common.connectionError", e.getMessage()));
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unexpected RuntimeMBeanException while invoking the MBean", (Object[])new Object[]{e});
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abort(this.getMessage("common.connectionError", e.getMessage()));
            }
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.hostError", host));
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.portError", String.valueOf(port)));
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"IOException while invoking the MBean", (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected Exception while invoking the MBean", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        return false;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        boolean isThisHost = false;
        this.validateArgumentList(args, true);
        this.handleAutoAcceptArgument(args);
        String hostName = this.getTaskTarget(args);
        if (hostName == null) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The host name was not specified, defaulting to this hosts name", (Object[])new Object[0]);
            }
            isThisHost = true;
            hostName = this.getHostName();
        }
        String controllerHost = this.getArgumentValue("--host", args, null);
        int controllerPort = Integer.valueOf(this.getArgumentValue("--port", args, null));
        String user = this.getArgumentValue("--user", args, null);
        String password = this.getArgumentValue("--password", args, null);
        Map<String, Object> hostAuthInfo = this.buildHostAuthInfo(args, this.sshKeyGen, this.sshKeyUtil, hostName, isThisHost, true, null, null);
        if (tc.isDebugEnabled()) {
            Map hostAuthInfoWithMaskPassword = PasswordMaskUtil.maskPasswordsInMap(hostAuthInfo);
            Tr.debug((TraceComponent)tc, (String)("Resulting hostAuthInfo:\n" + hostAuthInfoWithMaskPassword), (Object[])new Object[0]);
        }
        stdout.println(this.getMessage("updateHost.attemptRegister", new Object[0]));
        if (!this.updateHost(controllerHost, controllerPort, user, password, hostName, hostAuthInfo)) {
            stdout.println(this.getMessage("updateHost.updateFailed", hostName));
        }
        if (isThisHost) {
            this.updateAuthorizedKeysFiles(this.sshKeyUtil);
        } else if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Updated a host which is not this host, no post processing to do", (Object[])new Object[0]);
        }
    }
}

