/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.collective.utility.IRepositoryConfigurationMBeanConnection;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class RemoveReplicaTask
extends BaseCommandTask {
    private static final TraceComponent tc = Tr.register(RemoveReplicaTask.class);
    private final IRepositoryConfigurationMBeanConnection repositoryMBean;

    public RemoveReplicaTask(String scriptName, IRepositoryConfigurationMBeanConnection repositoryMBean) {
        super(tc, scriptName, null);
        this.repositoryMBean = repositoryMBean;
        this.reqArgs.add("--host");
        this.reqArgs.add("--port");
        this.reqArgs.add("--user");
        this.reqArgs.add("--password");
        this.promptableArgs.add("--password");
        this.knownArgs.addAll(this.reqArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "removeReplica";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("removeReplica.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("common.option-key.", "common.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + NL + NL + this.getOption("sslTrust.autoAccept", "com.ibm.websphere.collective.utility.autoAcceptCertificates");
        return this.getTaskHelp("removeReplica.desc", "removeReplica.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("removeReplica.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
        throw new TaskErrorException(message);
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Validating command arguments...", (Object[])new Object[0]);
        }
        this.validateArgumentList(args, false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Parsing command arguments...", (Object[])new Object[0]);
        }
        String endpoint = this.getTaskTarget(args);
        String controllerHost = this.getArgumentValue("--host", args, null);
        int controllerPort = Integer.valueOf(this.getArgumentValue("--port", args, null));
        String user = this.getArgumentValue("--user", args, null);
        String password = this.getArgumentValue("--password", args, null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("endpoint: " + endpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("controllerHost: " + controllerHost), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("controllerPort: " + controllerPort), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("username: " + user), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("password: " + password.replaceAll(".", "*")), (Object[])new Object[0]);
        }
        this.handleAutoAcceptArgument(args);
        this.removeReplica(endpoint, controllerHost, controllerPort, user, password);
    }

    private void removeReplica(String endpoint, String controllerHost, int controllerPort, String user, String password) throws TaskErrorException {
        this.stdout.println(this.getMessage("removeReplica.attemptUnregister", new Object[0]));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attempting to remove replica from the collective. endpoint: " + endpoint), (Object[])new Object[0]);
        }
        try {
            boolean successful = this.repositoryMBean.removeReplica(controllerHost, controllerPort, user, password, endpoint);
            if (successful) {
                this.stdout.println(this.getMessage("removeReplica.success", endpoint));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Successfully removed replica from the collective. endpoint: " + endpoint), (Object[])new Object[0]);
                }
            } else {
                this.stdout.println(this.getMessage("removeReplica.alreadyRemoved", endpoint));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Failed to remove replica, perhaps it was already removed. endpoint: " + endpoint), (Object[])new Object[0]);
                }
            }
        }
        catch (UnknownHostException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("UnknownHostException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.hostError", controllerHost));
        }
        catch (ConnectException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ConnectException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.portError", String.valueOf(controllerPort)));
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while invoking the MBean: " + e.getMessage()), (Object[])new Object[]{e});
            }
            this.abort(this.getMessage("common.connectionError", e.getMessage()));
        }
        catch (KeyManagementException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught KeyManagementException, this happens if the keys cannot be trusted.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("removeReplica.error", endpoint));
        }
        catch (InstanceNotFoundException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught InstanceNotFoundException, this happens if the MBean has not been registered.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("removeReplica.error", endpoint));
        }
        catch (NoSuchAlgorithmException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught NoSuchAlgorithmException, this should only happen if a crypto algorithm is not implemented.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("removeReplica.error", endpoint));
        }
        catch (ReflectionException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught ReflectionException, this happens if the method invocation signature does not match the bean declaration.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("removeReplica.error", endpoint));
        }
        catch (MBeanException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught MBeanException, this happens if a declared exception is thrown.", (Object[])new Object[0]);
            }
            if (e.getCause() instanceof UnknownHostException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Caught UnknownHostException, this should be expected if the endpoint contains an unknown host name.", (Object[])new Object[]{e});
                }
                this.abort(this.getMessage("common.hostError", this.getEndpointHost(endpoint)));
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Caught MBeanException, an unexpected declared exception occurred.", (Object[])new Object[]{e});
                }
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abort(this.getMessage("removeReplica.error", endpoint));
            }
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Caught IllegalArgumentException, this should be expected if the endpoint is not valid.", (Object[])new Object[]{e});
                }
                this.abort(this.getMessage("common.invalidEndpoint", endpoint));
            }
            if (e.getCause() instanceof UnknownHostException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Caught UnknownHostException, this should be expected if the endpoint contains an unknown host name.", (Object[])new Object[]{e});
                }
                this.abort(this.getMessage("common.hostError", this.getEndpointHost(endpoint)));
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Caught RuntimeMBeanException, an unexpected runtime exception occurred.", (Object[])new Object[]{e});
            }
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("removeReplica.error", endpoint));
        }
    }
}

