/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility;

import com.ibm.ws.collective.member.internal.ssh.SSHKeyGenerator;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyGeneratorImpl;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtilityImpl;
import com.ibm.ws.collective.utility.CollectiveUtilityTask;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.AddReplicaTask;
import com.ibm.ws.collective.utility.tasks.CreateTask;
import com.ibm.ws.collective.utility.tasks.GenKeyTask;
import com.ibm.ws.collective.utility.tasks.GetMaintenanceTask;
import com.ibm.ws.collective.utility.tasks.HelpTask;
import com.ibm.ws.collective.utility.tasks.JoinTask;
import com.ibm.ws.collective.utility.tasks.RegisterHostTask;
import com.ibm.ws.collective.utility.tasks.RemoveReplicaTask;
import com.ibm.ws.collective.utility.tasks.RemoveTask;
import com.ibm.ws.collective.utility.tasks.ReplicateTask;
import com.ibm.ws.collective.utility.tasks.SetMaintenanceTask;
import com.ibm.ws.collective.utility.tasks.UnregisterHostTask;
import com.ibm.ws.collective.utility.tasks.UnsetMaintenanceTask;
import com.ibm.ws.collective.utility.tasks.UpdateHostTask;
import com.ibm.ws.collective.utility.utils.AdminMetadataManagerMBeanConnection;
import com.ibm.ws.collective.utility.utils.CollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.utils.CollectiveRepositoryMBeanConnection;
import com.ibm.ws.collective.utility.utils.CommandUtils;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.FileUtility;
import com.ibm.ws.collective.utility.utils.MaintenanceModeMBeanConnection;
import com.ibm.ws.collective.utility.utils.RepositoryConfigurationMBeanConnection;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class CollectiveUtility {
    static final String SCRIPT_NAME = "collective";
    private final ConsoleWrapper stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;
    List<CollectiveUtilityTask> tasks = new ArrayList<CollectiveUtilityTask>();

    CollectiveUtility(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    void registerTask(CollectiveUtilityTask task) {
        this.tasks.add(task);
    }

    private CollectiveUtilityTask getTask(String taskName) {
        CollectiveUtilityTask task = null;
        for (CollectiveUtilityTask availTask : this.tasks) {
            if (!availTask.getTaskName().equals(taskName)) continue;
            task = availTask;
        }
        return task;
    }

    int runProgram(String[] args) {
        CollectiveUtilityTask task;
        if (this.stdin == null) {
            this.stderr.println(CommandUtils.getMessage("error.missingIO", "stdin"));
            return 254;
        }
        if (this.stdout == null) {
            this.stderr.println(CommandUtils.getMessage("error.missingIO", "stdout"));
            return 253;
        }
        if (this.stderr == null) {
            this.stdout.println(CommandUtils.getMessage("error.missingIO", "stderr"));
            return 252;
        }
        HelpTask help = new HelpTask(SCRIPT_NAME, this.tasks);
        this.registerTask(help);
        if (args.length == 0) {
            this.stdout.println(help.getScriptUsage());
            return 0;
        }
        if (CollectiveUtility.looksLikeHelp(help, args[0])) {
            args[0] = help.getTaskName();
        }
        if ((task = this.getTask(args[0])) == null) {
            this.stderr.println(CommandUtils.getMessage("task.unknown", args[0]));
            this.stderr.println(help.getScriptUsage());
            return 0;
        }
        try {
            task.handleTask(this.stdin, this.stdout, this.stderr, args);
        }
        catch (IllegalArgumentException e) {
            this.stderr.println();
            this.stderr.println(CommandUtils.getMessage("error", e.getMessage()));
            this.stderr.println(help.getTaskUsage(task));
            return 20;
        }
        catch (TaskErrorException e) {
            if (e.getMessage() != null) {
                this.stderr.println();
                this.stderr.println(CommandUtils.getMessage("error", e.getMessage()));
            }
            return 255;
        }
        return 0;
    }

    private static boolean looksLikeHelp(HelpTask help, String taskname) {
        int start;
        if (taskname == null) {
            return false;
        }
        int len = taskname.length();
        for (start = 0; start < len && !Character.isLetter(taskname.charAt(start)); ++start) {
        }
        return help.getTaskName().equalsIgnoreCase(taskname.substring(start).toLowerCase());
    }

    public static void main(String[] args) {
        ConsoleWrapper console = new ConsoleWrapper(System.console(), System.err);
        FileUtility fileUtil = new FileUtility(System.getenv("WLP_INSTALL_DIR"), System.getenv("WLP_USER_DIR"), System.getenv("WLP_OUTPUT_DIR"));
        SSHKeyGeneratorImpl sshKeyGen = new SSHKeyGeneratorImpl();
        SSHKeyUtilityImpl sshKeyUtil = new SSHKeyUtilityImpl();
        CollectiveRegistrationMBeanConnection regMBeanConn = new CollectiveRegistrationMBeanConnection(console, System.out);
        CollectiveRepositoryMBeanConnection repositoryMBeanConn = new CollectiveRepositoryMBeanConnection(console, System.out);
        RepositoryConfigurationMBeanConnection repMBeanConn = new RepositoryConfigurationMBeanConnection(console, System.out);
        AdminMetadataManagerMBeanConnection metadataManagerMBeanConn = new AdminMetadataManagerMBeanConnection(console, System.out);
        MaintenanceModeMBeanConnection maintModeMBeanConn = new MaintenanceModeMBeanConnection(console, System.out);
        CollectiveUtility util = new CollectiveUtility(console, System.out, System.err);
        util.registerTask(new CreateTask(SCRIPT_NAME, fileUtil));
        util.registerTask(new JoinTask(SCRIPT_NAME, fileUtil, (SSHKeyGenerator)sshKeyGen, (SSHKeyUtility)sshKeyUtil, regMBeanConn, metadataManagerMBeanConn, repositoryMBeanConn));
        util.registerTask(new ReplicateTask(SCRIPT_NAME, fileUtil, (SSHKeyGenerator)sshKeyGen, (SSHKeyUtility)sshKeyUtil, regMBeanConn));
        util.registerTask(new RemoveTask(SCRIPT_NAME, fileUtil, regMBeanConn, metadataManagerMBeanConn, repositoryMBeanConn));
        util.registerTask(new RegisterHostTask(SCRIPT_NAME, fileUtil, (SSHKeyGenerator)sshKeyGen, (SSHKeyUtility)sshKeyUtil, regMBeanConn));
        util.registerTask(new UpdateHostTask(SCRIPT_NAME, fileUtil, (SSHKeyGenerator)sshKeyGen, (SSHKeyUtility)sshKeyUtil, regMBeanConn));
        util.registerTask(new UnregisterHostTask(SCRIPT_NAME, regMBeanConn));
        util.registerTask(new AddReplicaTask(SCRIPT_NAME, repMBeanConn));
        util.registerTask(new RemoveReplicaTask(SCRIPT_NAME, repMBeanConn));
        util.registerTask(new GenKeyTask(SCRIPT_NAME, fileUtil, regMBeanConn));
        util.registerTask(new SetMaintenanceTask(SCRIPT_NAME, maintModeMBeanConn));
        util.registerTask(new UnsetMaintenanceTask(SCRIPT_NAME, maintModeMBeanConn));
        util.registerTask(new GetMaintenanceTask(SCRIPT_NAME, maintModeMBeanConn));
        int rc = util.runProgram(args);
        System.exit(rc);
    }
}

