/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.utility.internal.cmdline;

import com.ibm.ws.install.utility.cmdline.ReturnCode;
import com.ibm.ws.install.utility.internal.cmdline.Action;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import com.ibm.ws.kernel.feature.internal.cmdline.ArgumentsImpl;
import com.ibm.ws.kernel.feature.internal.cmdline.NLS;
import java.util.List;

public class InstallUtilityExecutor {
    public static void main(String[] argsArray) {
        ExitCode rc;
        ArgumentsImpl args = new ArgumentsImpl(argsArray);
        String actionName = args.getAction();
        if (actionName == null) {
            rc = Action.help.handleTask((Arguments)args);
        } else {
            try {
                Action exeAction;
                List invalid;
                if (InstallUtilityExecutor.looksLikeHelp(actionName)) {
                    actionName = Action.help.toString();
                }
                if (!(invalid = args.findInvalidOptions((exeAction = Action.valueOf(actionName)).getCommandOptions())).isEmpty()) {
                    System.out.println(NLS.getMessage((String)"unknown.options", (Object[])new Object[]{exeAction, invalid}));
                    Action.help.handleTask((Arguments)new ArgumentsImpl(new String[]{"help", actionName}));
                    rc = ReturnCode.BAD_ARGUMENT;
                } else if (exeAction != Action.help && exeAction.numPositionalArgs() >= 0 && args.getPositionalArguments().size() != exeAction.numPositionalArgs()) {
                    System.out.println(NLS.getMessage((String)"missing.args", (Object[])new Object[]{exeAction, exeAction.numPositionalArgs(), args.getPositionalArguments().size()}));
                    rc = ReturnCode.BAD_ARGUMENT;
                } else {
                    rc = exeAction.handleTask((Arguments)args);
                }
            }
            catch (IllegalArgumentException iae) {
                rc = Action.help.handleTask((Arguments)new ArgumentsImpl(new String[]{Action.help.toString(), actionName}));
            }
        }
        System.exit(rc.getValue());
    }

    private static boolean looksLikeHelp(String taskname) {
        int start;
        if (taskname == null) {
            return false;
        }
        int len = taskname.length();
        for (start = 0; start < len && !Character.isLetter(taskname.charAt(start)); ++start) {
        }
        return Action.help.toString().equalsIgnoreCase(taskname.substring(start).toLowerCase());
    }

    public static ReturnCode returnCode(int rc) {
        for (ReturnCode r : ReturnCode.values()) {
            if (r.getValue() != rc) continue;
            return r;
        }
        return ReturnCode.RUNTIME_EXCEPTION;
    }
}

