/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.util;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;

public class UTF8Encoder {
    private static TraceComponent tc = SibTr.register(UTF8Encoder.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final char ONE_BYTE_ONLY_MASK = '\uff80';
    private static final char TWO_BYTES_ONLY_MASK = '\uf800';
    private static final char FIRST_OF_TWO_MASK = '\u07c0';
    private static final int FIRST_OF_TWO_SHIFT = 6;
    private static final byte FIRST_OF_TWO_TOP = -64;
    private static final char LAST_BYTE_MASK = '?';
    private static final char LOWER_BYTE_TOP = '\u0080';
    private static final char FIRST_OF_THREE_MASK = '\uf000';
    private static final int FIRST_OF_THREE_SHIFT = 12;
    private static final byte FIRST_OF_THREE_TOP = -32;
    private static final char SECOND_OF_THREE_MASK = '\u0fc0';
    private static final int SECOND_OF_THREE_SHIFT = 6;

    public static final int getEncodedLength(String s) {
        int count = 0;
        int strLength = s.length();
        for (int i = 0; i < strLength; ++i) {
            count += UTF8Encoder.getEncodedLength(s.charAt(i));
        }
        return count;
    }

    public static final int encode(byte[] buff, int offset, String s) {
        int strLength = s.length();
        int start = offset;
        for (int i = 0; i < strLength; ++i) {
            offset = UTF8Encoder.encode(buff, offset, s.charAt(i));
        }
        return offset - start;
    }

    public static final byte[] encode(String s) {
        byte[] bytes = new byte[UTF8Encoder.getEncodedLength(s)];
        int offset = 0;
        int strLength = s.length();
        for (int i = 0; i < strLength; ++i) {
            offset = UTF8Encoder.encode(bytes, offset, s.charAt(i));
        }
        return bytes;
    }

    private static final int getEncodedLength(char c) {
        if ((c & 0xFF80) == 0) {
            return 1;
        }
        if ((c & 0xF800) == 0) {
            return 2;
        }
        return 3;
    }

    private static final int encode(byte[] buff, int offset, char c) {
        if ((c & 0xFF80) == 0) {
            buff[offset] = (byte)c;
        } else if ((c & 0xF800) == 0) {
            byte tempB;
            char tempC = (char)((c & 0x7C0) >> 6);
            buff[offset] = tempB = (byte)((byte)tempC + -64);
            buff[++offset] = (byte)((c & 0x3F) + 128);
        } else {
            byte tempB;
            char tempC = (char)((c & 0xF000) >> 12);
            buff[offset] = tempB = (byte)((byte)tempC + -32);
            tempC = (char)((c & 0xFC0) >> 6);
            buff[++offset] = tempB = (byte)((byte)tempC + 128);
            buff[++offset] = (byte)((c & 0x3F) + 128);
        }
        return offset + 1;
    }
}

