/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.jmf.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.MfpConstants;
import com.ibm.ws.sib.mfp.jmf.JMFAddress;
import com.ibm.ws.sib.mfp.jmf.JMFMessageCorruptionException;
import com.ibm.ws.sib.mfp.jmf.JMFMessageData;
import com.ibm.ws.sib.mfp.jmf.JMFModelNotImplementedException;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaViolationException;
import com.ibm.ws.sib.mfp.jmf.JMFUninitializedAccessException;
import com.ibm.ws.sib.mfp.jmf.JmfTr;
import com.ibm.ws.sib.mfp.jmf.impl.JSCoder;
import com.ibm.ws.sib.mfp.jmf.impl.JSListCoder;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.mfp.util.HexUtil;
import com.ibm.ws.sib.mfp.util.UTF8Encoder;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public final class JSBaseTypes {
    private static TraceComponent tc = JmfTr.register(JSBaseTypes.class, "SIBJmf", "com.ibm.ws.sib.mfp.CWSIFMessages");
    private static JSCoder StringCoder = new JSCoder(){

        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                return 4;
            }
            return 4 + UTF8Encoder.getEncodedLength((String)val);
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof String || val == null) {
                return val;
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                ArrayUtil.writeInt(frame, offset, -1);
                return offset + 4;
            }
            if (val instanceof StringBuffer) {
                val = ((StringBuffer)val).toString();
            }
            int written = UTF8Encoder.encode(frame, offset + 4, (String)val);
            ArrayUtil.writeInt(frame, offset, written);
            return offset + 4 + written;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) throws JMFMessageCorruptionException {
            String ans;
            int len = ArrayUtil.readInt(frame, offset);
            if (len == -1) {
                return null;
            }
            JSListCoder.sanityCheck(len, frame, offset);
            offset += 4;
            try {
                ans = new String(frame, offset, len, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                FFDCFilter.processException((Throwable)e, (String)"JSBaseTypes$StringCoder.decode", (String)"168", (Object)offset, (Object[])new Object[]{MfpConstants.DM_BUFFER, frame, 0, frame.length});
                IllegalArgumentException ex = new IllegalArgumentException();
                ex.initCause(e);
                throw ex;
            }
            return ans;
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            if (val == null) {
                return 0;
            }
            return this.estSize(((String)val).length());
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            int len = ArrayUtil.readInt(frame, offset);
            if (len == -1) {
                return 0;
            }
            return this.estSize(len);
        }

        private int estSize(int length) {
            return JSCoder.OBJECT_OVERHEAD * 2 + length * 2;
        }
    };
    private static JSCoder ByteArrayCoder = new JSCoder(){

        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                return 4;
            }
            return ((byte[])val).length + 4;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof byte[] || val == null) {
                return val;
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                ArrayUtil.writeInt(frame, offset, -1);
                return offset + 4;
            }
            byte[] bval = (byte[])val;
            ArrayUtil.writeInt(frame, offset, bval.length);
            System.arraycopy(bval, 0, frame, offset + 4, bval.length);
            return offset + 4 + bval.length;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) throws JMFMessageCorruptionException {
            int len = ArrayUtil.readInt(frame, offset);
            if (len == -1) {
                return null;
            }
            JSListCoder.sanityCheck(len, frame, offset);
            byte[] bval = new byte[len];
            System.arraycopy(frame, offset + 4, bval, 0, len);
            return bval;
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            if (val == null) {
                return 0;
            }
            return JSCoder.OBJECT_OVERHEAD + ((byte[])val).length;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            int len = ArrayUtil.readInt(frame, offset);
            if (len == -1) {
                return 0;
            }
            return JSCoder.OBJECT_OVERHEAD + len;
        }
    };
    private static JSCoder Byte8Coder = new ByteFixedCoder(8);
    private static JSCoder Byte12Coder = new ByteFixedCoder(12);
    private static JSCoder DecimalCoder = new JSCoder(){

        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return 8 + ((BigDecimal)val).unscaledValue().bitLength() / 8 + 1;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof BigDecimal) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("BigDecimal==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            BigDecimal dval = (BigDecimal)val;
            byte[] unscaled = dval.unscaledValue().toByteArray();
            ArrayUtil.writeInt(frame, offset, unscaled.length + 4);
            ArrayUtil.writeInt(frame, offset + 4, dval.scale());
            System.arraycopy(unscaled, 0, frame, offset + 8, unscaled.length);
            return offset + 8 + unscaled.length;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) throws JMFMessageCorruptionException {
            int len = ArrayUtil.readInt(frame, offset);
            JSListCoder.sanityCheck(len, frame, offset);
            int scale = ArrayUtil.readInt(frame, offset + 4);
            byte[] unscaled = new byte[len -= 4];
            System.arraycopy(frame, offset + 8, unscaled, 0, len);
            return new BigDecimal(new BigInteger(unscaled), scale);
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            if (val == null) {
                return 0;
            }
            return 50;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            int len = ArrayUtil.readInt(frame, offset);
            if (len == -1) {
                return 0;
            }
            return 50;
        }
    };
    private static JSCoder DateCoder = new JSCoder(){

        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return 8;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof Date) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("Date==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                throw new NullPointerException();
            }
            ArrayUtil.writeLong(frame, offset, ((Date)val).getTime());
            return offset + 8;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) {
            return new Date(ArrayUtil.readLong(frame, offset));
        }

        @Override
        public Object copy(Object val, int indirect) {
            return ((Date)val).clone();
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            if (val == null) {
                return 0;
            }
            return 100;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            int len = ArrayUtil.readInt(frame, offset);
            if (len == -1) {
                return 0;
            }
            return 100;
        }
    };
    private static JSCoder BigIntegerCoder = new JSCoder(){

        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return 4 + ((BigInteger)val).bitLength() / 8 + 1;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof BigInteger) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("BigInteger==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            byte[] byteForm = ((BigInteger)val).toByteArray();
            ArrayUtil.writeInt(frame, offset, byteForm.length);
            System.arraycopy(byteForm, 0, frame, offset + 4, byteForm.length);
            return offset + 4 + byteForm.length;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) throws JMFMessageCorruptionException {
            int len = ArrayUtil.readInt(frame, offset);
            JSListCoder.sanityCheck(len, frame, offset);
            byte[] byteForm = new byte[len];
            System.arraycopy(frame, offset + 4, byteForm, 0, len);
            return new BigInteger(byteForm);
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            if (val == null) {
                return 0;
            }
            return 50;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            int len = ArrayUtil.readInt(frame, offset);
            if (len == -1) {
                return 0;
            }
            return 50;
        }
    };
    private static JSCoder IDREFCoder = new JSCoder(){

        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            if (val != null) {
                val = ((JMFAddress)val).getContent();
            }
            return ByteArrayCoder.getEncodedLength(val, indirect, msg);
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            if (val != null) {
                val = ((JMFAddress)val).getContent();
            }
            return ByteArrayCoder.encode(frame, offset, val, indirect, msg);
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            Object val = ByteArrayCoder.decode(frame, offset, indirect, msg);
            if (val != null) {
                val = new JMFAddress((byte[])val);
            }
            return val;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
            if (val instanceof JMFAddress || val == null) {
                return val;
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public Object copy(Object val, int indirect) throws JMFSchemaViolationException {
            return new JMFAddress((JMFAddress)val);
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            if (val == null) {
                return 0;
            }
            return JSCoder.OBJECT_OVERHEAD + ByteArrayCoder.estimateUnassembledSize(((JMFAddress)val).getContent());
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            return JSCoder.OBJECT_OVERHEAD + ByteArrayCoder.estimateUnassembledSize(frame, offset);
        }
    };
    private static JSCoder SimpleListCoder = new JSCoder(){

        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            int ans = 8;
            List lval = (List)val;
            Iterator iter = lval.iterator();
            while (iter.hasNext()) {
                ans += AnySimpleTypeCoder.getEncodedLength(iter.next(), indirect, msg);
            }
            return ans;
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            List lval = (List)val;
            ArrayUtil.writeInt(frame, offset + 4, lval.size());
            int place = offset + 8;
            Iterator iter = lval.iterator();
            while (iter.hasNext()) {
                place = AnySimpleTypeCoder.encode(frame, place, iter.next(), indirect, msg);
            }
            ArrayUtil.writeInt(frame, offset, place - offset - 4);
            return place;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            ArrayList<Object> ans = new ArrayList<Object>();
            int size = ArrayUtil.readInt(frame, offset + 4);
            int place = offset + 8;
            for (int i = 0; i < size; ++i) {
                ans.add(AnySimpleTypeCoder.decode(frame, place, indirect, msg));
                place += 4 + ArrayUtil.readInt(frame, place);
            }
            return ans;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
            if (val instanceof List) {
                return val;
            }
            if (val == null) {
                throw new JMFSchemaViolationException("List==null");
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public Object copy(Object val, int indirect) throws JMFSchemaViolationException {
            return new ArrayList((List)val);
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            if (val == null) {
                return 0;
            }
            int listSize = ((List)val).size();
            if (listSize > 0) {
                int entrySize = 0;
                entrySize = ((List)val).get(0) instanceof String ? JSCoder.OBJECT_OVERHEAD * 2 + 40 : JSCoder.OBJECT_OVERHEAD + 8;
                return JSCoder.OBJECT_OVERHEAD + 20 + listSize * entrySize;
            }
            return 0;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            int len = ArrayUtil.readInt(frame, offset);
            int listSize = ArrayUtil.readInt(frame, offset + 4);
            int size = 0;
            if (listSize > 0) {
                size = OBJECT_OVERHEAD + 20 + listSize * OBJECT_OVERHEAD + len * 2;
            }
            return size;
        }
    };
    private static JSCoder AnySimpleTypeCoder = new JSCoder(){

        private int getTypeInfo(Object val) throws JMFSchemaViolationException {
            if (val == null) {
                return 9;
            }
            if (val instanceof List) {
                return 16;
            }
            Class<?> lookup = val.getClass();
            Integer code = (Integer)classTypes.get(lookup);
            if (code == null) {
                throw new JMFSchemaViolationException(val.getClass().getName());
            }
            return code;
        }

        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            JSBaseTypes t = baseTypes[this.getTypeInfo(val)];
            return 5 + t.coder.getEncodedLength(val, 0, msg);
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFUninitializedAccessException, JMFMessageCorruptionException {
            JSBaseTypes t = baseTypes[this.getTypeInfo(val)];
            return t.coder.validate(val, 0);
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            int code = this.getTypeInfo(val);
            JSBaseTypes t = baseTypes[code];
            ArrayUtil.writeInt(frame, offset, 1 + t.coder.getEncodedLength(val, 0, msg));
            frame[offset + 4] = (byte)code;
            return t.coder.encode(frame, offset + 5, val, 0, msg);
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            byte typeCode = frame[offset + 4];
            return JSBaseTypes.baseTypes[typeCode].coder.decode(frame, offset + 5, 0, msg);
        }

        @Override
        public Object copy(Object val, int indirect) throws JMFSchemaViolationException {
            JSBaseTypes t = baseTypes[this.getTypeInfo(val)];
            return t.coder.copy(val, 0);
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            if (val == null) {
                return 0;
            }
            try {
                JSBaseTypes t = baseTypes[this.getTypeInfo(val)];
                return t.coder.estimateUnassembledSize(val);
            }
            catch (JMFSchemaViolationException e) {
                return 24;
            }
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            byte typeCode = frame[offset + 4];
            return JSBaseTypes.baseTypes[typeCode].coder.estimateUnassembledSize(frame, offset + 5);
        }
    };
    private static JSCoder QNameCoder = new JSCoder(){

        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            String uri = null;
            String name = null;
            String prefix = null;
            if (val != null) {
                QName value = (QName)val;
                uri = value.getNamespaceURI();
                name = value.getLocalPart();
                prefix = value.getPrefix();
            }
            int result = StringCoder.getEncodedLength(uri, indirect, msg) + StringCoder.getEncodedLength(name, indirect, msg) + StringCoder.getEncodedLength(prefix, indirect, msg);
            return result;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val instanceof QName || val == null) {
                return val;
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) throws JMFUninitializedAccessException, JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            String uri = null;
            String name = null;
            String prefix = null;
            if (val != null) {
                QName value = (QName)val;
                uri = value.getNamespaceURI();
                name = value.getLocalPart();
                prefix = value.getPrefix();
            }
            offset = StringCoder.encode(frame, offset, uri, indirect, msg);
            offset = StringCoder.encode(frame, offset, name, indirect, msg);
            offset = StringCoder.encode(frame, offset, prefix, indirect, msg);
            return offset;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) throws JMFSchemaViolationException, JMFModelNotImplementedException, JMFMessageCorruptionException {
            int uriOffset = offset;
            int len = ArrayUtil.readInt(frame, uriOffset);
            int nameOffset = uriOffset + 4;
            if (len != -1) {
                nameOffset += len;
            }
            len = ArrayUtil.readInt(frame, nameOffset);
            int prefixOffset = nameOffset + 4;
            if (len != -1) {
                prefixOffset += len;
            }
            String uri = (String)StringCoder.decode(frame, uriOffset, indirect, msg);
            String name = (String)StringCoder.decode(frame, nameOffset, indirect, msg);
            String prefix = (String)StringCoder.decode(frame, prefixOffset, indirect, msg);
            QName result = new QName(uri, name, prefix);
            return result;
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            return JSCoder.OBJECT_OVERHEAD * 7 + 120;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            return JSCoder.OBJECT_OVERHEAD * 7 + 120;
        }
    };
    Class javaClass;
    int javaClassSize;
    int length;
    JSCoder coder;
    static JSBaseTypes[] baseTypes = new JSBaseTypes[]{null, new JSBaseTypes(Boolean.class, -1, 1, JSCoder.BOOLEAN), new JSBaseTypes(Byte.class, -1, 1, JSCoder.BYTE), new JSBaseTypes(Short.class, -1, 2, JSCoder.SHORT), new JSBaseTypes(Character.class, -1, 2, JSCoder.CHAR), new JSBaseTypes(Integer.class, -1, 4, JSCoder.INT), new JSBaseTypes(Long.class, -1, 8, JSCoder.LONG), new JSBaseTypes(Float.class, -1, 4, JSCoder.FLOAT), new JSBaseTypes(Double.class, -1, 8, JSCoder.DOUBLE), new JSBaseTypes(String.class, -1, -1, StringCoder), new JSBaseTypes(BigDecimal.class, -1, -1, DecimalCoder), new JSBaseTypes(Date.class, -1, 8, DateCoder), new JSBaseTypes(byte[].class, -1, -1, ByteArrayCoder), new JSBaseTypes(Object.class, -1, -1, AnySimpleTypeCoder), new JSBaseTypes(BigInteger.class, -1, -1, BigIntegerCoder), new JSBaseTypes(JMFAddress.class, -1, -1, IDREFCoder), new JSBaseTypes(List.class, -1, -1, SimpleListCoder), new JSBaseTypes(byte[].class, 8, 9, Byte8Coder), new JSBaseTypes(byte[].class, 12, 13, Byte12Coder), new JSBaseTypes(QName.class, -1, -1, QNameCoder)};
    static Map xsdTypeNames = new HashMap();
    static HashMap classTypes;

    private JSBaseTypes(Class javaClass, int javaClassSize, int length, JSCoder coder) {
        this.javaClass = javaClass;
        this.javaClassSize = javaClassSize;
        this.length = length;
        this.coder = coder;
    }

    static {
        xsdTypeNames.put("boolean", 1);
        xsdTypeNames.put("byte", 2);
        xsdTypeNames.put("short", 3);
        xsdTypeNames.put("unsignedShort", 4);
        xsdTypeNames.put("int", 5);
        xsdTypeNames.put("long", 6);
        xsdTypeNames.put("float", 7);
        xsdTypeNames.put("double", 8);
        xsdTypeNames.put("string", 9);
        xsdTypeNames.put("decimal", 10);
        xsdTypeNames.put("duration", 11);
        xsdTypeNames.put("dateTime", 11);
        xsdTypeNames.put("time", 11);
        xsdTypeNames.put("date", 11);
        xsdTypeNames.put("gYearMonth", 11);
        xsdTypeNames.put("gYear", 11);
        xsdTypeNames.put("gMonthDay", 11);
        xsdTypeNames.put("gDay", 11);
        xsdTypeNames.put("gMonth", 11);
        xsdTypeNames.put("hexBinary", 12);
        xsdTypeNames.put("base64Binary", 12);
        xsdTypeNames.put("anyURI", 9);
        xsdTypeNames.put("QName", 19);
        xsdTypeNames.put("NOTATION", 9);
        xsdTypeNames.put("normalizedString", 9);
        xsdTypeNames.put("token", 9);
        xsdTypeNames.put("language", 9);
        xsdTypeNames.put("NMTOKEN", 9);
        xsdTypeNames.put("NMTOKENS", 16);
        xsdTypeNames.put("Name", 9);
        xsdTypeNames.put("NCName", 9);
        xsdTypeNames.put("ID", 9);
        xsdTypeNames.put("IDREF", 15);
        xsdTypeNames.put("IDREFS", 16);
        xsdTypeNames.put("ENTITY", 9);
        xsdTypeNames.put("ENTITIES", 16);
        xsdTypeNames.put("integer", 14);
        xsdTypeNames.put("positiveInteger", 14);
        xsdTypeNames.put("nonPositiveInteger", 14);
        xsdTypeNames.put("negativeInteger", 14);
        xsdTypeNames.put("nonNegativeInteger", 14);
        xsdTypeNames.put("unsignedLong", 14);
        xsdTypeNames.put("unsignedInt", 6);
        xsdTypeNames.put("anySimpleType", 13);
        xsdTypeNames.put("byte8", 17);
        xsdTypeNames.put("byte12", 18);
        classTypes = new HashMap();
        for (int i = baseTypes.length - 1; i > 0; --i) {
            classTypes.put(JSBaseTypes.baseTypes[i].javaClass, i);
        }
        classTypes.put(Boolean.TYPE, 1);
        classTypes.put(Byte.TYPE, 2);
        classTypes.put(Short.TYPE, 3);
        classTypes.put(Character.TYPE, 4);
        classTypes.put(Integer.TYPE, 5);
        classTypes.put(Long.TYPE, 6);
        classTypes.put(Float.TYPE, 7);
        classTypes.put(Double.TYPE, 8);
    }

    private static class ByteFixedCoder
    implements JSCoder {
        private final int size;

        ByteFixedCoder(int size) {
            this.size = size;
        }

        @Override
        public int getEncodedLength(Object val, int indirect, JMFMessageData msg) {
            return this.size + 1;
        }

        @Override
        public Object validate(Object val, int indirect) throws JMFSchemaViolationException {
            if (val == null) {
                return val;
            }
            if (val instanceof byte[]) {
                if (((byte[])val).length == this.size) {
                    return val;
                }
                throw new JMFSchemaViolationException("byte" + this.size + " size: " + ((byte[])val).length);
            }
            throw new JMFSchemaViolationException(val.getClass().getName());
        }

        @Override
        public int encode(byte[] frame, int offset, Object val, int indirect, JMFMessageData msg) {
            if (val == null) {
                frame[offset] = 0;
            } else {
                frame[offset] = (byte)this.size;
                System.arraycopy((byte[])val, 0, frame, offset + 1, this.size);
            }
            return offset + 1 + this.size;
        }

        @Override
        public Object decode(byte[] frame, int offset, int indirect, JMFMessageData msg) throws JMFMessageCorruptionException {
            int len = frame[offset];
            if (len == 0) {
                return null;
            }
            if (len != this.size) {
                JMFMessageCorruptionException jmce = new JMFMessageCorruptionException("Bad length: " + len + " (0x" + HexUtil.toString(new int[]{len}) + ") at offset " + offset);
                FFDCFilter.processException((Throwable)jmce, (String)"com.ibm.ws.sib.mfp.jmf.impl.JSBaseTypes$ByteFixedCoder.decode", (String)"272", (Object)this, (Object[])new Object[]{MfpConstants.DM_BUFFER, frame, 0, frame.length});
                throw jmce;
            }
            byte[] bval = new byte[this.size];
            System.arraycopy(frame, offset + 1, bval, 0, this.size);
            return bval;
        }

        @Override
        public Object copy(Object val, int indirect) {
            return val;
        }

        @Override
        public int estimateUnassembledSize(Object val) {
            return JSCoder.OBJECT_OVERHEAD + this.size;
        }

        @Override
        public int estimateUnassembledSize(byte[] frame, int offset) {
            return JSCoder.OBJECT_OVERHEAD + this.size;
        }
    }
}

