/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsDestinationAddressFactory;
import com.ibm.ws.sib.mfp.impl.JsDestinationAddressImpl;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class JsDestinationAddressFactoryImpl
extends JsDestinationAddressFactory {
    private static TraceComponent tc = SibTr.register(JsDestinationAddressFactoryImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final String SYSTEM_PREFIX = "_P";
    private static final String SYSTEM_SEPARATOR = String.valueOf('_');
    private static final int SYSTEM_LENGTH = "_P".length() + SYSTEM_SEPARATOR.length() + new SIBUuid8().getStringLength();

    @Override
    public final SIDestinationAddress createSIDestinationAddress(String destinationName, boolean localOnly) throws NullPointerException {
        if (destinationName == null) {
            throw new NullPointerException("destinationName");
        }
        return new JsDestinationAddressImpl(destinationName, localOnly, null, null, false);
    }

    @Override
    public final SIDestinationAddress createSIDestinationAddress(String destinationName, String busName) throws NullPointerException {
        if (destinationName == null) {
            throw new NullPointerException("destinationName");
        }
        return new JsDestinationAddressImpl(destinationName, false, null, busName, false);
    }

    @Override
    public final SIDestinationAddress createSIDestinationAddress(String destinationName, boolean localOnly, String busName) throws NullPointerException {
        if (destinationName == null) {
            throw new NullPointerException("destinationName");
        }
        return new JsDestinationAddressImpl(destinationName, localOnly, null, busName, false);
    }

    @Override
    public final JsDestinationAddress createJsDestinationAddress(String destinationName, boolean localOnly, SIBUuid8 meId) throws NullPointerException {
        if (destinationName == null) {
            throw new NullPointerException("destinationName");
        }
        return new JsDestinationAddressImpl(destinationName, localOnly, meId, null, false);
    }

    @Override
    public final JsDestinationAddress createJsDestinationAddress(String destinationName, boolean localOnly, SIBUuid8 meId, String busName) throws NullPointerException {
        if (destinationName == null) {
            throw new NullPointerException("destinationName");
        }
        return new JsDestinationAddressImpl(destinationName, localOnly, meId, busName, false);
    }

    @Override
    public final JsDestinationAddress createJsSystemDestinationAddress(String prefix, SIBUuid8 meId) throws NullPointerException {
        if (meId == null) {
            throw new NullPointerException("MEId");
        }
        return this.createJsSystemDestinationAddress(prefix, meId, null);
    }

    @Override
    public final JsDestinationAddress createJsSystemDestinationAddress(String prefix, SIBUuid8 meId, String busName) throws NullPointerException {
        StringBuilder s;
        if (meId == null && busName == null) {
            throw new NullPointerException("BusName and MEId");
        }
        if (prefix != null) {
            s = new StringBuilder(SYSTEM_LENGTH + prefix.length());
            s.append(SYSTEM_PREFIX);
            s.append(prefix);
        } else {
            s = new StringBuilder(SYSTEM_LENGTH);
            s.append(SYSTEM_PREFIX);
        }
        s.append(SYSTEM_SEPARATOR);
        if (meId != null) {
            s.append(meId.toString());
        } else {
            s.append(SIBUuid8.toZeroString());
        }
        return new JsDestinationAddressImpl(new String(s), false, null, busName, false);
    }
}

