/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.IntAble;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class JmsBodyType
implements IntAble {
    private static TraceComponent tc = SibTr.register(JmsBodyType.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    public static final int NULL_INT = 0;
    public static final int BYTES_INT = 1;
    public static final int MAP_INT = 2;
    public static final int OBJECT_INT = 3;
    public static final int STREAM_INT = 4;
    public static final int TEXT_INT = 5;
    public static final JmsBodyType NULL = new JmsBodyType("NULL", 0);
    public static final JmsBodyType BYTES = new JmsBodyType("BYTES", 1);
    public static final JmsBodyType MAP = new JmsBodyType("MAP", 2);
    public static final JmsBodyType OBJECT = new JmsBodyType("OBJECT", 3);
    public static final JmsBodyType STREAM = new JmsBodyType("STREAM", 4);
    public static final JmsBodyType TEXT = new JmsBodyType("TEXT", 5);
    private static final JmsBodyType[] set = new JmsBodyType[]{NULL, BYTES, MAP, OBJECT, STREAM, TEXT};
    private String name;
    private Byte value;
    private int intValue;

    private JmsBodyType(String aName, byte aValue) {
        this.name = aName;
        this.value = new Byte(aValue);
        this.intValue = aValue;
    }

    public static JmsBodyType getBodyType(String format) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBodyType");
        }
        JmsBodyType result = null;
        if (format.equals("JMS:bytes")) {
            result = BYTES;
        } else if (format.equals("JMS:text")) {
            result = TEXT;
        } else if (format.equals("JMS:object")) {
            result = OBJECT;
        } else if (format.equals("JMS:stream")) {
            result = STREAM;
        } else if (format.equals("JMS:map")) {
            result = MAP;
        } else if (format.equals("JMS:")) {
            result = NULL;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBodyType");
        }
        return result;
    }

    public static final JmsBodyType getJmsBodyType(Byte aValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Value = " + aValue));
        }
        return set[aValue.intValue()];
    }

    public final Byte toByte() {
        return this.value;
    }

    @Override
    public final int toInt() {
        return this.intValue;
    }

    public final String toString() {
        return this.name;
    }
}

