/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.publisher;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.member.internal.publisher.MBeanAttributeDiscovery;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.repository.publisher.RepositoryPublisher;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={DynamicMBeanDiscovery.class}, immediate=true, property={"service.vendor=IBM"})
public class DynamicMBeanDiscovery
implements ServiceTrackerCustomizer<Object, ServiceReference<?>>,
NotificationListener,
NotificationFilter {
    private static final TraceComponent tc = Tr.register(DynamicMBeanDiscovery.class);
    private static final long serialVersionUID = 1L;
    static final String KEY_EVENT_ADMIN = "eventAdmin";
    private final AtomicServiceReference<EventAdmin> eventAdminRef = new AtomicServiceReference("eventAdmin");
    private final AtomicReference<BundleContext> bundleContextRef = new AtomicReference();
    private ServiceTracker<Object, ServiceReference<?>> mbeanTracker;
    private final Map<String, Map<String, AttributeChangeNotification>> mBeanAttrs = new HashMap<String, Map<String, AttributeChangeNotification>>();
    private final Set<String> removedMBeans = new HashSet<String>();
    private final Map<String, Long> reincarnatedMBeans = new HashMap<String, Long>();

    @Reference(name="eventAdmin", service=EventAdmin.class)
    protected void setEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.setReference(ref);
    }

    protected void unsetEventAdminService(ServiceReference<EventAdmin> ref) {
        this.eventAdminRef.unsetReference(ref);
    }

    @Reference(service=RepositoryPublisher.class)
    protected void setRepositoryPublisher(ServiceReference<RepositoryPublisher> ref) {
    }

    protected void unsetRepositoryPublisher(ServiceReference<RepositoryPublisher> ref) {
    }

    /*
     * WARNING - void declaration
     */
    @Activate
    protected void activate(ComponentContext cc) {
        this.eventAdminRef.activate(cc);
        BundleContext ctx = cc.getBundleContext();
        this.bundleContextRef.set(ctx);
        HashMap<String, String> eventProps = new HashMap<String, String>();
        eventProps.put("operation", "DELETE");
        eventProps.put("dataName", "sys.mbeans");
        this.getEventAdminService().postEvent(new Event("com/ibm/wsspi/collective/repository/publish/data", eventProps));
        try {
            this.mbeanTracker = new ServiceTracker(ctx, ctx.createFilter("(jmx.objectname=*)"), (ServiceTrackerCustomizer)this);
            this.mbeanTracker.open(true);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void ise;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.collective.member.internal.publisher.DynamicMBeanDiscovery", (String)"144", (Object)this, (Object[])new Object[]{cc});
            throw new RuntimeException("InvalidSyntaxException while registering ServiceTracker. This is VERY unexpected.", (Throwable)ise);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.mbeanTracker.close();
        this.eventAdminRef.deactivate(cc);
    }

    public ServiceReference<?> addingService(ServiceReference<Object> reference) {
        this.setMBean(reference);
        return reference;
    }

    public void modifiedService(ServiceReference<Object> reference, ServiceReference<?> service) {
    }

    public void removedService(ServiceReference<Object> reference, ServiceReference<?> service) {
        this.unsetMBean(reference);
    }

    /*
     * WARNING - void declaration
     */
    private void setMBean(ServiceReference<Object> ref) {
        block3: {
            Object mbean = this.bundleContextRef.get().getService(ref);
            String objectName = (String)ref.getProperty("jmx.objectname");
            String publishAttrsOverride = (String)ref.getProperty("publishAttributesToCollectiveController");
            if (this.shouldPublishAttributes(mbean, publishAttrsOverride)) {
                try {
                    this.publishMBean(mbean, objectName);
                }
                catch (NotCompliantMBeanException notCompliantMBeanException) {
                    void e;
                    FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.collective.member.internal.publisher.DynamicMBeanDiscovery", (String)"189", (Object)this, (Object[])new Object[]{ref});
                    if (!tc.isEventEnabled()) break block3;
                    Tr.event((TraceComponent)tc, (String)"Unexpected NotCompliantMBeanException during setMBean", (Object[])new Object[]{e});
                }
            }
        }
    }

    private boolean shouldPublishAttributes(Object mbean, String publishAttrsOverride) {
        return this.doesMBeanEmitAttributeChangeNotifications(mbean) && publishAttrsOverride == null || Boolean.valueOf(publishAttrsOverride) != false;
    }

    private boolean doesMBeanEmitAttributeChangeNotifications(Object mbean) {
        MBeanNotificationInfo[] infos;
        if (mbean instanceof NotificationBroadcaster && (infos = ((NotificationBroadcaster)mbean).getNotificationInfo()) != null) {
            for (MBeanNotificationInfo info : infos) {
                if (!AttributeChangeNotification.class.getName().equals(info.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void unsetMBean(ServiceReference<Object> ref) {
        if (!FrameworkState.isStopping()) {
            Object mbean = this.bundleContextRef.get().getService(ref);
            this.unpublishMBean(mbean, (String)ref.getProperty("jmx.objectname"));
        }
    }

    private synchronized void publishMBean(Object mbean, String objectName) throws NotCompliantMBeanException {
        if (this.removedMBeans.contains(objectName)) {
            this.reincarnatedMBeans.put(objectName, System.currentTimeMillis());
            this.removedMBeans.remove(objectName);
        }
        if (mbean instanceof NotificationBroadcaster) {
            ((NotificationBroadcaster)mbean).addNotificationListener(this, this, objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Registered the collective repository NotificationListener (for AttributeChanges) with MBean", (Object[])new Object[]{mbean});
            }
        }
        List<Attribute> attrs = MBeanAttributeDiscovery.discoverAttributes(mbean);
        for (Attribute attr : attrs) {
            this.safePostEvent(this.createPublishMBeanAttributeUpdateEvent(objectName, attr.getName(), attr.getValue(), false));
        }
    }

    private void safePostEvent(Event event) {
        EventAdmin ea = (EventAdmin)this.eventAdminRef.getService();
        if (ea != null) {
            ea.postEvent(event);
        }
    }

    @FFDCIgnore(value={ListenerNotFoundException.class})
    private synchronized void unpublishMBean(Object mbean, String objectName) {
        block3: {
            this.mBeanAttrs.remove(objectName);
            this.removedMBeans.add(objectName);
            this.reincarnatedMBeans.remove(objectName);
            this.safePostEvent(this.createPublishDeleteMBeanEvent(objectName));
            if (mbean instanceof NotificationBroadcaster) {
                try {
                    ((NotificationBroadcaster)mbean).removeNotificationListener(this);
                }
                catch (ListenerNotFoundException e) {
                    if (!tc.isEventEnabled()) break block3;
                    Tr.event((TraceComponent)tc, (String)"Unexpected ListenerNotFoundException during unpublishMBean", (Object[])new Object[]{e});
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void handleNotification(Notification notification, Object handback) {
        block6: {
            try {
                AttributeChangeNotification acn = (AttributeChangeNotification)notification;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)this.showAttrNotifInfo(acn), (Object[])new Object[0]);
                }
                if (this.validateNotificationOrder(acn)) {
                    this.safePostEvent(this.createPublishMBeanAttributeUpdateOnlyEvent(acn, (String)handback));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Skip publishing this earlier notification: " + this.showAttrNotifInfo(acn)), (Object[])new Object[0]);
                }
            }
            catch (Exception acn) {
                void e;
                FFDCFilter.processException((Throwable)acn, (String)"com.ibm.ws.collective.member.internal.publisher.DynamicMBeanDiscovery", (String)"373", (Object)this, (Object[])new Object[]{notification, handback});
                if (!tc.isEventEnabled()) break block6;
                Tr.event((TraceComponent)tc, (String)"Unexpected Exception while handling notification", (Object[])new Object[]{e});
            }
        }
    }

    private boolean validateNotificationOrder(AttributeChangeNotification acn) {
        boolean isValid = false;
        Map<String, AttributeChangeNotification> attrs = null;
        if (!this.isObsoleteNotification(acn)) {
            attrs = this.getAttributeMap(acn);
            AttributeChangeNotification prevAcn = attrs.get(acn.getAttributeName());
            if (prevAcn == null) {
                isValid = true;
            } else if (acn.getTimeStamp() > prevAcn.getTimeStamp()) {
                isValid = true;
            } else if (acn.getTimeStamp() == prevAcn.getTimeStamp() && acn.getSequenceNumber() > prevAcn.getSequenceNumber()) {
                isValid = true;
            }
        }
        if (isValid) {
            attrs.put(acn.getAttributeName(), acn);
        }
        return isValid;
    }

    private boolean isObsoleteNotification(AttributeChangeNotification acn) {
        Long notificationTime;
        boolean isObsolete = false;
        Long creationTime = this.reincarnatedMBeans.get(acn.getSource());
        if (creationTime != null && (notificationTime = Long.valueOf(acn.getTimeStamp())) < creationTime) {
            isObsolete = true;
        }
        return isObsolete;
    }

    private Map<String, AttributeChangeNotification> getAttributeMap(AttributeChangeNotification acn) {
        Map<String, AttributeChangeNotification> attrs = this.mBeanAttrs.get(acn.getSource());
        if (attrs == null) {
            attrs = new HashMap<String, AttributeChangeNotification>();
            this.mBeanAttrs.put(acn.getSource().toString(), attrs);
        }
        return attrs;
    }

    private Event createPublishMBeanAttributeUpdateEvent(String objectName, String attrName, Object attrValue, boolean updateOnly) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (updateOnly) {
            props.put("operation", "UPDATE_ONLY");
        } else {
            props.put("operation", "UPDATE");
        }
        props.put("sendStatusEvent", "true");
        props.put("mbeanObjectName", objectName);
        props.put("mbeanAttributeName", attrName);
        props.put("mbeanAttributeValue", attrValue);
        return new Event("com/ibm/wsspi/collective/repository/publish/mbean", props);
    }

    private Event createPublishMBeanAttributeUpdateOnlyEvent(AttributeChangeNotification acn, String objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("ObjectName handback was null for AttributeChangeNotification: " + acn);
        }
        return this.createPublishMBeanAttributeUpdateEvent(objectName, acn.getAttributeName(), acn.getNewValue(), true);
    }

    private Event createPublishDeleteMBeanEvent(String objectName) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("operation", "DELETE");
        props.put("mbeanObjectName", objectName);
        return new Event("com/ibm/wsspi/collective/repository/publish/mbean", props);
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        return notification instanceof AttributeChangeNotification;
    }

    @Trivial
    private EventAdmin getEventAdminService() {
        EventAdmin service = (EventAdmin)this.eventAdminRef.getService();
        if (service == null) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignore that EventAdminService is null because Framework is in the process of stopping or already stopped", (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"EventAdminService is null and Framework is not in the process of stopping or already stopped", (Object[])new Object[0]);
                }
                IllegalStateException ise = new IllegalStateException("The EventAdmin service is not available - it was likely accessed after it was deactivated.");
                ise.fillInStackTrace();
                throw ise;
            }
        }
        return service;
    }

    private String showAttrNotifInfo(AttributeChangeNotification acn) {
        StringBuffer sb = new StringBuffer();
        sb.append("AttributeName=");
        sb.append(acn.getAttributeName());
        sb.append(", OldValue=");
        sb.append(acn.getOldValue());
        sb.append(", NewValue=");
        sb.append(acn.getNewValue());
        sb.append(", SequenceNumber=");
        sb.append(acn.getSequenceNumber());
        sb.append(", TimeStamp=");
        sb.append(acn.getTimeStamp());
        return sb.toString();
    }
}

