/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.connection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigurationNotAvailableException;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.collective.member.Endpoint;
import com.ibm.ws.collective.member.connection.ConnectionPropertiesCollector;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.client.rest.ClientProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.member.connection.CollectiveConnectionService;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={CollectiveConnectionService.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class CollectiveConnectionServiceImpl
implements CollectiveConnectionService {
    private static final TraceComponent tc = Tr.register(CollectiveConnectionServiceImpl.class);
    private SSLSocketFactory sslSocketFactory = null;
    private JMXConnector jmxConnector = null;
    private MBeanServerConnection mbeanServerConnection = null;
    private SSLSupport sslSupport = null;
    private ConnectionPropertiesCollector connPropertiesCollector = null;
    static final long serialVersionUID = 1771962476518394251L;

    @Reference(service=SSLSupport.class)
    protected void setSSLSupport(SSLSupport reference) {
        this.sslSupport = reference;
    }

    protected void unsetSSLSupport(SSLSupport reference) {
        if (this.sslSupport == reference) {
            this.sslSupport = null;
        }
    }

    @Reference(service=ConnectionPropertiesCollector.class)
    protected void setConnPropertiesCollector(ConnectionPropertiesCollector reference) {
        this.connPropertiesCollector = reference;
    }

    protected void unsetConnPropertiesCollector(ConnectionPropertiesCollector reference) {
        if (this.connPropertiesCollector == reference) {
            this.connPropertiesCollector = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public MBeanServerConnection getMBeanServerConnection(NotificationListener listener, NotificationFilter filter, Object handback) throws IOException {
        MBeanServerConnection mbsc = null;
        if (this.connPropertiesCollector != null) {
            Map<String, Object> connProps = this.connPropertiesCollector.getMemberConnectionProperties();
            try {
                mbsc = this.setupConnection(connProps, listener, filter, handback);
            }
            catch (SSLConfigurationNotAvailableException sSLConfigurationNotAvailableException) {
                void e;
                FFDCFilter.processException((Throwable)sSLConfigurationNotAvailableException, (String)"com.ibm.ws.collective.member.connection.CollectiveConnectionServiceImpl", (String)"97", (Object)this, (Object[])new Object[]{listener, filter, handback});
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unable to connect to the collective controller endpoints.  The SSL configuration is not ready yet.", (Object[])new Object[]{e});
                }
                throw this.asExplainedIOException((Exception)e);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.connection.CollectiveConnectionServiceImpl", (String)"102", (Object)this, (Object[])new Object[]{listener, filter, handback});
                this.close(listener, filter, handback);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unable to connect to any of the collective controller endpoints. ", (Object[])new Object[]{e});
                }
                throw this.asExplainedIOException(e);
            }
        }
        return mbsc;
    }

    private MBeanServerConnection setupConnection(Map<String, Object> connProps, NotificationListener listener, NotificationFilter filter, Object handback) throws IOException, SSLConfigurationNotAvailableException {
        MBeanServerConnection mbsc = null;
        List endpoints = (List)connProps.get("Endpoints");
        int readTimeoutMillis = (Integer)connProps.get("ReadTimeoutMillis");
        String sslConfig = (String)connProps.get("SSLConfig");
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put("jmx.remote.protocol.provider.pkgs", "com.ibm.ws.jmx.connector.client");
        environment.put("jmx.remote.credentials", "com.ibm.ws.jmx.connector.client.CLIENT_CERT_AUTH");
        environment.put("com.ibm.ws.jmx.connector.client.rest.readTimeout", readTimeoutMillis);
        environment.put("com.ibm.ws.jmx.connector.client.disableURLHostnameVerification", Boolean.TRUE);
        environment.put("com.ibm.ws.jmx.connector.client.rest.notificationFetchInterval", 10000);
        environment.put("com.ibm.ws.jmx.connector.client.wlm.endpoints", Endpoint.getStringList(endpoints));
        if (endpoints.size() > 1) {
            environment.put("com.ibm.ws.jmx.connector.client.rest.maxServerWaitTime", 5000);
        }
        JMXConnector connector = this.getJMXConnector(endpoints, sslConfig, environment);
        mbsc = this.getMBeanConnection(connector, listener, filter, handback);
        return mbsc;
    }

    /*
     * WARNING - void declaration
     */
    private SSLSocketFactory getSSLSocketFactory(JSSEHelper jsseHelper, String sslConfig) throws IOException, SSLConfigurationNotAvailableException {
        SSLContext context = null;
        SSLSocketFactory factory = null;
        String failureMessage = "Could not get an SSL context for the specified SSL configuration: " + sslConfig + ". Check that the specified SSL configuration is correct.";
        try {
            context = jsseHelper.getSSLContext(sslConfig, null, null, false);
        }
        catch (SSLConfigurationNotAvailableException sSLConfigurationNotAvailableException) {
            void e;
            FFDCFilter.processException((Throwable)sSLConfigurationNotAvailableException, (String)"com.ibm.ws.collective.member.connection.CollectiveConnectionServiceImpl", (String)"171", (Object)this, (Object[])new Object[]{jsseHelper, sslConfig});
            throw e;
        }
        catch (SSLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.connection.CollectiveConnectionServiceImpl", (String)"173", (Object)this, (Object[])new Object[]{jsseHelper, sslConfig});
            throw new IOException(failureMessage, e);
        }
        if (context == null) {
            throw new IllegalStateException(failureMessage);
        }
        factory = this.getSocketFactory(context);
        if (factory == null) {
            throw new IllegalStateException("Factory from context was null");
        }
        return factory;
    }

    protected synchronized void setSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
    }

    private synchronized SSLSocketFactory getSocketFactory(SSLContext context) {
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = context.getSocketFactory();
        }
        return this.sslSocketFactory;
    }

    protected synchronized void setJMXConnector(JMXConnector connector) {
        this.jmxConnector = connector;
    }

    private synchronized JMXConnector getJMXConnector(List<Endpoint> endpoints, String sslConfig, HashMap<String, Object> environment) throws IOException, MalformedURLException, SSLConfigurationNotAvailableException {
        if (this.jmxConnector == null && this.sslSupport != null) {
            JSSEHelper jsseHelper = this.sslSupport.getJSSEHelper();
            SSLSocketFactory sslSF = this.getSSLSocketFactory(jsseHelper, sslConfig);
            environment.put("com.ibm.ws.jmx.connector.client.CUSTOM_SSLSOCKETFACTORY", sslSF);
            JMXServiceURL serviceURL = new JMXServiceURL("REST", endpoints.get(0).getHost(), endpoints.get(0).getPort(), "/IBMJMXConnectorREST");
            this.jmxConnector = new ClientProvider().newJMXConnector(serviceURL, environment);
        }
        return this.jmxConnector;
    }

    protected synchronized void setMBeanConnection(MBeanServerConnection mbsc) {
        this.mbeanServerConnection = mbsc;
    }

    private synchronized MBeanServerConnection getMBeanConnection(JMXConnector connector, NotificationListener listener, NotificationFilter filter, Object handback) throws IOException {
        if (this.mbeanServerConnection == null) {
            if (connector != null) {
                connector.connect();
                connector.addConnectionNotificationListener(listener, filter, handback);
                this.mbeanServerConnection = connector.getMBeanServerConnection();
            } else {
                String message = "Failed to get JMXConnector: A network, communication or security error has occured while trying to get MBean server connection";
                IOException ioe = new IOException(message);
                throw ioe;
            }
        }
        return this.mbeanServerConnection;
    }

    private IOException asExplainedIOException(Exception e) throws IOException {
        String message = "A network, communication or security error has occured while trying to connect to the target collective controller. Cause: " + e.getMessage();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[]{e});
        }
        return new IOException(message, e);
    }

    /*
     * WARNING - void declaration
     */
    protected void close(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (this.jmxConnector != null) {
            block6: {
                block5: {
                    try {
                        this.jmxConnector.removeConnectionNotificationListener(listener, filter, handback);
                    }
                    catch (ListenerNotFoundException listenerNotFoundException) {
                        void e;
                        FFDCFilter.processException((Throwable)listenerNotFoundException, (String)"com.ibm.ws.collective.member.connection.CollectiveConnectionServiceImpl", (String)"322", (Object)this, (Object[])new Object[]{listener, filter, handback});
                        if (!tc.isEventEnabled()) break block5;
                        Tr.event((TraceComponent)tc, (String)"Unexpected ListenerNotFoundException while removing listener", (Object[])new Object[]{e});
                    }
                }
                try {
                    this.jmxConnector.close();
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.member.connection.CollectiveConnectionServiceImpl", (String)"330", (Object)this, (Object[])new Object[]{listener, filter, handback});
                    if (!tc.isEventEnabled()) break block6;
                    Tr.event((TraceComponent)tc, (String)"Unexpected IOException while closing JMX connection", (Object[])new Object[]{e});
                }
            }
            this.jmxConnector = null;
        }
    }
}

