/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_ScanCounts;
import com.ibm.ws.anno.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_MappedDirectory;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.anno.classsource.ClassSource_Streamer;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClassSourceImpl_MappedDirectory
extends ClassSourceImpl
implements ClassSource,
ClassSource_MappedDirectory {
    public static final String CLASS_NAME = ClassSourceImpl_MappedDirectory.class.getName();
    private static final TraceComponent tc = Tr.register(ClassSourceImpl_MappedDirectory.class);
    protected static final char FILE_SEPARATOR_CHAR = File.separatorChar;
    protected static final boolean CONVERT_SEPARATORS = FILE_SEPARATOR_CHAR == '\\';
    protected final String dirPath;
    public static final String EMPTY_PREFIX = "";
    static final long serialVersionUID = -1914975092287930751L;

    public ClassSourceImpl_MappedDirectory(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, String dirPath) throws ClassSource_Exception {
        super(factory, internMap, name, dirPath);
        this.dirPath = dirPath;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)this.hashText, (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public void open() throws ClassSource_Exception {
        String methodName = "open";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [{1}] ENTER/RETURN", this.getHashText(), methodName), (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public void close() throws ClassSource_Exception {
        String methodName = "close";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] [{1}] ENTER/RETURN", this.getHashText(), methodName), (Object[])new Object[0]);
        }
    }

    protected String pathAppend(String prefix, String tail) {
        if (prefix.isEmpty()) {
            return tail;
        }
        return prefix + FILE_SEPARATOR_CHAR + tail;
    }

    @Override
    public boolean getConvertResourceNames() {
        return CONVERT_SEPARATORS;
    }

    @Override
    public String inconvertResourceName(String externalResourceName) {
        if (CONVERT_SEPARATORS) {
            return externalResourceName.replace(FILE_SEPARATOR_CHAR, '/');
        }
        return externalResourceName;
    }

    @Override
    public String outconvertResourceName(String internalResourceName) {
        if (CONVERT_SEPARATORS) {
            return internalResourceName.replace('/', FILE_SEPARATOR_CHAR);
        }
        return internalResourceName;
    }

    @Override
    public String getDirPath() {
        return this.dirPath;
    }

    public String getFilePath(String resourcePath) {
        return this.pathAppend(this.getDirPath(), resourcePath);
    }

    @Override
    public void scanClasses(ClassSource_Streamer streamer, Set<String> i_seedClassNamesSet, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        File useDir = new File(this.getDirPath());
        this.scanClasses(useDir, EMPTY_PREFIX, streamer, i_seedClassNamesSet, this.getScanResults(), scanPolicy);
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected void scanClasses(File targetDir, String dirPrefix, ClassSource_Streamer streamer, Set<String> i_seedClassNames, ClassSourceImpl_ScanCounts localScanCounts, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        File[] childFiles;
        String methodName = "scanClasses";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{MessageFormat.format("[ {0} ] ENTER [ {1} ] of [ {2} ]", this.getHashText(), dirPrefix, targetDir.getName())});
        }
        if ((childFiles = UtilImpl_FileUtils.listFiles(targetDir)) == null) {
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_EMPTY_DIR", (Object[])new Object[]{this.getHashText(), targetDir, this.getDirPath()});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.getHashText());
            }
            return;
        }
        int initialResources = i_seedClassNames.size();
        for (File nextChildFile : childFiles) {
            String nextChildName = nextChildFile.getName();
            String nextDirPrefix = this.pathAppend(dirPrefix, nextChildName);
            if (UtilImpl_FileUtils.isDirectory(nextChildFile).booleanValue()) {
                ClassSourceImpl_ScanCounts childCounts = new ClassSourceImpl_ScanCounts();
                this.scanClasses(nextChildFile, nextDirPrefix, streamer, i_seedClassNames, childCounts, scanPolicy);
                localScanCounts.addResults(childCounts);
                localScanCounts.increment(ClassSource_ScanCounts.ResultField.NON_ROOT_CONTAINER);
            } else {
                if (!this.isClassResource(nextDirPrefix)) {
                    this.incrementResourceExclusionCount();
                    localScanCounts.increment(ClassSource_ScanCounts.ResultField.NON_CLASS);
                } else {
                    String nextResourceName = this.inconvertResourceName(nextDirPrefix);
                    String nextClassName = this.getClassNameFromResourceName(nextResourceName);
                    String i_nextClassName = this.internClassName(nextClassName);
                    boolean didAdd = this.i_maybeAdd(i_nextClassName, i_seedClassNames);
                    if (!didAdd) {
                        this.incrementClassExclusionCount();
                        localScanCounts.increment(ClassSource_ScanCounts.ResultField.DUPLICATE_CLASS);
                    } else {
                        boolean didProcess;
                        this.incrementClassInclusionCount();
                        try {
                            didProcess = this.process(streamer, nextClassName, nextResourceName, nextDirPrefix, scanPolicy);
                        }
                        catch (ClassSource_Exception classSource_Exception) {
                            void e;
                            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedDirectory", (String)"226", (Object)this, (Object[])new Object[]{targetDir, dirPrefix, streamer, i_seedClassNames, localScanCounts, scanPolicy});
                            didProcess = false;
                            Tr.warning((TraceComponent)tc, (String)"ANNO_TARGETS_SCAN_EXCEPTION", (Object[])new Object[]{e});
                        }
                        if (didProcess) {
                            localScanCounts.increment(ClassSource_ScanCounts.ResultField.PROCESSED_CLASS);
                        } else {
                            localScanCounts.increment(ClassSource_ScanCounts.ResultField.UNPROCESSED_CLASS);
                        }
                    }
                    localScanCounts.increment(ClassSource_ScanCounts.ResultField.CLASS);
                }
                localScanCounts.increment(ClassSource_ScanCounts.ResultField.NON_CONTAINER);
            }
            localScanCounts.increment(ClassSource_ScanCounts.ResultField.ENTRY);
        }
        int finalResources = i_seedClassNames.size();
        if (tc.isDebugEnabled()) {
            Object[] logParms = new Object[]{this.getHashText(), null, null};
            logParms[1] = finalResources - initialResources;
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] Added classes", logParms), (Object[])new Object[0]);
            for (ClassSource_ScanCounts.ResultField resultField : ClassSource_ScanCounts.ResultField.values()) {
                int nextResult = localScanCounts.getResult(resultField);
                String nextResultTag = resultField.getTag();
                logParms[1] = nextResult;
                logParms[2] = nextResultTag;
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ]  [ {1} ] {2}", logParms), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)MessageFormat.format("[ {0} ] RETURN [ {1} ] Added classes", this.getHashText(), finalResources - initialResources));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process(ClassSource_Streamer streamer, String className, String resourceName, String externalResourceName, ClassSource_Aggregate.ScanPolicy scanPolicy) throws ClassSource_Exception {
        if (streamer == null) {
            return true;
        }
        if (!streamer.doProcess(className, scanPolicy)) {
            return false;
        }
        InputStream inputStream = this.openResourceStream(className, resourceName, externalResourceName);
        if (inputStream == null) {
            return false;
        }
        try {
            streamer.process(this.getCanonicalName(), className, inputStream, scanPolicy);
        }
        finally {
            this.closeResourceStream(className, resourceName, externalResourceName, inputStream);
        }
        return true;
    }

    @Override
    public InputStream openClassStream(String className) throws ClassSource_Exception {
        String resourceName = this.getResourceNameFromClassName(className);
        String externalResourceName = this.outconvertResourceName(resourceName);
        return this.openResourceStream(className, resourceName, externalResourceName);
    }

    @Override
    public InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        String externalResourceName = this.outconvertResourceName(resourceName);
        return this.openResourceStream(className, resourceName, externalResourceName);
    }

    /*
     * WARNING - void declaration
     */
    protected InputStream openResourceStream(String className, String resourceName, String externalResourceName) throws ClassSource_Exception {
        FileInputStream result;
        String methodName = "openResourceStream";
        String filePath = this.getFilePath(externalResourceName);
        File file = new File(filePath);
        if (!UtilImpl_FileUtils.exists(file)) {
            return null;
        }
        if (UtilImpl_FileUtils.isDirectory(file).booleanValue()) {
            String eMsg = "[ " + this.getHashText() + " ] Found directory [ " + filePath + " ] for resource [ " + externalResourceName + " ] under root [ " + this.getDirPath() + " ] for class [ " + className + " ]";
            throw this.getFactory().newClassSourceException(eMsg);
        }
        try {
            result = UtilImpl_FileUtils.createFileInputStream(file);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedDirectory", (String)"361", (Object)this, (Object[])new Object[]{className, resourceName, externalResourceName});
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + filePath + " ] for resource [ " + externalResourceName + " ] under root [ " + this.getDirPath() + " ] for class [ " + className + " ]";
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)e);
        }
        return result;
    }

    @Override
    public void closeClassStream(String className, InputStream inputStream) {
        String resourceName = this.getResourceNameFromClassName(className);
        String externalResourceName = this.outconvertResourceName(resourceName);
        this.closeResourceStream(className, resourceName, externalResourceName, inputStream);
    }

    @Override
    public void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        String externalResourceName = this.outconvertResourceName(resourceName);
        this.closeResourceStream(className, resourceName, externalResourceName, inputStream);
    }

    protected void closeResourceStream(String className, String resourceName, String externalResourceName, InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_MappedDirectory", (String)"402", (Object)this, (Object[])new Object[]{className, resourceName, externalResourceName, inputStream});
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_CLOSE4_EXCEPTION", (Object[])new Object[]{this.getHashText(), externalResourceName, this.getDirPath(), className});
        }
    }

    @Override
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Class Source [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }
}

