/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.session.SessionStoreService;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.webcontainer.httpsession.SessionManager;
import com.ibm.ws.webcontainer.httpsession.SessionMgrComponentImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.util.Dictionary;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

public class SessionMgrCoordinator {
    private static final String CLASS_NAME = SessionMgrCoordinator.class.getSimpleName();
    private volatile ComponentContext context;
    private volatile ServiceRegistration<SessionManager> smgrRegistration = null;
    private volatile SessionMgrComponentImpl smgr = null;
    private ConfigurationAdmin configAdmin = null;
    private WsLocationAdmin wsLocationAdmin = null;
    private ApplicationRecycleCoordinator appRecycleService = null;
    private SessionStoreService sessionStoreService = null;
    private ScheduledExecutorService scheduledExecutorService = null;

    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "activate", context);
        }
        this.context = context;
        if (this.sessionStoreService == null && this.foundDatabaseConfig()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, CLASS_NAME, "activate", "Will not register default SessionManager service because a SesionStoreService will be available soon");
            }
        } else {
            this.registerSessionManager();
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "activate");
        }
    }

    protected void modified(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "modified", context);
        }
        this.context = context;
        this.registerSessionManager();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "modified");
        }
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "deactivate", context);
        }
        this.unregisterSessionManager();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "deactivate");
        }
    }

    private synchronized void unregisterSessionManager() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "unregisterSessionManager");
        }
        if (this.smgrRegistration != null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, CLASS_NAME, "unregisterSessionManager", "Unregistering current SessionManager");
            }
            this.smgrRegistration.unregister();
            this.smgrRegistration = null;
            SessionMgrComponentImpl.INSTANCE.compareAndSet(this.smgr, null);
            this.smgr = null;
        } else if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, CLASS_NAME, "unregisterSessionManager", "No SessionManager is currently registered; no need to unregister");
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "unregisterSessionManager");
        }
    }

    private synchronized void registerSessionManager() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "registerSessionManager");
        }
        if (this.context == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "registerSessionManager");
            }
            return;
        }
        if (this.smgr != null && this.smgr.isInitialized()) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, CLASS_NAME, "registerSessionManager", "Stopping applications because the SessionManager has been initialized");
            }
            try {
                this.appRecycleService.recycleApplications(null);
            }
            catch (Throwable thrown) {
                FFDCFilter.processException((Throwable)thrown, (String)this.getClass().getName(), (String)"153", (Object)this);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, CLASS_NAME, "registerSessionManager", "Skipping application restart because the SessionManager is not initialized");
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, CLASS_NAME, "registerSessionManager", "Registering a new SessionManager service");
        }
        Dictionary properties = this.context.getProperties();
        SessionMgrComponentImpl newSmgr = new SessionMgrComponentImpl(this.scheduledExecutorService, this.wsLocationAdmin, this.sessionStoreService, properties);
        ServiceRegistration newSmgrRegistration = this.context.getBundleContext().registerService(SessionManager.class, (Object)newSmgr, properties);
        this.unregisterSessionManager();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, CLASS_NAME, "registerSessionManager", "Caching new new SessionManager registration");
        }
        this.smgrRegistration = newSmgrRegistration;
        this.smgr = newSmgr;
        SessionMgrComponentImpl.INSTANCE.set(this.smgr);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "registerSessionManager");
        }
    }

    private boolean foundDatabaseConfig() {
        boolean found = false;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "foundDatabaseConfig");
        }
        String configFilter = FilterUtils.createPropertyFilter((String)"service.pid", (String)"com.ibm.ws.session.db");
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, CLASS_NAME, "foundDatabaseConfig", "Configuration filter: " + configFilter);
        }
        try {
            Configuration[] configurations = this.configAdmin.listConfigurations(configFilter);
            if (configurations != null) {
                for (Configuration configuration : configurations) {
                    if (configuration == null) continue;
                    found = true;
                    if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) continue;
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, CLASS_NAME, "foundDatabaseConfig", "Found matching configuration at " + configuration.getBundleLocation() + ": " + configuration.getProperties());
                }
            }
        }
        catch (Throwable thrown) {
            FFDCFilter.processException((Throwable)thrown, (String)this.getClass().getName(), (String)"88", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "foundDatabaseConfig", found);
        }
        return found;
    }

    protected void setConfigAdmin(ConfigurationAdmin configurationAdmin) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "setConfigurationAdmin", configurationAdmin);
        }
        this.configAdmin = configurationAdmin;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "setConfigurationAdmin");
        }
    }

    protected void unsetConfigAdmin(ConfigurationAdmin configurationAdmin) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "unsetConfigurationAdmin", configurationAdmin);
        }
        if (this.configAdmin == configurationAdmin) {
            this.configAdmin = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "unsetConfigurationAdmin");
        }
    }

    protected void setLocationService(WsLocationAdmin wsLocationAdmin) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "setLocationService", wsLocationAdmin);
        }
        this.wsLocationAdmin = wsLocationAdmin;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "setLocationService");
        }
    }

    protected void unsetLocationService(WsLocationAdmin wsLocationAdmin) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "unsetLocationService", wsLocationAdmin);
        }
        if (this.wsLocationAdmin == wsLocationAdmin) {
            this.wsLocationAdmin = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "unsetLocationService");
        }
    }

    protected void setAppRecycleService(ApplicationRecycleCoordinator appRecycleService) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "setAppRecycleService", appRecycleService);
        }
        this.appRecycleService = appRecycleService;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "setAppRecycleService");
        }
    }

    protected void unsetAppRecycleService(ApplicationRecycleCoordinator appRecycleService) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "unsetAppRecycleService", appRecycleService);
        }
        if (this.appRecycleService == appRecycleService) {
            this.appRecycleService = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "unsetAppRecycleService");
        }
    }

    protected void setSessionStoreService(SessionStoreService sessionStoreService) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "setSessionStoreService", sessionStoreService);
        }
        this.sessionStoreService = sessionStoreService;
        this.registerSessionManager();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "setSessionStoreService");
        }
    }

    protected void unsetSessionStoreService(SessionStoreService sessionStoreService) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "unsetSessionStoreService", sessionStoreService);
        }
        if (this.sessionStoreService == sessionStoreService) {
            this.sessionStoreService = null;
            this.registerSessionManager();
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "unsetSessionStoreService");
        }
    }

    protected void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "setScheduledExecutorService", scheduledExecutorService);
        }
        this.scheduledExecutorService = scheduledExecutorService;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "setScheduledExecutorService");
        }
    }

    protected void unsetScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(CLASS_NAME, "unsetScheduledExecutorService", scheduledExecutorService);
        }
        if (this.scheduledExecutorService == scheduledExecutorService) {
            this.scheduledExecutorService = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(CLASS_NAME, "unsetScheduledExecutorService");
        }
    }
}

