/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.WasHttpSessionObserver;
import com.ibm.ws.session.http.HttpSessionImpl;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.IProtocolAdapter;
import com.ibm.wsspi.session.ISession;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class WasHttpAppSessionObserver
extends WasHttpSessionObserver {
    private static final String methodClassName = "WasHttpAppSessionObserver";

    public WasHttpAppSessionObserver(ArrayList listeners, IProtocolAdapter adapter) {
        super(listeners, adapter);
    }

    public WasHttpAppSessionObserver(ArrayList listeners, ArrayList idListeners, IProtocolAdapter adapter) {
        super(listeners, idListeners, adapter);
    }

    @Override
    public void sessionDestroyed(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0], "sessionid=" + session.getId());
        }
        ArrayList attributes = session.getListenerAttributeNames();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "attributes.size()=:" + attributes.size());
        }
        if (this._sessionListeners.size() > 0 || attributes.size() > 0) {
            HttpSessionImpl httpsession = (HttpSessionImpl)this._adapter.adapt(session);
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)httpsession);
            HttpSessionListener listener = null;
            for (int i = this._sessionListeners.size() - 1; i >= 0; --i) {
                listener = (HttpSessionListener)this._sessionListeners.get(i);
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "Calling sessionDestroyed on listener:" + listener);
                }
                listener.sessionDestroyed(event);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0]);
        }
    }

    @Override
    public void sessionDidActivate(ISession session) {
    }

    @Override
    public void sessionWillPassivate(ISession session) {
    }
}

