/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.impl.JCARecoveryData;
import com.ibm.tx.jta.impl.JCATranWrapper;
import com.ibm.tx.jta.impl.TranManagerSet;
import com.ibm.tx.jta.impl.TxExecutionContextHandler;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import java.util.HashMap;
import javax.resource.spi.XATerminator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TxXATerminator
implements XATerminator {
    private static final TraceComponent tc = Tr.register(TxXATerminator.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final HashMap<String, Object> _txXATerminators = new HashMap();
    private JCARecoveryData _JCARecoveryData;
    private final String _providerId;

    protected TxXATerminator(String providerId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"TxXATerminator", (Object)providerId);
        }
        this._providerId = providerId;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TxXATerminator", (Object)this._providerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TxXATerminator instance(String providerId) {
        TxXATerminator xat;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"instance", (Object)providerId);
        }
        HashMap<String, Object> hashMap = _txXATerminators;
        synchronized (hashMap) {
            if (_txXATerminators.containsKey(providerId)) {
                xat = (TxXATerminator)_txXATerminators.get(providerId);
            } else {
                xat = new TxXATerminator(providerId);
                _txXATerminators.put(providerId, xat);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"instance", (Object)xat);
        }
        return xat;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        JCATranWrapper txWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit", (Object)new Object[]{xid, onePhase});
        }
        try {
            this.validateXid(xid);
            txWrapper = this.getTxWrapper(xid, true);
        }
        catch (XAException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)("caught XAException: " + XAReturnCodeHelper.convertXACode(e.errorCode)));
            }
            throw e;
        }
        try {
            if (onePhase) {
                txWrapper.commitOnePhase();
            } else {
                txWrapper.commit();
            }
        }
        catch (XAException e) {
            TxExecutionContextHandler.removeAssociation(txWrapper);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)("rethrowing XAException: " + XAReturnCodeHelper.convertXACode(e.errorCode)));
            }
            throw e;
        }
        TxExecutionContextHandler.removeAssociation(txWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forget", (Object)xid);
        }
        try {
            this.validateXid(xid);
            JCATranWrapper txWrapper = this.getTxWrapper(xid, false);
            txWrapper.forget();
        }
        catch (XAException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"forget", (Object)new Object[]{"rethrowing XAException", e});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forget");
        }
    }

    public int prepare(Xid xid) throws XAException {
        int result;
        JCATranWrapper txWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepare", (Object)xid);
        }
        try {
            this.validateXid(xid);
            txWrapper = this.getTxWrapper(xid, true);
        }
        catch (XAException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepare", (Object)new Object[]{"caught XAException", e});
            }
            throw e;
        }
        try {
            result = txWrapper.prepare(this);
        }
        catch (XAException e) {
            TxExecutionContextHandler.removeAssociation(txWrapper);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"prepare", (Object)new Object[]{"prepare threw XAException", e});
            }
            throw e;
        }
        TxExecutionContextHandler.removeAssociation(txWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepare", (Object)result);
        }
        return result;
    }

    public Xid[] recover(int flag) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object)Util.printFlag(flag));
        }
        Xid[] result = TxExecutionContextHandler.recover(flag);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover", (Object)result);
        }
        return result;
    }

    public void rollback(Xid xid) throws XAException {
        JCATranWrapper txWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollback", (Object)xid);
        }
        try {
            this.validateXid(xid);
            txWrapper = this.getTxWrapper(xid, true);
        }
        catch (XAException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback", (Object)("caught XAException: " + XAReturnCodeHelper.convertXACode(e.errorCode)));
            }
            throw e;
        }
        try {
            txWrapper.rollback();
        }
        catch (XAException e) {
            TxExecutionContextHandler.removeAssociation(txWrapper);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback", (Object)("rethrowing XAException: " + XAReturnCodeHelper.convertXACode(e.errorCode)));
            }
            throw e;
        }
        TxExecutionContextHandler.removeAssociation(txWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    protected JCATranWrapper getTxWrapper(Xid xid, boolean addAssociation) throws XAException {
        JCATranWrapper txWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTxWrapper", (Object)xid);
        }
        if ((txWrapper = TxExecutionContextHandler.getTxWrapper(xid, addAssociation)).getTransaction() == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getTxWrapper", (Object)"no transaction was found for the specified XID");
            }
            throw new XAException(-4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTxWrapper", (Object)txWrapper);
        }
        return txWrapper;
    }

    private void validateXid(Xid xid) throws XAException {
        if (!TxXATerminator.isValid(xid)) {
            throw new XAException(-5);
        }
    }

    public static boolean isValid(Xid xid) {
        boolean result;
        boolean bl = result = null != xid && -1 != xid.getFormatId() && null != xid.getGlobalTransactionId() && 0 <= xid.getGlobalTransactionId().length && 64 >= xid.getGlobalTransactionId().length;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isValid", (Object)result);
        }
        return result;
    }

    public String toString() {
        return "TxXATerminator: providerId=" + this._providerId;
    }

    public JCARecoveryData getJCARecoveryData() {
        if (this._JCARecoveryData == null) {
            this._JCARecoveryData = (JCARecoveryData)((TranManagerSet)TransactionManagerFactory.getTransactionManager()).registerJCAProvider(this._providerId);
        }
        return this._JCARecoveryData;
    }
}

