/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.util.ScheduleExpressionParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.ejb.ScheduleExpression;

public class ParsedScheduleExpression
implements Serializable {
    private static final TraceComponent tc = Tr.register(ParsedScheduleExpression.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final long serialVersionUID = 5940938222835797932L;
    private static final int VERSION = 1;
    static final int WILD_CARD = 0;
    private transient ScheduleExpression ivSchedule;
    transient long start;
    transient long end;
    transient long seconds;
    transient long minutes;
    transient int hours;
    transient int daysOfWeek;
    transient int daysOfMonth;
    transient int lastDaysOfMonth;
    transient long daysOfWeekInMonth;
    transient int lastDaysOfWeekInMonth;
    transient List<VariableDayOfMonthRange> variableDayOfMonthRanges;
    transient int months;
    transient BitSet years;
    transient TimeZone timeZone;
    static final int ADVANCE_TO_NEXT_MONTH = 99;

    private static boolean contains(long haystack, int needle) {
        return (haystack & 1L << needle) != 0L;
    }

    private static long higher(long haystack, int needle) {
        return haystack & ((1L << needle + 1) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static int first(long haystack) {
        return Long.numberOfTrailingZeros(haystack);
    }

    private static int firstOfWildCard(long haystack) {
        return haystack == 0L ? 0 : ParsedScheduleExpression.first(haystack);
    }

    private static String toString(Calendar cal) {
        return String.format("%04d-%02d-%02d %02d:%02d:%02d %s", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.getTimeZone().getID());
    }

    ParsedScheduleExpression(ScheduleExpression schedule) {
        this.ivSchedule = schedule;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder out = new StringBuilder();
        out.append(super.toString());
        out.append(nl).append("  start:        ").append(this.start == 0L ? "<none>" : ParsedScheduleExpression.toString(this.createCalendar(this.start)));
        out.append(nl).append("  end:          ").append(this.end == Long.MAX_VALUE ? "<none>" : ParsedScheduleExpression.toString(this.createCalendar(this.end)));
        out.append(nl).append("  timeZone:     ").append(this.timeZone.getID());
        ParsedScheduleExpression.toString(out.append(nl).append("  seconds:      "), this.seconds, 0, null);
        ParsedScheduleExpression.toString(out.append(nl).append("  minutes:      "), this.minutes, 0, null);
        ParsedScheduleExpression.toString(out.append(nl).append("  hours:        "), this.hours, 0, null);
        ParsedScheduleExpression.toString(out.append(nl).append("  daysOfWeek:   "), this.daysOfWeek, 0, ScheduleExpressionParser.DAYS_OF_WEEK);
        ParsedScheduleExpression.toString(out.append(nl).append("  daysOfMonth:  "), this.daysOfMonth, 1, null);
        out.append(nl).append("    last:       ");
        this.toStringLastDaysOfMonth(out);
        out.append(nl).append("    variable:   ");
        this.toStringVariableDayOfMonthRanges(out, "                ", nl);
        out.append(nl).append("  dowInMonth:   ");
        this.toStringDaysOfWeekInMonth(out);
        out.append(nl).append("    last:       ");
        this.toStringLastDaysOfWeekInMonth(out);
        ParsedScheduleExpression.toString(out.append(nl).append("  months:       "), this.months, 0, ScheduleExpressionParser.MONTHS);
        out.append(nl).append("  years:        ");
        this.toStringYears(out);
        return out.toString();
    }

    private static boolean toStringAddComma(StringBuilder out, boolean any) {
        if (any) {
            out.append(", ");
        }
        return true;
    }

    private static void toString(StringBuilder out, long value, int min, String[] values) {
        if (value == 0L) {
            out.append("*");
        } else {
            boolean any = false;
            for (int i = 0; i < 64; ++i) {
                if (!ParsedScheduleExpression.contains(value, i)) continue;
                any = ParsedScheduleExpression.toStringAddComma(out, any);
                out.append(values != null ? values[i] : Integer.toString(i + min));
            }
            if (!any) {
                out.append("<none>");
            }
        }
    }

    private void toStringLastDaysOfMonth(StringBuilder out) {
        if (this.lastDaysOfMonth == 0) {
            out.append("<none>");
        } else {
            boolean any = false;
            for (int i = 0; i <= 7; ++i) {
                if (!ParsedScheduleExpression.contains(this.lastDaysOfMonth, i)) continue;
                any = ParsedScheduleExpression.toStringAddComma(out, any);
                out.append(i == 7 ? "Last" : Integer.toString(i - 7));
            }
        }
    }

    private void toStringDaysOfWeekInMonth(StringBuilder out) {
        if (this.daysOfWeekInMonth == 0L) {
            out.append("<none>");
        } else {
            boolean any = false;
            for (int weekInMonth = 0; weekInMonth < 5; ++weekInMonth) {
                for (int dayOfWeek = 0; dayOfWeek < 7; ++dayOfWeek) {
                    if (!ParsedScheduleExpression.contains(this.daysOfWeekInMonth, weekInMonth * 7 + dayOfWeek)) continue;
                    any = ParsedScheduleExpression.toStringAddComma(out, any);
                    out.append(ScheduleExpressionParser.WEEKS_OF_MONTH[weekInMonth]).append(' ').append(ScheduleExpressionParser.DAYS_OF_WEEK[dayOfWeek]);
                }
            }
        }
    }

    private void toStringLastDaysOfWeekInMonth(StringBuilder out) {
        if (this.lastDaysOfWeekInMonth == 0) {
            out.append("<none>");
        } else {
            boolean any = false;
            for (int dayOfWeek = 0; dayOfWeek < 7; ++dayOfWeek) {
                if (!ParsedScheduleExpression.contains(this.lastDaysOfWeekInMonth, dayOfWeek)) continue;
                any = ParsedScheduleExpression.toStringAddComma(out, any);
                out.append("Last ").append(ScheduleExpressionParser.DAYS_OF_WEEK[dayOfWeek]);
            }
        }
    }

    private void toStringYears(StringBuilder out) {
        if (this.years == null) {
            out.append('*');
        } else {
            boolean any = false;
            for (int i = 1000; i <= 9999; ++i) {
                if (!this.years.get(i - 1000)) continue;
                int end = i;
                while (end + 1 <= 9999 && this.years.get(end + 1 - 1000)) {
                    ++end;
                }
                any = ParsedScheduleExpression.toStringAddComma(out, any);
                if (i != end) {
                    out.append(i).append('-').append(end);
                    i = end;
                    continue;
                }
                out.append(i);
            }
        }
    }

    private void toStringVariableDayOfMonthRanges(StringBuilder out, String indent, String nl) {
        if (this.variableDayOfMonthRanges == null) {
            out.append("<none>");
        } else {
            boolean any = false;
            for (int i = 0; i < this.variableDayOfMonthRanges.size(); ++i) {
                if (any) {
                    out.append(nl).append(indent);
                } else {
                    any = true;
                }
                out.append(this.variableDayOfMonthRanges.get(i));
            }
        }
    }

    public ScheduleExpression getSchedule() {
        return this.ivSchedule;
    }

    public long getFirstTimeout() {
        long lastTimeout = Math.max(System.currentTimeMillis(), this.start);
        if (lastTimeout > this.end) {
            return -1L;
        }
        return this.getTimeout(lastTimeout, false);
    }

    public long getNextTimeout(long lastTimeout) {
        if (lastTimeout < this.start) {
            throw new IllegalArgumentException("last timeout " + lastTimeout + " is before start time " + this.start);
        }
        if (lastTimeout > this.end) {
            throw new IllegalArgumentException("last timeout " + lastTimeout + " is after end time " + this.end);
        }
        if (lastTimeout % 1000L != 0L) {
            throw new IllegalArgumentException("last timeout " + lastTimeout + " is mid-second");
        }
        return this.getTimeout(lastTimeout, true);
    }

    private Calendar createCalendar(long time) {
        GregorianCalendar cal = new GregorianCalendar(this.timeZone);
        cal.setTimeInMillis(time);
        return cal;
    }

    private long getTimeout(long lastTimeout, boolean reschedule) {
        Calendar cal = this.createCalendar(lastTimeout);
        if (reschedule) {
            cal.add(13, 1);
        } else if (lastTimeout != this.start && lastTimeout % 1000L != 0L) {
            cal.set(14, 0);
            cal.add(13, 1);
        }
        if (!this.advance(cal)) {
            return -1L;
        }
        return cal.getTimeInMillis();
    }

    private boolean advance(Calendar cal) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("advance: " + ParsedScheduleExpression.toString(cal)), (Object[])new Object[0]);
        }
        while (true) {
            int month;
            int year;
            int hour;
            int minute;
            int second;
            if (cal.getTimeInMillis() > this.end) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("advance: failed: " + ParsedScheduleExpression.toString(cal)));
                }
                return false;
            }
            if (this.seconds != 0L && !ParsedScheduleExpression.contains(this.seconds, second = cal.get(13))) {
                ParsedScheduleExpression.advance(cal, 13, 12, this.seconds, second);
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("advanced second: " + ParsedScheduleExpression.toString(cal)), (Object[])new Object[0]);
                continue;
            }
            if (this.minutes != 0L && !ParsedScheduleExpression.contains(this.minutes, minute = cal.get(12))) {
                cal.set(13, ParsedScheduleExpression.firstOfWildCard(this.seconds));
                ParsedScheduleExpression.advance(cal, 12, 11, this.minutes, minute);
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("advanced minute: " + ParsedScheduleExpression.toString(cal)), (Object[])new Object[0]);
                continue;
            }
            if (this.hours != 0 && !ParsedScheduleExpression.contains(this.hours, hour = cal.get(11))) {
                cal.set(13, ParsedScheduleExpression.firstOfWildCard(this.seconds));
                cal.set(12, ParsedScheduleExpression.firstOfWildCard(this.minutes));
                ParsedScheduleExpression.advance(cal, 11, 5, this.hours, hour);
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("advanced hour: " + ParsedScheduleExpression.toString(cal)), (Object[])new Object[0]);
                continue;
            }
            if (this.advanceDayIfNeeded(cal)) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("advanced day: " + ParsedScheduleExpression.toString(cal)), (Object[])new Object[0]);
                }
                if ((year = cal.get(1)) <= 9999) continue;
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("advance: failed: " + ParsedScheduleExpression.toString(cal)));
                }
                return false;
            }
            if (this.months != 0 && !ParsedScheduleExpression.contains(this.months, month = cal.get(2))) {
                cal.set(13, ParsedScheduleExpression.firstOfWildCard(this.seconds));
                cal.set(12, ParsedScheduleExpression.firstOfWildCard(this.minutes));
                cal.set(11, ParsedScheduleExpression.firstOfWildCard(this.hours));
                cal.set(5, 1);
                ParsedScheduleExpression.advance(cal, 2, 1, this.months, month);
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("advanced month: " + ParsedScheduleExpression.toString(cal)), (Object[])new Object[0]);
                continue;
            }
            year = cal.get(1);
            if (this.years == null) {
                if (year <= 9999) break;
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("advance: failed: " + ParsedScheduleExpression.toString(cal)));
                }
                return false;
            }
            if (this.years.get(year - 1000)) break;
            cal.set(13, ParsedScheduleExpression.firstOfWildCard(this.seconds));
            cal.set(12, ParsedScheduleExpression.firstOfWildCard(this.minutes));
            cal.set(11, ParsedScheduleExpression.firstOfWildCard(this.hours));
            cal.set(5, 1);
            cal.set(2, ParsedScheduleExpression.firstOfWildCard(this.months));
            if (!this.advanceYear(cal, year)) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("advance: failed to advance past year " + year));
                }
                return false;
            }
            if (!isTraceOn || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("advanced year: " + ParsedScheduleExpression.toString(cal)), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("advance: " + ParsedScheduleExpression.toString(cal)));
        }
        return true;
    }

    private boolean advanceDayIfNeeded(Calendar cal) {
        int result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        int day = cal.get(5) - 1;
        int nextDay = Integer.MAX_VALUE;
        if (this.daysOfMonth != 0) {
            int result2 = this.getNextDayOfMonth(day);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("next dayOfMonth = " + result2), (Object[])new Object[0]);
            }
            if (result2 == day) {
                return false;
            }
            nextDay = Math.min(nextDay, result2);
        }
        int lastDay = cal.getActualMaximum(5) - 1;
        if (this.lastDaysOfMonth != 0) {
            int result3 = this.getNextLastDayOfMonth(day, lastDay);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("next lastDayOfMonth = " + result3), (Object[])new Object[0]);
            }
            if (result3 == day) {
                return false;
            }
            nextDay = Math.min(nextDay, result3);
        }
        int dayOfWeek = cal.get(7) - 1;
        if (this.daysOfWeek != 0) {
            result = this.getNextDayOfWeek(day, dayOfWeek);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("next daysOfWeek = " + result), (Object[])new Object[0]);
            }
            if (result == day) {
                return false;
            }
            nextDay = Math.min(nextDay, result);
        }
        if (this.daysOfWeekInMonth != 0L) {
            result = this.getNextDayOfWeekInMonth(day, lastDay, dayOfWeek);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("daysOfWeekInMonth includes " + result), (Object[])new Object[0]);
            }
            if (result == day) {
                return false;
            }
            nextDay = Math.min(nextDay, result);
        }
        if (this.lastDaysOfWeekInMonth != 0) {
            result = this.getNextLastDayOfWeekInMonth(day, lastDay, dayOfWeek);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("next lastDaysOfWeekInMonth = " + result), (Object[])new Object[0]);
            }
            if (result == day) {
                return false;
            }
            nextDay = Math.min(nextDay, result);
        }
        if (this.variableDayOfMonthRanges != null) {
            result = this.getNextVariableDay(day, lastDay, dayOfWeek);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("next variableDayOfMonthRanges = " + result), (Object[])new Object[0]);
            }
            if (result == day) {
                return false;
            }
            nextDay = Math.min(nextDay, result);
        }
        if (nextDay == Integer.MAX_VALUE) {
            return false;
        }
        cal.set(13, ParsedScheduleExpression.firstOfWildCard(this.seconds));
        cal.set(12, ParsedScheduleExpression.firstOfWildCard(this.minutes));
        cal.set(11, ParsedScheduleExpression.firstOfWildCard(this.hours));
        if (nextDay <= lastDay) {
            cal.set(5, nextDay + 1);
        } else {
            cal.set(5, 1);
            cal.add(2, 1);
        }
        return true;
    }

    private static void advance(Calendar cal, int field, int nextField, long haystack, int needle) {
        long higher = ParsedScheduleExpression.higher(haystack, needle);
        if (higher != 0L) {
            cal.set(field, ParsedScheduleExpression.first(higher));
        } else {
            cal.set(field, ParsedScheduleExpression.first(haystack));
            cal.add(nextField, 1);
        }
    }

    private int getNextDayOfMonth(int day) {
        if (!ParsedScheduleExpression.contains(this.daysOfMonth, day)) {
            long higher = ParsedScheduleExpression.higher(this.daysOfMonth, day);
            if (higher != 0L) {
                return ParsedScheduleExpression.first(higher);
            }
            return 99;
        }
        return day;
    }

    private int getNextLastDayOfMonth(int day, int lastDay) {
        int offset = lastDay - 7;
        long bits = this.lastDaysOfMonth << offset;
        if (!ParsedScheduleExpression.contains(bits, day)) {
            long higher = ParsedScheduleExpression.higher(bits, day);
            if (higher != 0L) {
                return ParsedScheduleExpression.first(higher);
            }
            return 99;
        }
        return day;
    }

    private int getNextDayOfWeek(int day, int dayOfWeek) {
        if (!ParsedScheduleExpression.contains(this.daysOfWeek, dayOfWeek)) {
            long higher = ParsedScheduleExpression.higher(this.daysOfWeek, dayOfWeek);
            if (higher != 0L) {
                return day + (ParsedScheduleExpression.first(higher) - dayOfWeek);
            }
            return day + (7 - dayOfWeek) + ParsedScheduleExpression.first(this.daysOfWeek);
        }
        return day;
    }

    private int getNextDayOfWeekInMonth(int day, int lastDay, int dayOfWeek) {
        int weekInMonth = day / 7;
        while (!ParsedScheduleExpression.contains(this.daysOfWeekInMonth, weekInMonth * 7 + dayOfWeek)) {
            if (++day > lastDay) {
                return 99;
            }
            if (day % 7 == 0) {
                ++weekInMonth;
            }
            dayOfWeek = (dayOfWeek + 1) % 7;
        }
        return day;
    }

    private int getNextLastDayOfWeekInMonth(int day, int lastDay, int dayOfWeek) {
        while (lastDay - day >= 7 || !ParsedScheduleExpression.contains(this.lastDaysOfWeekInMonth, dayOfWeek)) {
            if (++day > lastDay) {
                return 99;
            }
            dayOfWeek = (dayOfWeek + 1) % 7;
        }
        return day;
    }

    private int getNextVariableDay(int day, int lastDay, int dayOfWeek) {
        int nextDay = 99;
        for (int i = 0; i < this.variableDayOfMonthRanges.size(); ++i) {
            int result = this.variableDayOfMonthRanges.get(i).getNextDay(day, lastDay, dayOfWeek);
            if (result == day) {
                return day;
            }
            nextDay = Math.min(nextDay, result);
        }
        return nextDay;
    }

    private boolean advanceYear(Calendar cal, int year) {
        if ((year = this.years.nextSetBit(year + 1 - 1000)) >= 0) {
            cal.set(1, year + 1000);
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeObject", (Object[])new Object[0]);
        }
        out.defaultWriteObject();
        out.writeInt(1);
        out.writeObject(this.ivSchedule);
        out.writeObject(this.timeZone.getID());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readObject", (Object[])new Object[0]);
        }
        in.defaultReadObject();
        int version = in.readInt();
        if (version != 1) {
            throw new IOException("invalid version: " + version);
        }
        this.ivSchedule = (ScheduleExpression)in.readObject();
        String timeZoneID = (String)in.readObject();
        this.timeZone = TimeZone.getTimeZone(timeZoneID);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("timezone: " + timeZoneID), (Object[])new Object[0]);
        }
        ScheduleExpressionParser.parse(this);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readObject");
        }
    }

    static class VariableDayOfMonthRange {
        private int ivEncodedMin;
        private int ivEncodedMax;

        VariableDayOfMonthRange(int encodedMin, int encodedMax) {
            this.ivEncodedMin = encodedMin;
            this.ivEncodedMax = encodedMax;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append('[');
            VariableDayOfMonthRange.toString(out, this.ivEncodedMin);
            out.append(", ");
            VariableDayOfMonthRange.toString(out, this.ivEncodedMax);
            out.append(']');
            return out.toString();
        }

        private static void toString(StringBuilder out, int value) {
            if (value < 32) {
                out.append(value);
            } else if (value == 32) {
                out.append("Last");
            } else if (value < 40) {
                out.append(32 - value);
            } else {
                int encoded = value - 40;
                int weekOfMonth = encoded / 7;
                int dayOfWeek = encoded % 7;
                out.append(ScheduleExpressionParser.WEEKS_OF_MONTH[weekOfMonth]).append(' ').append(ScheduleExpressionParser.DAYS_OF_WEEK[dayOfWeek]);
            }
        }

        public int getNextDay(int day, int lastDay, int dayOfWeek) {
            int maxDay;
            int minDay = VariableDayOfMonthRange.actualDayOfMonth(this.ivEncodedMin, day, lastDay, dayOfWeek);
            int result = minDay > (maxDay = VariableDayOfMonthRange.actualDayOfMonth(this.ivEncodedMax, day, lastDay, dayOfWeek)) ? 99 : (day >= minDay && day <= maxDay ? day : (day < minDay && minDay <= lastDay ? minDay : 99));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("variable range " + this.toString() + " = [" + minDay + ", " + maxDay + "], last = " + lastDay + ", result = " + result), (Object[])new Object[0]);
            }
            return result;
        }

        private static int actualDayOfMonth(int encodedValue, int day, int lastDay, int dayOfWeek) {
            if (encodedValue < 32) {
                return encodedValue - 1;
            }
            if (encodedValue < 40) {
                return lastDay - (encodedValue - 32);
            }
            int encoded = encodedValue - 40;
            int targetWeekOfMonth = encoded / 7;
            int targetDayOfWeek = encoded % 7;
            if (targetWeekOfMonth == 5) {
                int lastDayOfWeek = (dayOfWeek + lastDay - day) % 7;
                if (targetDayOfWeek <= lastDayOfWeek) {
                    return lastDay - (lastDayOfWeek - targetDayOfWeek);
                }
                return lastDay + (targetDayOfWeek - lastDayOfWeek) - 7;
            }
            int firstDayForTargetDayOfWeek = (day + targetDayOfWeek - dayOfWeek + 7) % 7;
            return targetWeekOfMonth * 7 + firstDayForTargetDayOfWeek;
        }
    }
}

