/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ejbcontainer.osgi.internal.SerializedEJBRef;
import com.ibm.ws.ejbcontainer.util.EJBSerializer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.serialization.DeserializationObjectResolver;
import com.ibm.ws.serialization.SerializationObjectReplacer;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceOptions(traceGroups={"EJBContainer"}, traceGroup="", messageBundle="com.ibm.ejs.container.container", traceExceptionThrow=false, traceExceptionHandling=false)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={SerializationObjectReplacer.class, DeserializationObjectResolver.class})
public class SerializedEJBRefHandler
implements SerializationObjectReplacer,
DeserializationObjectResolver {
    private static final TraceComponent tc = Tr.register(SerializedEJBRefHandler.class);
    private static final EJBSerializer serializer = EJBSerializer.instance();
    static final long serialVersionUID = 8433749048926378912L;

    @Reference(service=LibertyProcess.class, target="(wlp.process.type=server)")
    protected void setLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    protected void unsetLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    /*
     * WARNING - void declaration
     */
    public Object resolveObject(@Sensitive Object object) {
        if (object instanceof SerializedEJBRef) {
            try {
                SerializedEJBRef ejbRef = (SerializedEJBRef)object;
                return serializer.deserialize(ejbRef.getSerializedEJB());
            }
            catch (Exception ejbRef) {
                void e;
                Object[] objectArray = new Object[1];
                objectArray[0] = "<sensitive java.lang.Object>";
                FFDCFilter.processException((Throwable)ejbRef, (String)"com.ibm.ws.ejbcontainer.osgi.internal.SerializedEJBRefHandler", (String)"55", (Object)this, (Object[])objectArray);
                FFDCFilter.processException((Throwable)e, (String)(SerializedEJBRefHandler.class.getName() + ".resolveObject"), (String)"191", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_PASSIVATE_EJB_CNTR0005W", (Object[])new Object[]{object, this, e});
            }
        }
        return null;
    }

    public Object replaceObject(@Sensitive Object object) {
        EJBSerializer.ObjectType objectType = serializer.getObjectType(object);
        if (objectType != EJBSerializer.ObjectType.NOT_AN_EJB && objectType != EJBSerializer.ObjectType.CORBA_STUB && objectType != EJBSerializer.ObjectType.EJB_HOME && objectType != EJBSerializer.ObjectType.EJB_OBJECT) {
            return new SerializedEJBRef(serializer.serialize(object));
        }
        return null;
    }
}

