/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBWrapperType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public final class DeploymentUtil {
    private static final TraceComponent tc = Tr.register(DeploymentUtil.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    public static final String declaredUncheckedAreSystemExceptions = "com.ibm.websphere.ejbcontainer.declaredUncheckedAreSystemExceptions";
    public static final boolean DeclaredUncheckedAreSystemExceptions = System.getProperty("com.ibm.websphere.ejbcontainer.declaredUncheckedAreSystemExceptions", "true").equalsIgnoreCase("true");
    public static final String declaredRemoteAreApplicationExceptions = "com.ibm.websphere.ejbcontainer.declaredRemoteAreApplicationExceptions";
    public static final boolean DeclaredRemoteAreApplicationExceptions = Boolean.getBoolean("com.ibm.websphere.ejbcontainer.declaredRemoteAreApplicationExceptions");

    public static String methodKey(Method m) {
        StringBuffer result = new StringBuffer(m.getName());
        result.append("(");
        Class<?>[] argTypes = m.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            result.append(argTypes[i].getName());
            result.append(",");
        }
        result.append(")");
        return result.toString();
    }

    public static Method[] getAllMethods(Class<?> intf) {
        Method[] allMethods = intf.getMethods();
        ArrayList<Method> result = new ArrayList<Method>(allMethods.length);
        HashMap<String, Method> methodNameTable = new HashMap<String, Method>();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (Modifier.isStatic(m.getModifiers())) continue;
            String mKey = DeploymentUtil.methodKey(m);
            String interfaceName = m.getDeclaringClass().getName();
            if ((interfaceName.equals("javax.ejb.EJBObject") || interfaceName.equals("javax.ejb.EJBLocalObject")) && !m.getName().equals("remove")) continue;
            Method synonym = (Method)methodNameTable.get(mKey);
            if (synonym == null) {
                methodNameTable.put(mKey, m);
                result.add(m);
                continue;
            }
            Class<?> mClass = m.getDeclaringClass();
            Class<?> sClass = synonym.getDeclaringClass();
            if (!sClass.isAssignableFrom(mClass)) continue;
            methodNameTable.put(mKey, m);
            result.set(result.indexOf(synonym), m);
        }
        return DeploymentUtil.sortMethods(result);
    }

    public static Method[] getMethods(Class<?> intf) {
        return DeploymentUtil.getMethods(intf, null);
    }

    public static Method[] getMethods(Class<?> componentInterface, Class<?>[] businessInterfaces) {
        int i;
        int numMethods = 0;
        Method[] methods = null;
        int numBusinessInterfaces = 0;
        HashMap<String, Method> methodNameTable = new HashMap<String, Method>();
        if (componentInterface != null) {
            methods = componentInterface.getMethods();
            numMethods = methods.length;
        }
        if (businessInterfaces != null) {
            numBusinessInterfaces = businessInterfaces.length;
        }
        ArrayList<Method> result = new ArrayList<Method>(numMethods + numBusinessInterfaces * 10);
        for (i = 0; i < numMethods; ++i) {
            Method m = methods[i];
            if (Modifier.isStatic(m.getModifiers())) continue;
            String mKey = DeploymentUtil.methodKey(m);
            String interfaceName = m.getDeclaringClass().getName();
            if (interfaceName.equals("javax.ejb.EJBObject") || interfaceName.equals("javax.ejb.EJBLocalObject")) continue;
            Method synonym = (Method)methodNameTable.get(mKey);
            if (synonym == null) {
                methodNameTable.put(mKey, m);
                result.add(m);
                continue;
            }
            Class<?> mClass = m.getDeclaringClass();
            Class<?> sClass = synonym.getDeclaringClass();
            if (!sClass.isAssignableFrom(mClass)) continue;
            methodNameTable.put(mKey, m);
            result.set(result.indexOf(synonym), m);
        }
        for (i = 0; i < numBusinessInterfaces; ++i) {
            methods = businessInterfaces[i].getMethods();
            numMethods = methods.length;
            result.ensureCapacity(result.size() + numMethods);
            for (int j = 0; j < numMethods; ++j) {
                String mKey;
                Class<?> declaring;
                Method m = methods[j];
                if (Modifier.isStatic(m.getModifiers()) || m.isBridge() || (declaring = m.getDeclaringClass()) == Object.class || (mKey = DeploymentUtil.methodKey(m)).equals("equals(java.lang.Object,)") && m.getReturnType() == Boolean.TYPE || mKey.equals("hashCode()") && m.getReturnType() == Integer.TYPE) continue;
                Method synonym = (Method)methodNameTable.get(mKey);
                if (synonym == null) {
                    methodNameTable.put(mKey, m);
                    result.add(m);
                    continue;
                }
                Class<?> mClass = m.getDeclaringClass();
                Class<?> sClass = synonym.getDeclaringClass();
                if (!sClass.isAssignableFrom(mClass)) continue;
                methodNameTable.put(mKey, m);
                result.set(result.indexOf(synonym), m);
            }
        }
        return DeploymentUtil.sortMethods(result);
    }

    private static Method[] sortMethods(ArrayList<Method> methods) {
        int numMethods = methods.size();
        Method[] result = new Method[numMethods];
        for (int i = 0; i < numMethods; ++i) {
            Method currMethod = methods.get(i);
            String currMethodName = currMethod.toString();
            for (int insertIndex = 0; insertIndex < i && currMethodName.compareTo(result[insertIndex].toString()) > 0; ++insertIndex) {
            }
            for (int j = insertIndex; j <= i; ++j) {
                Method tmpMethod = result[j];
                result[j] = currMethod;
                currMethod = tmpMethod;
            }
        }
        return result;
    }

    public static ArrayList<Method> getNonPublicMethods(final Class<?> ejbClass, final Method[] publicMethods) {
        return AccessController.doPrivileged(new PrivilegedAction<ArrayList<Method>>(){

            @Override
            public ArrayList<Method> run() {
                return DeploymentUtil.getNonPublicMethodsPrivileged(ejbClass, publicMethods);
            }
        });
    }

    private static ArrayList<Method> getNonPublicMethodsPrivileged(Class<?> ejbClass, Method[] publicMethods) {
        HashMap<String, ArrayList<Object>> methodMap = new HashMap<String, ArrayList<Object>>();
        for (Class<?> thisClass = ejbClass; thisClass != null && thisClass != Object.class; thisClass = thisClass.getSuperclass()) {
            Method[] thisMethods = thisClass.getDeclaredMethods();
            for (Method thisMethod : thisMethods) {
                int modifiers = thisMethod.getModifiers();
                if (Modifier.isStatic(modifiers) || thisMethod.isBridge() || Modifier.isPublic(modifiers)) continue;
                boolean found = false;
                String methodName = thisMethod.getName();
                ArrayList<Object> existingMethods = (ArrayList<Object>)methodMap.get(methodName);
                if (existingMethods == null) {
                    for (Method method : publicMethods) {
                        if (!DeploymentUtil.methodsMatch(thisMethod, method)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    existingMethods = new ArrayList<Object>();
                    existingMethods.add(thisMethod);
                    methodMap.put(methodName, existingMethods);
                    continue;
                }
                for (Method method : existingMethods) {
                    if (!DeploymentUtil.methodsMatch(thisMethod, method)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (Method method : publicMethods) {
                        if (!DeploymentUtil.methodsMatch(thisMethod, method)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                existingMethods.add(thisMethod);
            }
        }
        ArrayList<Method> entireMethodList = new ArrayList<Method>();
        for (ArrayList list : methodMap.values()) {
            entireMethodList.addAll(list);
        }
        return entireMethodList;
    }

    public static boolean methodsMatch(Method m1, Method m2) {
        return m1 == m2 || m1.getName().equals(m2.getName()) && Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes());
    }

    public static Class<?>[] getCheckedExceptions(Method method, boolean isRmiRemote, DeploymentTarget target) throws EJBConfigurationException {
        return DeploymentUtil.getCheckedExceptions(method, isRmiRemote, target, null);
    }

    public static Class<?>[] getCheckedExceptions(Method method, boolean isRmiRemote, DeploymentTarget target, EJBWrapperType wrapperType) throws EJBConfigurationException {
        return DeploymentUtil.getCheckedExceptions(method, isRmiRemote, target, wrapperType, DeclaredUncheckedAreSystemExceptions, DeclaredRemoteAreApplicationExceptions);
    }

    public static Class<?>[] getCheckedExceptions(Method method, boolean isRmiRemote, DeploymentTarget target, EJBWrapperType wrapperType, boolean declaredUncheckedAreSystemExceptions, boolean declaredRemoteAreApplicationExceptions) throws EJBConfigurationException {
        boolean throwsRemoteException = false;
        Class<?>[] exceptions = method.getExceptionTypes();
        int numExceptions = exceptions.length;
        ArrayList checkedExceptions = new ArrayList(numExceptions);
        for (Class<?> exception : exceptions) {
            int j;
            Class checkedEx;
            if (exception == RemoteException.class) {
                if (!isRmiRemote) {
                    Tr.warning((TraceComponent)tc, (String)"JIT_INVALID_THROW_REMOTE_CNTR5101W", (Object[])new Object[]{method.getName(), method.getDeclaringClass().getName()});
                }
                throwsRemoteException = true;
                continue;
            }
            if (RemoteException.class.isAssignableFrom(exception)) {
                if (target != DeploymentTarget.STUB && (!declaredRemoteAreApplicationExceptions || wrapperType != null && wrapperType != EJBWrapperType.BUSINESS_REMOTE && wrapperType != EJBWrapperType.BUSINESS_LOCAL)) {
                    String className = method.getDeclaringClass().getName();
                    Tr.error((TraceComponent)tc, (String)"JIT_INVALID_SUBCLASS_REMOTE_EX_CNTR5102E", (Object[])new Object[]{exception.getName(), method.getName(), className});
                    throw new EJBConfigurationException("Application exception " + exception.getName() + " defined on method " + method.getName() + " of interface " + className + " must not subclass java.rmi.RemoteException.");
                }
            } else if (RuntimeException.class.isAssignableFrom(exception) || Error.class.isAssignableFrom(exception)) {
                if (target != DeploymentTarget.STUB && (target != DeploymentTarget.WRAPPER || declaredUncheckedAreSystemExceptions)) continue;
            } else if (!Exception.class.isAssignableFrom(exception)) {
                String className = method.getDeclaringClass().getName();
                Tr.error((TraceComponent)tc, (String)"JIT_INVALID_NOT_EXCEPTION_SUBCLASS_CNTR5107E", (Object[])new Object[]{exception.getName(), method.getName(), className});
                throw new EJBConfigurationException("The " + exception.getName() + " application exception defined on the " + method.getName() + " method of the " + className + " class must be defined as a subclass of the java.lang.Exception class.");
            }
            if (target == DeploymentTarget.WRAPPER) {
                boolean add = true;
                Iterator iter = checkedExceptions.iterator();
                while (iter.hasNext()) {
                    checkedEx = (Class)iter.next();
                    if (exception.isAssignableFrom(checkedEx)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("getCheckedExceptions: ignoring " + checkedEx.getName() + ", subclass of " + exception.getName()), (Object[])new Object[0]);
                        }
                        iter.remove();
                        continue;
                    }
                    if (!checkedEx.isAssignableFrom(exception)) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getCheckedExceptions: ignoring " + exception.getName() + ", subclass of " + checkedEx.getName()), (Object[])new Object[0]);
                    }
                    add = false;
                    break;
                }
                if (!add) continue;
                checkedExceptions.add(exception);
                continue;
            }
            int numChecked = checkedExceptions.size();
            for (j = 0; j < numChecked && !(checkedEx = (Class)checkedExceptions.get(j)).isAssignableFrom(exception); ++j) {
            }
            checkedExceptions.add(j, exception);
        }
        if (isRmiRemote && !throwsRemoteException) {
            String className = method.getDeclaringClass().getName();
            Tr.error((TraceComponent)tc, (String)"JIT_MISSING_REMOTE_EX_CNTR5104E", (Object[])new Object[]{method.getName(), className});
            throw new EJBConfigurationException("Method " + method.getName() + " of interface " + className + " must throw java.rmi.RemoteException");
        }
        return checkedExceptions.toArray(new Class[checkedExceptions.size()]);
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Property: DeclaredUncheckedAreSystemExceptions = " + DeclaredUncheckedAreSystemExceptions), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Property: DeclaredRemoteAreApplicationExceptions = " + DeclaredRemoteAreApplicationExceptions), (Object[])new Object[0]);
        }
    }

    public static enum DeploymentTarget {
        STUB,
        TIE,
        WRAPPER;

    }
}

