/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.interceptors;

import com.ibm.ejs.util.dopriv.SetAccessiblePrivilegedAction;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.interceptor.InvocationContext;

public class InterceptorProxy {
    private static final String CLASS_NAME = InterceptorProxy.class.getName();
    private static final TraceComponent tc = Tr.register(InterceptorProxy.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final Object[] NO_ARGS = new Object[0];
    public final Method ivInterceptorMethod;
    final int ivInterceptorIndex;
    final boolean ivBeanInterceptor;
    final boolean ivRequiresInvocationContext;

    public InterceptorProxy(Method m, int interceptorIndex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"InterceptorProxy", (Object[])new Object[0]);
        }
        this.ivInterceptorIndex = interceptorIndex;
        this.ivInterceptorMethod = m;
        this.ivBeanInterceptor = interceptorIndex < 0;
        this.ivRequiresInvocationContext = m.getParameterTypes().length > 0;
        SetAccessiblePrivilegedAction priviledgedAction = new SetAccessiblePrivilegedAction();
        priviledgedAction.setParameters((AccessibleObject)m, true);
        try {
            AccessController.doPrivileged(priviledgedAction);
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".<init>"), (String)"178", (Object)this);
            SecurityException ex = (SecurityException)e.getException();
            throw ex;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)this.toString());
            }
        }
    }

    public final Object invokeInterceptor(Object bean, InvocationContext inv, Object[] interceptors) throws Exception {
        Object interceptorInstance;
        Object object = interceptorInstance = this.ivBeanInterceptor ? bean : interceptors[this.ivInterceptorIndex];
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("invoking " + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("interceptor instance = " + interceptorInstance), (Object[])new Object[0]);
        }
        if (this.ivRequiresInvocationContext) {
            Object[] args = new Object[]{inv};
            return this.ivInterceptorMethod.invoke(interceptorInstance, args);
        }
        return this.ivInterceptorMethod.invoke(interceptorInstance, NO_ARGS);
    }

    public String toString() {
        return "InterceptorProxy(" + this.ivInterceptorIndex + "): " + this.ivInterceptorMethod.toGenericString();
    }

    public String getMethodGenericString() {
        return this.ivInterceptorMethod.toGenericString();
    }
}

