/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.iiop;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jndi.iiop.UrlContextFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.spi.ObjectFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=ibm", "osgi.jndi.url.scheme=corbaname"})
public class CorbanameUrlContextFactory
extends UrlContextFactory
implements ObjectFactory,
ApplicationRecycleComponent {
    static final long serialVersionUID = -3749238375086282303L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CorbanameUrlContextFactory.class);
    }

    @TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class Escaper {
        static final TraceComponent tc = Tr.register(Escaper.class);
        private static final Pattern PERCENT_TRIPLET = Pattern.compile("%(?:[0-9a-f]{2}|[0-9A-F]{2})");
        private static final Pattern ALL_LEGAL_CHARS = Pattern.compile("[;/:?@&=+\\$,\\-_.!~*\u2019()0-9A-Za-z]*");
        private static final Pattern ILLEGAL_NAME = Pattern.compile("(?:[^/]\\./|\\.[^/]*\\.|[^/]\\.$)");
        private static final BitSet ESCAPE_NOT_NEEDED = new BitSet(256);
        static final long serialVersionUID = -4373547572080843371L;

        Escaper() {
        }

        public static String escapeCorbanameUrlIfNecessary(String url) {
            Matcher matcher;
            String methodName = "escapeCorbanameUrlIfNecessary(): ";
            if (url == null || !url.startsWith("corbaname:") || url.contains("\\")) {
                return url;
            }
            String[] twoParts = url.split("#", 2);
            if (twoParts.length < 2) {
                return url;
            }
            String stringifiedName = twoParts[1];
            if (stringifiedName.isEmpty()) {
                return url;
            }
            if (PERCENT_TRIPLET.matcher(stringifiedName).find()) {
                return url;
            }
            if (ALL_LEGAL_CHARS.matcher(stringifiedName).matches() && !(matcher = ILLEGAL_NAME.matcher(stringifiedName)).find()) {
                return url;
            }
            StringBuilder sn = new StringBuilder();
            for (String n : stringifiedName.split("/", -1)) {
                n = n.replaceAll("\\\\", "\\\\\\\\");
                n = n.replaceAll("\\.", "\\\\.");
                sn.append(n).append("/");
            }
            sn.setLength(sn.length() - 1);
            StringBuilder escaped = new StringBuilder(twoParts[0]).append("#");
            for (byte b : sn.toString().getBytes(Charset.forName("UTF-8"))) {
                if (ESCAPE_NOT_NEEDED.get(b)) {
                    escaped.append((char)b);
                    continue;
                }
                escaped.append(String.format("%%%02x", 0xFF & b));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("escapeCorbanameUrlIfNecessary(): escaped original url " + url + " to " + escaped), (Object[])new Object[0]);
            }
            return escaped.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            for (char c : ";/:?@&=+$,-_.!~*\u2019()".toCharArray()) {
                ESCAPE_NOT_NEEDED.set(c);
            }
            for (char c = '0'; c <= '\u00ff'; c = (char)(c + '\u0001')) {
                if (!Character.isAlphabetic(c) && !Character.isDigit(c)) continue;
                ESCAPE_NOT_NEEDED.set(c);
            }
        }
    }
}

