/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.crypto.ltpakeyutil.KeyEncryptor;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeyFileCreatorImpl;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LTPAKeyInfoManager {
    private static final TraceComponent tc = Tr.register(LTPAKeyInfoManager.class);
    private static final String SECRETKEY = "secretkey";
    private static final String PRIVATEKEY = "privatekey";
    private static final String PUBLICKEY = "publickey";
    private final List<String> importFileCache = new ArrayList<String>();
    private final Map<String, byte[]> keyCache = new Hashtable<String, byte[]>();
    private final Map<String, String> realmCache = new Hashtable<String, String>();
    static final long serialVersionUID = 4985268335767495062L;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Properties loadPropertiesFile(WsResource res) throws IOException {
        Properties props = new Properties();
        InputStream is = res.get();
        try {
            props.load(is);
            if (is == null) return props;
        }
        catch (IOException iOException) {
            try {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAKeyInfoManager", (String)"76", (Object)this, (Object[])new Object[]{res});
                if (!TraceComponent.isAnyTracingEnabled()) throw e;
                if (!tc.isEventEnabled()) throw e;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Error loading properties; " + e), (Object[])new Object[0]);
                throw e;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAKeyInfoManager", (String)"85", (Object)this, (Object[])new Object[]{res});
                }
                throw throwable;
            }
        }
        try {
            is.close();
            return props;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAKeyInfoManager", (String)"85", (Object)this, (Object[])new Object[]{res});
            return props;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void prepareLTPAKeyInfo(WsLocationAdmin locService, String keyImportFile, @Sensitive byte[] keyPassword) throws Exception {
        if (!this.importFileCache.contains(keyImportFile)) {
            byte[] publicKey;
            byte[] privateKey;
            byte[] secretKey;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Loading keyfile [" + keyImportFile + "]"), (Object[])new Object[0]);
            }
            Properties props = null;
            WsResource ltpaKeyFileResource = this.getLTPAKeyFileResource(locService, keyImportFile);
            if (ltpaKeyFileResource != null) {
                props = this.loadPropertiesFile(ltpaKeyFileResource);
            } else {
                long start = System.currentTimeMillis();
                Tr.info((TraceComponent)tc, (String)"LTPA_CREATE_KEYS_START", (Object[])new Object[0]);
                LTPAKeyFileCreatorImpl creator = new LTPAKeyFileCreatorImpl();
                props = creator.createLTPAKeysFile(locService, keyImportFile, keyPassword);
                Tr.audit((TraceComponent)tc, (String)"LTPA_CREATE_KEYS_COMPLETE", (Object[])new Object[]{TimestampUtils.getElapsedTime((long)start), keyImportFile});
            }
            String realm = props.getProperty("com.ibm.websphere.ltpa.Realm");
            String secretKeyStr = props.getProperty("com.ibm.websphere.ltpa.3DESKey");
            String privateKeyStr = props.getProperty("com.ibm.websphere.ltpa.PrivateKey");
            String publicKeyStr = props.getProperty("com.ibm.websphere.ltpa.PublicKey");
            try {
                String formattedMessage;
                KeyEncryptor encryptor = new KeyEncryptor(keyPassword);
                if (secretKeyStr == null || secretKeyStr.length() == 0) {
                    Tr.error((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.3DESKey"});
                    String formattedMessage2 = Tr.formatMessage((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.3DESKey"});
                    throw new IllegalArgumentException(formattedMessage2);
                }
                byte[] keyEncoded = Base64Coder.base64DecodeString((String)secretKeyStr);
                secretKey = encryptor.decrypt(keyEncoded);
                if (privateKeyStr == null || privateKeyStr.length() == 0) {
                    Tr.error((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.PrivateKey"});
                    formattedMessage = Tr.formatMessage((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.PrivateKey"});
                    throw new IllegalArgumentException(formattedMessage);
                }
                keyEncoded = Base64Coder.base64DecodeString((String)privateKeyStr);
                privateKey = encryptor.decrypt(keyEncoded);
                if (publicKeyStr == null || publicKeyStr.length() == 0) {
                    Tr.error((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.PublicKey"});
                    formattedMessage = Tr.formatMessage((TraceComponent)tc, (String)"LTPA_TOKEN_SERVICE_MISSING_KEY", (Object[])new Object[]{"com.ibm.websphere.ltpa.PublicKey"});
                    throw new IllegalArgumentException(formattedMessage);
                }
                publicKey = keyEncoded = Base64Coder.base64DecodeString((String)publicKeyStr);
            }
            catch (Exception encryptor) {
                void e;
                Object[] objectArray = new Object[3];
                objectArray[0] = locService;
                objectArray[1] = keyImportFile;
                objectArray[2] = "<sensitive byte[]>";
                FFDCFilter.processException((Throwable)encryptor, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAKeyInfoManager", (String)"157", (Object)this, (Object[])objectArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Error loading key; " + e), (Object[])new Object[0]);
                }
                throw e;
            }
            if (secretKey != null) {
                this.keyCache.put(keyImportFile + SECRETKEY, secretKey);
            }
            if (privateKey != null) {
                this.keyCache.put(keyImportFile + PRIVATEKEY, privateKey);
            }
            if (publicKey != null) {
                this.keyCache.put(keyImportFile + PUBLICKEY, publicKey);
            }
            if (realm != null) {
                this.realmCache.put(keyImportFile, realm);
            }
            this.importFileCache.add(keyImportFile);
        }
    }

    final WsResource getLTPAKeyFileResource(WsLocationAdmin locService, String ltpaKeyFile) {
        WsResource ltpaFile = locService.resolveResource(ltpaKeyFile);
        if (ltpaFile != null && ltpaFile.exists()) {
            return ltpaFile;
        }
        return null;
    }

    @Sensitive
    public final byte[] getSecretKey(String keyImportFile) {
        return this.keyCache.get(keyImportFile + SECRETKEY);
    }

    @Sensitive
    public final byte[] getPrivateKey(String keyImportFile) {
        return this.keyCache.get(keyImportFile + PRIVATEKEY);
    }

    public final byte[] getPublicKey(String keyImportFile) {
        return this.keyCache.get(keyImportFile + PUBLICKEY);
    }

    final String getRealm(String keyImportFile) {
        return this.realmCache.get(keyImportFile);
    }
}

