/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.Util;
import com.ibm.ws.beanvalidation.ValidatorFactoryAccessor;
import com.ibm.ws.beanvalidation.service.BeanValidation;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;

public abstract class AbstractBeanValidation
implements BeanValidation {
    private static final TraceComponent tc = Tr.register(AbstractBeanValidation.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS(AbstractBeanValidation.class, (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
    private static volatile AbstractBeanValidation svInstance = null;
    protected Map<ModuleMetaData, URL> moduleValidationXMLs = new HashMap<ModuleMetaData, URL>();

    public static AbstractBeanValidation instance() {
        return svInstance;
    }

    static void setInstance(AbstractBeanValidation instance) {
        if (svInstance != null && instance != null) {
            throw new IllegalStateException("instance already set");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInstance : " + Util.identity((Object)instance)));
        }
        svInstance = instance;
    }

    @Override
    public ValidatorFactory getValidatorFactory(ComponentMetaData cmd) {
        if (cmd == null) {
            throw new ValidationException(nls.getString("JNDI_NON_JEE_THREAD_CWNBV0006E"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getValidatorFactory : " + cmd));
        }
        ModuleMetaData mmd = cmd.getModuleMetaData();
        return this.getValidatorFactory(mmd);
    }

    @Override
    public ValidatorFactory getValidatorFactoryOrDefault(ComponentMetaData cmd) {
        if (cmd == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getValidatorFactoryOrDefault : (passed null cmd)" + null));
            }
            return ValidatorFactoryAccessor.getValidatorFactory();
        }
        return this.getValidatorFactory(cmd);
    }

    static ValidatorFactory getValidatorFactory() {
        ValidatorFactory validatorFactory;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getValidatorFactory");
        }
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (svInstance != null) {
            validatorFactory = svInstance.getValidatorFactory(cmd);
        } else if (cmd != null && cmd.getModuleMetaData() == null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No BeanValidation service; Client Container : getting default ValidatorFactory");
            }
            validatorFactory = AccessController.doPrivileged(new PrivilegedAction<ValidatorFactory>(){

                @Override
                public ValidatorFactory run() {
                    return Validation.buildDefaultValidatorFactory();
                }
            });
        } else {
            throw new IllegalStateException("BeanValidation service is not available.");
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getValidatorFactory: " + Util.identity((Object)validatorFactory)));
        }
        return validatorFactory;
    }

    public URL getValidationXmlUrl(ModuleMetaData mmd) {
        return this.moduleValidationXMLs.get(mmd);
    }

    public abstract ClassLoader configureBvalClassloader(ClassLoader var1);

    public abstract void releaseLoader(ClassLoader var1);

    @Override
    public abstract void registerValidatorFactory(ModuleMetaData var1, ClassLoader var2, ValidatorFactory var3);

    public abstract ConstraintValidatorFactory getConstraintValidatorFactory(Configuration<?> var1);
}

