/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.security.ltpa;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.client.component.JaxRsAppSecurity;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.servlet.http.Cookie;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.spec.ClientRequestContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyJaxRsClientLtpaInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsClientLtpaInterceptor.class);
    static final long serialVersionUID = -7506610659498281655L;

    public LibertyJaxRsClientLtpaInterceptor() {
        super("pre-logical");
    }

    public void handleMessage(Message message) throws Fault {
        Object ltpaHandler = message.get((Object)"com.ibm.ws.jaxrs.client.ltpa.handler");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Please check if customer is using client configuration property: com.ibm.ws.jaxrs.client.ltpa.handler and should be true", (Object[])new Object[0]);
        }
        if (ltpaHandler != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The client configuration property com.ibm.ws.jaxrs.client.ltpa.handler value is " + ltpaHandler), (Object[])new Object[0]);
            }
            String handler = ((String)ltpaHandler).toLowerCase();
            this.configClientLtpaHandler(message, handler);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configClientLtpaHandler(Message message, String ltpaHander) {
        if (ltpaHander.equals("true")) {
            String address;
            ClientRequestContextImpl reqContext = new ClientRequestContextImpl(message, false);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Entering LtpaAuthSecurityHandler.handle", (Object[])new Object[0]);
            }
            if ((address = (String)message.get((Object)Message.ENDPOINT_ADDRESS)).startsWith("https") && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"user is using SSL connection", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"About to get a LTPA authentication token", (Object[])new Object[0]);
            }
            try {
                Cookie ssoCookie = JaxRsAppSecurity.getSSOCookieFromSSOToken();
                if (ssoCookie != null && ssoCookie.getValue() != null && !ssoCookie.getValue().isEmpty() && ssoCookie.getName() != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Retrieved a LTPA authentication token. About to set a request cookie: " + ssoCookie.getName() + "=" + ssoCookie.getValue()), (Object[])new Object[0]);
                    }
                    reqContext.getHeaders().putSingle((Object)"Cookie", (Object)(ssoCookie.getName() + "=" + ssoCookie.getValue()));
                    MultivaluedMap headers = (MultivaluedMap)message.get((Object)Message.PROTOCOL_HEADERS);
                    headers.putSingle((Object)"Cookie", (Object)(ssoCookie.getName() + "=" + ssoCookie.getValue()));
                    message.put((Object)Message.PROTOCOL_HEADERS, (Object)headers);
                    return;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
                Tr.debug((TraceComponent)tc, (String)"Cannot find a ltpa authentication token off of the thread, you may need enable feature appSecurity-2.0 or ssl-1.0", (Object[])new Object[0]);
                return;
            }
            catch (Exception ssoCookie) {
                void e;
                FFDCFilter.processException((Throwable)ssoCookie, (String)"com.ibm.ws.jaxrs20.client.security.ltpa.LibertyJaxRsClientLtpaInterceptor", (String)"104", (Object)((Object)this), (Object[])new Object[]{message, ltpaHander});
                throw new ProcessingException((Throwable)e);
            }
        } else {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"No client ltpa handler configuration, skip", (Object[])new Object[0]);
        }
    }
}

