/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.client.LibertyServiceImpl;
import com.ibm.ws.jaxws.metadata.JaxWsClientMetaData;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.jaxws.security.JaxWsSecurityConfigurationService;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.ServiceDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws22.spi.ProviderImpl;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyProviderImpl
extends ProviderImpl {
    private static final TraceComponent tc = Tr.register(LibertyProviderImpl.class);
    private static final ThreadLocal<List<WebServiceFeature>> wsFeatures = new ThreadLocal();
    private static final ThreadLocal<WebServiceRefInfo> wsRefInfo = new ThreadLocal();
    private static final AtomicReference<AtomicServiceReference<JaxWsSecurityConfigurationService>> securityConfigSR = new AtomicReference();
    static final long serialVersionUID = 5918876997604011290L;

    public ServiceDelegate createServiceDelegate(URL url, QName qname, Class cls) {
        JaxWsSecurityConfigurationService securityConfigService;
        LibertyApplicationBus bus = null;
        JaxWsClientMetaData clientMetaData = JaxWsMetaDataManager.getJaxWsClientMetaData();
        if (clientMetaData != null) {
            bus = clientMetaData.getClientBus();
        }
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No client  bus is found, the thread context default bus " + bus.getId() + " is used"), (Object[])new Object[0]);
            }
        }
        WebServiceRefInfo wsrInfo = wsRefInfo.get();
        List<WebServiceFeature> serviceFeatures = wsFeatures.get();
        AtomicServiceReference<JaxWsSecurityConfigurationService> secConfigSR = securityConfigSR.get();
        JaxWsSecurityConfigurationService jaxWsSecurityConfigurationService = securityConfigService = secConfigSR == null ? null : (JaxWsSecurityConfigurationService)secConfigSR.getService();
        if (serviceFeatures != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Thread context features are configured with " + serviceFeatures), (Object[])new Object[0]);
            }
            return new LibertyServiceImpl(securityConfigService, wsrInfo, (Bus)bus, url, qname, cls, serviceFeatures.toArray(new WebServiceFeature[serviceFeatures.size()]));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Thread context features are not set", (Object[])new Object[0]);
        }
        return new LibertyServiceImpl(securityConfigService, wsrInfo, (Bus)bus, url, qname, cls, new WebServiceFeature[0]);
    }

    public static void setWebServiceFeatures(List<WebServiceFeature> features) {
        wsFeatures.set(features);
    }

    public static List<WebServiceFeature> getWebServiceFeatures() {
        return wsFeatures.get();
    }

    public static void clearWebServiceFeatures() {
        wsFeatures.remove();
    }

    public static void setWebServiceRefInfo(WebServiceRefInfo wsrInfo) {
        wsRefInfo.set(wsrInfo);
    }

    public static void clearWebServiceRefInfo() {
        wsRefInfo.remove();
    }

    public static WebServiceRefInfo getWebServiceRefInfo() {
        return wsRefInfo.get();
    }

    public static void setSecurityConfigService(AtomicServiceReference<JaxWsSecurityConfigurationService> serviceRefer) {
        securityConfigSR.set(serviceRefer);
    }
}

