/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.BundleStartLevel;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BundleStateIntrospection
implements Introspector {
    BundleContext context;
    static final long serialVersionUID = 5998827340898048177L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(BundleContext context) {
        this.context = context.getBundle("System Bundle").getBundleContext();
    }

    public String getIntrospectorName() {
        return "BundleStateIntrospection";
    }

    public String getIntrospectorDescription() {
        return "Introspect all bundles' state.";
    }

    public void introspect(PrintWriter out) {
        Bundle[] bundles = this.context.getBundles();
        out.println("  Id   [BundleState] [StartLevel] SymbolicName (Version)");
        for (Bundle bundle : bundles) {
            out.printf("[%1$4d] [%2$s] [%3$4d] %4$s (%5$s)%n", bundle.getBundleId(), BundleStateIntrospection.getBundleState(bundle), this.getBundleStartLevel(bundle), bundle.getSymbolicName(), bundle.getVersion());
        }
    }

    private int getBundleStartLevel(Bundle b) {
        BundleStartLevel bsl = (BundleStartLevel)b.adapt(BundleStartLevel.class);
        if (bsl == null) {
            return 0;
        }
        return bsl.getStartLevel();
    }

    private static String getBundleState(Bundle bundle) {
        int state = bundle.getState();
        switch (state) {
            case 1: {
                return "Uninstalled";
            }
            case 2: {
                return "Installed  ";
            }
            case 4: {
                return "Resolved   ";
            }
            case 16: {
                return "Stopping   ";
            }
            case 8: {
                return "Starting   ";
            }
            case 32: {
                return "Active     ";
            }
        }
        return "Unknown    ";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BundleStateIntrospection.class);
    }
}

