/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.appbnd;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.javaee.dd.app.Application;
import com.ibm.ws.javaee.dd.appbnd.ApplicationBnd;
import com.ibm.ws.javaee.dd.appbnd.Profile;
import com.ibm.ws.javaee.dd.appbnd.SecurityRole;
import com.ibm.ws.javaee.dd.commonbnd.JASPIRef;
import com.ibm.ws.javaee.ddmodel.CrossComponentReferenceType;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.StringType;
import com.ibm.ws.javaee.ddmodel.appbnd.AuthorizationTableXMIType;
import com.ibm.ws.javaee.ddmodel.appbnd.GroupType;
import com.ibm.ws.javaee.ddmodel.appbnd.ProfileType;
import com.ibm.ws.javaee.ddmodel.appbnd.RunAsMapXMIType;
import com.ibm.ws.javaee.ddmodel.appbnd.SecurityRoleType;
import com.ibm.ws.javaee.ddmodel.appbnd.SpecialSubjectType;
import com.ibm.ws.javaee.ddmodel.appbnd.UserType;
import com.ibm.ws.javaee.ddmodel.commonbnd.JASPIRefType;
import com.ibm.ws.javaee.ddmodel.commonbnd.RefBindingsGroupType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ApplicationBndType
extends RefBindingsGroupType
implements ApplicationBnd,
DDParser.RootParsable {
    private final String deploymentDescriptorPath;
    private DDParser.ComponentIDMap idMap;
    private CrossComponentReferenceType xmiRef;
    StringType version;
    DDParser.ParsableListImplements<SecurityRoleType, SecurityRole> security_role;
    DDParser.ParsableListImplements<ProfileType, Profile> profile;
    JASPIRefType jaspi_ref;
    StringType appName;
    AuthorizationTableXMIType authorizationTable;
    RunAsMapXMIType runAsMap;
    static final long serialVersionUID = 931207310417332102L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ApplicationBndType(String ddPath) {
        this(ddPath, false);
    }

    public ApplicationBndType(String ddPath, boolean xmi) {
        super(xmi);
        this.deploymentDescriptorPath = ddPath;
    }

    public String getVersion() {
        return this.xmi ? "XMI" : (this.version != null ? this.version.getValue() : null);
    }

    public List<SecurityRole> getSecurityRoles() {
        if (this.security_role != null) {
            return this.security_role.getList();
        }
        return Collections.emptyList();
    }

    public List<Profile> getProfiles() {
        if (this.profile != null) {
            return this.profile.getList();
        }
        return Collections.emptyList();
    }

    public JASPIRef getJASPIRef() {
        return this.jaspi_ref;
    }

    public String getDeploymentDescriptorPath() {
        return this.deploymentDescriptorPath;
    }

    public Object getComponentForId(String id) {
        return this.idMap.getComponentForId(id);
    }

    public String getIdForComponent(Object ddComponent) {
        return this.idMap.getIdForComponent(ddComponent);
    }

    @Override
    public void finish(DDParser parser) throws DDParser.ParseException {
        super.finish(parser);
        this.idMap = parser.idMap;
        if (this.xmi) {
            SecurityRoleType role;
            HashMap<String, SecurityRoleType> roleMap = new HashMap<String, SecurityRoleType>();
            if (this.authorizationTable != null && this.authorizationTable.authorizations != null) {
                for (AuthorizationTableXMIType.AuthorizationXMIType auth : this.authorizationTable.authorizations) {
                    role = this.getSecurityRole(auth.roleName, roleMap);
                    if (auth.users != null) {
                        for (UserType userType : auth.users) {
                            role.addUser(userType);
                        }
                    }
                    if (auth.groups != null) {
                        for (GroupType groupType : auth.groups) {
                            role.addGroup(groupType);
                        }
                    }
                    if (auth.specialSubjects == null) continue;
                    for (SpecialSubjectType specialSubjectType : auth.specialSubjects) {
                        role.addSpecialSubject(specialSubjectType);
                    }
                }
            }
            if (this.runAsMap != null && this.runAsMap.runAsBindings != null) {
                for (RunAsMapXMIType.RunAsBindingXMIType runAs : this.runAsMap.runAsBindings) {
                    role = this.getSecurityRole(runAs.securityRoleName, roleMap);
                    role.run_as = runAs.authData;
                }
            }
        }
    }

    @Override
    public boolean isIdAllowed() {
        return true;
    }

    private SecurityRoleType getSecurityRole(StringType name, Map<String, SecurityRoleType> roleMap) {
        String nameValue = name == null ? null : name.getValue();
        SecurityRoleType role = roleMap.get(nameValue);
        if (role == null) {
            role = new SecurityRoleType();
            role.name = name;
            roleMap.put(nameValue, role);
            if (this.security_role == null) {
                this.security_role = new DDParser.ParsableListImplements();
            }
            this.security_role.add(role);
        }
        return role;
    }

    @Override
    public boolean handleAttribute(DDParser parser, String nsURI, String localName, int index) throws DDParser.ParseException {
        if (nsURI == null) {
            if (!this.xmi && "version".equals(localName)) {
                this.version = parser.parseStringAttributeValue(index);
                return true;
            }
            if (this.xmi && "appName".equals(localName)) {
                this.appName = parser.parseStringAttributeValue(index);
                return true;
            }
        }
        if (this.xmi && "http://www.omg.org/XMI".equals(nsURI) && "version".equals(localName)) {
            return true;
        }
        return super.handleAttribute(parser, nsURI, localName, index);
    }

    @Override
    public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
        if (this.xmi && "application".equals(localName)) {
            this.xmiRef = new CrossComponentReferenceType("application", Application.class);
            parser.parse(this.xmiRef);
            return true;
        }
        if (!this.xmi && "security-role".equals(localName)) {
            SecurityRoleType security_role = new SecurityRoleType();
            parser.parse(security_role);
            this.addSecurityRole(security_role);
            return true;
        }
        if (!this.xmi && "profile".equals(localName)) {
            ProfileType profile = new ProfileType();
            parser.parse(profile);
            this.addProfile(profile);
            return true;
        }
        if (!this.xmi && "jaspi-ref".equals(localName)) {
            JASPIRefType jaspi_ref = new JASPIRefType();
            parser.parse(jaspi_ref);
            this.jaspi_ref = jaspi_ref;
            return true;
        }
        if (this.xmi && "authorizationTable".equals(localName)) {
            this.authorizationTable = new AuthorizationTableXMIType();
            parser.parse(this.authorizationTable);
            return true;
        }
        if (this.xmi && "runAsMap".equals(localName)) {
            this.runAsMap = new RunAsMapXMIType();
            parser.parse(this.runAsMap);
            return true;
        }
        return !this.xmi && super.handleChild(parser, localName);
    }

    void addSecurityRole(SecurityRoleType security_role) {
        if (this.security_role == null) {
            this.security_role = new DDParser.ParsableListImplements();
        }
        this.security_role.add(security_role);
    }

    void addProfile(ProfileType profile) {
        if (this.profile == null) {
            this.profile = new DDParser.ParsableListImplements();
        }
        this.profile.add(profile);
    }

    @Override
    public void describe(DDParser.Diagnostics diag) {
        diag.describeIfSet("application", this.xmiRef);
        diag.describeIfSet("version", this.version);
        diag.describeIfSet("appName", this.appName);
        diag.describeIfSet("security-role", this.security_role);
        diag.describeIfSet("profile", this.profile);
        diag.describeIfSet("jaspi-ref", this.jaspi_ref);
    }

    @Override
    public void describe(StringBuilder sb) {
        DDParser.Diagnostics diag = new DDParser.Diagnostics(this.idMap, sb);
        diag.describe(this.toTracingSafeString(), this);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ApplicationBndType.class);
    }
}

