/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.AttrList;
import com.ibm.xml.xlxp2.scan.util.NSDeclList;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.PrintStream;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XMLTracer {
    private PrintStream fPrintStream;
    private int fIndentDepth;

    public XMLTracer(PrintStream printStream) {
        this.fPrintStream = printStream;
    }

    public void traceStartDocument(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        this.printMethodName("startDocument");
        this.printParameter("version", xMLString);
        this.printParameter("encName", xMLString2);
        this.printParameter("standalone", xMLString3);
        this.finishEmptyElementTag();
    }

    public void traceEndDocument() {
        this.printMethod("endDocument");
    }

    protected void traceNSDecls(NSDeclList nSDeclList) {
        int n = nSDeclList.nsDeclCount();
        if (n > 0) {
            this.printMethodName("nsDecls");
            this.printParameter("count", n);
            this.finishStartTagEnd(true);
            for (int i = 0; i < n; ++i) {
                this.printMethodName("nsDecl");
                this.printParameter("rawName", nSDeclList.nsDeclQName(i));
                this.printParameter("prefix", nSDeclList.nsDeclPrefix(i));
                this.finishStartTagEnd(false);
                this.printValue(nSDeclList.nsDeclURI(i));
                this.printEndTag("nsDecl", false);
            }
            this.printEndTag("nsDecls", true);
        }
    }

    protected void traceAttrs(AttrList attrList) {
        int n = attrList.attributeCount();
        if (n > 0) {
            this.printMethodName("attributes");
            this.printParameter("count", n);
            this.finishStartTagEnd(true);
            for (int i = 0; i < n; ++i) {
                String string = attrList.attributeType(i);
                if (string == "") {
                    string = "CDATA";
                }
                this.printMethodName("attribute");
                this.printParameter("rawName", attrList.attributeName((int)i).rawName);
                this.printParameter("type", string);
                this.finishStartTagEnd(true);
                QName qName = attrList.attributeName(i);
                String string2 = qName.prefix;
                String string3 = qName.nsURI;
                String string4 = qName.localName;
                this.printQName(string2, string3, string4);
                this.printMethodName("value");
                this.finishStartTagEnd(false);
                this.printValue(attrList.attributeValue(i).toString());
                this.printEndTag("value", false);
                this.printEndTag("attribute", true);
            }
            this.printEndTag("attributes", true);
        }
    }

    public void traceLeafElement(QName qName, NSDeclList nSDeclList, AttrList attrList, XMLString xMLString) {
        this.printMethodName("leafElement");
        this.printParameter("rawName", qName.rawName);
        this.finishStartTagEnd(true);
        this.printQName(qName.prefix, qName.nsURI, qName.localName);
        this.traceNSDecls(nSDeclList);
        this.traceAttrs(attrList);
        this.printMethodName("elementValue");
        if (xMLString != null) {
            this.finishStartTagEnd(false);
            this.printParameter("content", xMLString);
            this.printEndTag("elementValue", false);
        } else {
            this.printParameter("empty", "true");
            this.finishEmptyElementTag();
        }
        this.printEndTag("leafElement", true);
    }

    public void traceStartElement(QName qName, NSDeclList nSDeclList, AttrList attrList) {
        this.printMethodName("startElement");
        this.printParameter("rawName", qName.rawName);
        this.finishStartTagEnd(true);
        this.printQName(qName.prefix, qName.nsURI, qName.localName);
        this.traceNSDecls(nSDeclList);
        this.traceAttrs(attrList);
        this.printEndTag("startElement", true);
    }

    public void traceEndElement(QName qName, NSDeclList nSDeclList) {
        this.printMethodName("endElement");
        this.printParameter("rawName", qName.rawName);
        this.finishStartTagEnd(true);
        this.printQName(qName.prefix, qName.nsURI, qName.localName);
        this.traceNSDecls(nSDeclList);
        this.printEndTag("endElement", true);
    }

    public void traceCharacters(XMLString xMLString) {
        this.printMethodName("characters");
        this.finishStartTagEnd(false);
        this.printValue(xMLString.toString());
        this.printEndTag("characters", false);
    }

    public void traceCDATASection(XMLString xMLString) {
        this.printMethodName("CDATASection");
        this.finishStartTagEnd(false);
        this.printValue(xMLString.toString());
        this.printEndTag("CDATASection", false);
    }

    public void traceWhitespace(XMLString xMLString) {
        this.printMethodName("whitespace");
        this.finishStartTagEnd(false);
        this.printValue(xMLString.toString());
        this.printEndTag("whitespace", false);
    }

    public void traceCharacter(int n) {
        this.printMethodName("character");
        this.printParameter("value", Integer.toString(n, 10));
        this.printParameter("hexValue", Integer.toString(n, 16));
        this.finishEmptyElementTag();
    }

    public void tracePredefinedEntity(XMLString xMLString, int n) {
        this.printMethodName("predefinedEntity");
        this.printParameter("name", xMLString.toString());
        this.printParameter("value", Integer.toString(n, 10));
        this.printParameter("hexValue", Integer.toString(n, 16));
        this.finishEmptyElementTag();
    }

    public void traceProcessingInstruction(XMLString xMLString, XMLString xMLString2) {
        this.printMethodName("processingInstruction");
        this.printParameter("target", xMLString.toString());
        this.finishStartTagEnd(false);
        this.printValue(xMLString2.toString());
        this.printEndTag("processingInstruction", false);
    }

    public void traceComment(XMLString xMLString) {
        this.printMethodName("comment");
        this.finishStartTagEnd(false);
        this.printValue(xMLString.toString());
        this.printEndTag("comment", false);
    }

    public void traceDoctype(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, boolean bl) {
        this.printMethodName("doctype");
        this.printParameter("rootElementType", xMLString.toString());
        this.printParameter("publicID", xMLString2.toString());
        this.printParameter("systemID", xMLString3.toString());
        this.printParameter("internalSubset", String.valueOf(bl));
        this.finishEmptyElementTag();
    }

    public void traceStartEntity(XMLString xMLString) {
        this.printMethodName("startEntity");
        this.printParameter("name", xMLString.toString());
        this.finishEmptyElementTag();
    }

    public void traceEndEntity(XMLString xMLString) {
        this.printMethodName("endEntity");
        this.printParameter("name", xMLString.toString());
        this.finishEmptyElementTag();
    }

    public void traceEntityReference(XMLString xMLString) {
        this.printMethodName("entityReference");
        this.printParameter("name", xMLString.toString());
        this.finishEmptyElementTag();
    }

    public void traceWarning(String string, int n, int n2, XMLString[] xMLStringArray, int n3, long l) {
        this.printMethodName("warning");
        this.printParameter("errorURI", string);
        this.printParameter("errorCode", n);
        this.printParameter("errorOffset", Long.toString(l));
        if (n2 == 0) {
            this.finishEmptyElementTag();
        } else {
            this.printParameter("errorParamsCount", n2);
            this.finishStartTagEnd(true);
            int n4 = n3 + n2;
            for (int i = n3; i < n4; ++i) {
                this.printMethodName("errorParam");
                this.finishStartTagEnd(false);
                this.printValue(xMLStringArray[i].toString());
                this.printEndTag("errorParam", false);
            }
            this.printEndTag("warning", true);
        }
    }

    public void traceRecoverableError(String string, int n, int n2, XMLString[] xMLStringArray, int n3, long l) {
        this.printMethodName("recoverableError");
        this.printParameter("errorURI", string);
        this.printParameter("errorCode", n);
        this.printParameter("errorOffset", Long.toString(l));
        if (n2 == 0) {
            this.finishEmptyElementTag();
        } else {
            this.printParameter("errorParamsCount", n2);
            this.finishStartTagEnd(true);
            int n4 = n3 + n2;
            for (int i = n3; i < n4; ++i) {
                this.printMethodName("errorParam");
                this.finishStartTagEnd(false);
                this.printValue(xMLStringArray[i].toString());
                this.printEndTag("errorParam", false);
            }
            this.printEndTag("recoverableError", true);
        }
    }

    public void traceFatalError(String string, int n, int n2, XMLString[] xMLStringArray, int n3, long l) {
        this.printMethodName("fatalError");
        this.printParameter("errorURI", string);
        this.printParameter("errorCode", n);
        this.printParameter("errorOffset", Long.toString(l));
        if (n2 == 0) {
            this.finishEmptyElementTag();
        } else {
            this.printParameter("errorParamsCount", n2);
            this.finishStartTagEnd(true);
            int n4 = n3 + n2;
            for (int i = n3; i < n4; ++i) {
                this.printMethodName("errorParam");
                this.finishStartTagEnd(false);
                this.printValue(xMLStringArray[i].toString());
                this.printEndTag("errorParam", false);
            }
            this.printEndTag("fatalError", true);
        }
    }

    public void traceExtension(Object object) {
        this.printMethodName("extension");
        this.printParameter("state", object.toString());
        this.finishEmptyElementTag();
    }

    private void printMethod(String string) {
        this.printIndent();
        this.fPrintStream.println("<" + string + "/>");
        this.fPrintStream.flush();
    }

    private void printMethodName(String string) {
        this.printIndent();
        this.fPrintStream.print("<" + string);
        ++this.fIndentDepth;
    }

    private void printParameter(String string, int n) {
        this.printParameter(string, Integer.toString(n));
    }

    private void printParameter(String string, XMLString xMLString) {
        this.printParameter(string, xMLString.toString());
    }

    private void printParameter(String string, String string2) {
        if (string2 != null) {
            String string3 = XMLTracer.quote(string2, true);
            this.fPrintStream.print(" " + string + "=" + string3);
        }
    }

    private void printQName(String string, String string2, String string3) {
        this.printMethodName("qName");
        this.printParameter("prefix", string);
        this.printParameter("uri", string2);
        this.printParameter("localName", string3);
        this.finishEmptyElementTag();
    }

    private void printValue(String string) {
        String string2 = XMLTracer.quote(string, false);
        this.fPrintStream.print(string2);
    }

    private void printIndent() {
        for (int i = 0; i < this.fIndentDepth; ++i) {
            this.fPrintStream.print("  ");
        }
    }

    private void finishStartTagEnd(boolean bl) {
        if (bl) {
            this.fPrintStream.println(">");
            this.fPrintStream.flush();
        } else {
            this.fPrintStream.print(">");
        }
    }

    private void printEndTag(String string, boolean bl) {
        --this.fIndentDepth;
        if (bl) {
            this.printIndent();
        }
        this.fPrintStream.println("</" + string + ">");
        this.fPrintStream.flush();
    }

    private void finishEmptyElementTag() {
        this.fPrintStream.println("/>");
        this.fPrintStream.flush();
        --this.fIndentDepth;
    }

    private static String quote(String string, boolean bl) {
        if (string != null) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                stringBuilder.append('\"');
            }
            block6: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '&': {
                        stringBuilder.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        stringBuilder.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        stringBuilder.append("&gt;");
                        continue block6;
                    }
                    case '\"': {
                        stringBuilder.append("&quot;");
                        continue block6;
                    }
                    default: {
                        if (c < ' ' || c >= '\u0080') {
                            stringBuilder.append("&#");
                            stringBuilder.append((int)c);
                            stringBuilder.append(';');
                            continue block6;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
            if (bl) {
                stringBuilder.append('\"');
            }
            return stringBuilder.toString();
        }
        return "null";
    }
}

