/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2012. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UTF8Support {
    private static final int[] fgMultiByteLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};
    private static final int[] fgFirstByteValueMask = new int[]{0, 0, 31, 15, 7};

    public static CharConversionError convertCharsToBytes(char[] cArray, int n, int n2, byte[][] byArray, int[] nArray) {
        int n3;
        int n4;
        byte[] byArray2 = byArray[0];
        int n5 = nArray[0];
        int n6 = byArray2.length;
        if (nArray[1] == -1) {
            n4 = n6 - n5;
            int n7 = n2 - n <= n4 ? n2 : n + n4;
            while (n < n7 && (n3 = cArray[n]) < 128) {
                ++n;
                byArray2[n5++] = (byte)n3;
            }
            if (n == n2) {
                nArray[0] = n5;
                return null;
            }
        } else {
            n3 = nArray[1];
            if (n == n2) {
                nArray[0] = n5;
                nArray[1] = n;
                return CharConversionError.missingSecondHalfOfSurrogatePair();
            }
            nArray[1] = -1;
            if ((n4 = cArray[n++]) < 56320 || n4 >= 57344) {
                nArray[0] = n5;
                nArray[1] = n - 1;
                return CharConversionError.invalidSecondHalfOfSurrogatePair();
            }
            n3 = 65536 + (n3 - 55296 << 10) + (n4 - 56320);
            if (n5 + 4 > n6) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
                n6 <<= 1;
            }
            byArray2[n5] = (byte)(0xF0 | n3 >> 18);
            byArray2[n5 + 1] = (byte)(0x80 | 0x3F & n3 >> 12);
            byArray2[n5 + 2] = (byte)(0x80 | 0x3F & n3 >> 6);
            byArray2[n5 + 3] = (byte)(0x80 | 0x3F & n3);
            n5 += 4;
        }
        while (n < n2) {
            if ((n3 = cArray[n++]) < 128) {
                if (n5 == n6) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n6 <<= 1;
                }
                byArray2[n5++] = (byte)n3;
                continue;
            }
            if (n3 < 2048) {
                if (n5 + 2 > n6) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n6 <<= 1;
                }
                byArray2[n5] = (byte)(0xC0 | n3 >> 6);
                byArray2[n5 + 1] = (byte)(0x80 | 0x3F & n3);
                n5 += 2;
                continue;
            }
            if (n3 < 55296 || n3 >= 57344) {
                if (n5 + 3 > n6) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n6 <<= 1;
                }
                byArray2[n5] = (byte)(0xE0 | n3 >> 12);
                byArray2[n5 + 1] = (byte)(0x80 | 0x3F & n3 >> 6);
                byArray2[n5 + 2] = (byte)(0x80 | 0x3F & n3);
                n5 += 3;
                continue;
            }
            if (n3 < 56320) {
                if (n == n2) {
                    nArray[1] = n3;
                    break;
                }
                n4 = cArray[n];
                if (n4 >= 56320 && n4 < 57344) {
                    ++n;
                } else {
                    nArray[0] = n5;
                    nArray[1] = n - 1;
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                n3 = 65536 + (n3 - 55296 << 10) + (n4 - 56320);
                if (n5 + 4 > n6) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n6 <<= 1;
                }
                byArray2[n5] = (byte)(0xF0 | n3 >> 18);
                byArray2[n5 + 1] = (byte)(0x80 | 0x3F & n3 >> 12);
                byArray2[n5 + 2] = (byte)(0x80 | 0x3F & n3 >> 6);
                byArray2[n5 + 3] = (byte)(0x80 | 0x3F & n3);
                n5 += 4;
                continue;
            }
            nArray[0] = n5;
            nArray[1] = n - 1;
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
        }
        nArray[0] = n5;
        return null;
    }

    public static CharConversionError convertCharsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4, int[] nArray) {
        int n5;
        int n6 = n4 - n3;
        int n7 = n2 - n <= n6 ? n2 : n + n6;
        while (n < n7 && (n5 = cArray[n]) < 128) {
            ++n;
            byArray[n3++] = (byte)n5;
        }
        if (n == n2) {
            nArray[0] = n;
            nArray[1] = n3;
            return null;
        }
        while (n < n2) {
            n5 = cArray[n];
            if (n5 < 128) {
                if (n3 == n4) {
                    nArray[0] = n;
                    nArray[1] = n3;
                    return null;
                }
                ++n;
                byArray[n3++] = (byte)n5;
                continue;
            }
            if (n5 < 2048) {
                if (n3 + 2 > n4) {
                    nArray[0] = n;
                    nArray[1] = n3;
                    return null;
                }
                ++n;
                byArray[n3] = (byte)(0xC0 | n5 >> 6);
                byArray[n3 + 1] = (byte)(0x80 | 0x3F & n5);
                n3 += 2;
                continue;
            }
            if (n5 < 55296 || n5 >= 57344) {
                if (n3 + 3 > n4) {
                    nArray[0] = n;
                    nArray[1] = n3;
                    return null;
                }
                ++n;
                byArray[n3] = (byte)(0xE0 | n5 >> 12);
                byArray[n3 + 1] = (byte)(0x80 | 0x3F & n5 >> 6);
                byArray[n3 + 2] = (byte)(0x80 | 0x3F & n5);
                n3 += 3;
                continue;
            }
            if (n5 < 56320) {
                if (++n == n2 || n3 + 4 > n4) {
                    nArray[0] = n - 1;
                    nArray[1] = n3;
                    return null;
                }
                char c = cArray[n];
                if (c >= '\udc00' && c < '\ue000') {
                    ++n;
                } else {
                    nArray[0] = n - 1;
                    nArray[1] = n3;
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                n5 = 65536 + (n5 - 55296 << 10) + (c - 56320);
                byArray[n3] = (byte)(0xF0 | n5 >> 18);
                byArray[n3 + 1] = (byte)(0x80 | 0x3F & n5 >> 12);
                byArray[n3 + 2] = (byte)(0x80 | 0x3F & n5 >> 6);
                byArray[n3 + 3] = (byte)(0x80 | 0x3F & n5);
                n3 += 4;
                continue;
            }
            nArray[0] = n;
            nArray[1] = n3;
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
        }
        nArray[0] = n;
        nArray[1] = n3;
        return null;
    }

    public static int encodeCharacter(int n, byte[][] byArray, int n2) {
        byte[] byArray2 = byArray[0];
        int n3 = byArray2.length;
        if (n < 128) {
            if (n2 == n3) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n2] = (byte)n;
            return n2 + 1;
        }
        if (n < 2048) {
            if (n2 + 2 > n3) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n2] = (byte)(0xC0 | n >> 6);
            byArray2[n2 + 1] = (byte)(0x80 | 0x3F & n);
            return n2 + 2;
        }
        if (n < 65536) {
            if (n2 + 3 > n3) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n2] = (byte)(0xE0 | n >> 12);
            byArray2[n2 + 1] = (byte)(0x80 | 0x3F & n >> 6);
            byArray2[n2 + 2] = (byte)(0x80 | 0x3F & n);
            return n2 + 3;
        }
        if (n2 + 4 > n3) {
            byArray2 = UTF8Support.resize(byArray2);
            byArray[0] = byArray2;
        }
        byArray2[n2] = (byte)(0xF0 | n >> 18);
        byArray2[n2 + 1] = (byte)(0x80 | 0x3F & n >> 12);
        byArray2[n2 + 2] = (byte)(0x80 | 0x3F & n >> 6);
        byArray2[n2 + 3] = (byte)(0x80 | 0x3F & n);
        return n2 + 4;
    }

    public static CharConversionError convertBytesToChars(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray) {
        byte[] byArray = dataBuffer.bytes;
        int n3 = n;
        char[] cArray2 = cArray[0];
        int n4 = nArray[0];
        if (dataBuffer2 == null && n2 - n3 <= cArray2.length - n4) {
            while (n3 < n2 && byArray[n3] >= 0) {
                cArray2[n4++] = (char)byArray[n3++];
            }
            if (n3 == n2) {
                nArray[0] = n4;
                return null;
            }
            n = n3;
            nArray[0] = n4;
        }
        return UTF8Support.convertBytesToChars2(dataBuffer, dataBuffer2, n, n2, cArray, nArray);
    }

    private static CharConversionError convertBytesToChars2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray) {
        int n3;
        DataBuffer dataBuffer3 = dataBuffer;
        byte[] byArray = dataBuffer3.bytes;
        int n4 = n;
        char[] cArray2 = cArray[0];
        int n5 = nArray[0];
        int n6 = cArray2.length;
        int n7 = n6 - n5;
        int n8 = 0;
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer3;
            n3 = n2;
        } else {
            n3 = dataBuffer2 == dataBuffer3 ? n2 : dataBuffer3.endOffset;
        }
        while (true) {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = n3 - n4 <= (n7 = n6 - n5) ? n3 : n4 + n7;
            while (n4 < n13 && (n8 = byArray[n4]) >= 0) {
                ++n4;
                cArray2[n5++] = (char)n8;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return null;
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
                continue;
            }
            if (n5 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
                continue;
            }
            if (n4 == n13) continue;
            if ((n12 = fgMultiByteLength[(n8 = byArray[n4++] & 0xFF) >> 3]) == 0) {
                return UTF8Support.charConversionFailure(1, n8, 0, 0, 0);
            }
            int n14 = n8 & fgFirstByteValueMask[n12];
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n11 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(2, n8, n11, 0, 0);
            }
            if (n12 == 2) {
                n14 = (n14 << 6) + (0x3F & n11);
                cArray2[n5++] = (char)n14;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n10 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(3, n8, n11, n10, 0);
            }
            if (n12 == 3) {
                if ((n14 = (n14 << 12) + ((0x3F & n11) << 6) + (0x3F & n10)) >= 55296 && n14 < 57344) {
                    return UTF8Support.charConversionFailure(1, n8, n11, n10, 0);
                }
                cArray2[n5++] = (char)n14;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n9 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(4, n8, n11, n10, n9);
            }
            int n15 = (n14 << 8) + ((0x30 & n11) << 2);
            if (n15 > 1024 || n15 == 0) {
                return CharConversionError.invalidUTF8SurrogateEncoding();
            }
            int n16 = n15 - 64;
            int n17 = 55296 + n16 + ((0xF & n11) << 2) + ((0x30 & n10) >> 4);
            int n18 = 56320 + ((0xF & n10) << 6) + (0x3F & n9);
            cArray2[n5] = (char)n17;
            if (n5 + 1 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
            }
            cArray2[n5 + 1] = (char)n18;
            n5 += 2;
        }
    }

    public static CharConversionError normalizeBytesToChars(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray, boolean bl) {
        block5: {
            byte[] byArray = dataBuffer.bytes;
            int n3 = n;
            char[] cArray2 = cArray[0];
            int n4 = nArray[0];
            if (dataBuffer2 == null && n2 - n3 <= cArray2.length - n4) {
                while (n3 < n2) {
                    if (byArray[n3] != 13) {
                        if (byArray[n3] >= 0) {
                            cArray2[n4++] = (char)byArray[n3++];
                            continue;
                        }
                        break block5;
                    }
                    cArray2[n4++] = 10;
                    if (++n3 < n2 && byArray[n3] == 10) {
                        ++n3;
                        continue;
                    }
                    if (!bl || n3 + 1 >= n2 || (byArray[n3] & 0xFF) != 194 || (byArray[n3 + 1] & 0xFF) != 133) continue;
                    n3 += 2;
                }
                nArray[0] = n4;
                return null;
            }
        }
        return UTF8Support.normalizeBytesToChars2(dataBuffer, dataBuffer2, n, n2, cArray, nArray, bl);
    }

    private static CharConversionError normalizeBytesToChars2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray, boolean bl) {
        int n3;
        DataBuffer dataBuffer3 = dataBuffer;
        byte[] byArray = dataBuffer3.bytes;
        int n4 = n;
        char[] cArray2 = cArray[0];
        int n5 = nArray[0];
        int n6 = cArray2.length;
        boolean bl2 = false;
        int n7 = 0;
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer3;
            n3 = n2;
        } else {
            n3 = dataBuffer2 == dataBuffer3 ? n2 : dataBuffer3.endOffset;
        }
        while (true) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = n3 - n4 <= (n12 = n6 - n5) ? n3 : n4 + n12;
            while (n4 < n13) {
                n7 = byArray[n4];
                if (!bl2) {
                    if (n7 < 0) break;
                    ++n4;
                    if (n7 != 13) {
                        cArray2[n5++] = (char)n7;
                        continue;
                    }
                    bl2 = true;
                    cArray2[n5++] = 10;
                    continue;
                }
                bl2 = false;
                if (n7 == 10) {
                    ++n4;
                    continue;
                }
                if (n7 >= 0) {
                    ++n4;
                    if (n7 == 13) {
                        n7 = 10;
                        bl2 = true;
                    }
                    cArray2[n5++] = (char)n7;
                    continue;
                }
                bl2 = bl;
                break;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return null;
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
                continue;
            }
            if (n5 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
                continue;
            }
            if (n4 == n13) continue;
            if ((n11 = fgMultiByteLength[(n7 = byArray[n4++] & 0xFF) >> 3]) == 0) {
                return UTF8Support.charConversionFailure(1, n7, 0, 0, 0);
            }
            int n14 = n7 & fgFirstByteValueMask[n11];
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n10 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(2, n7, n10, 0, 0);
            }
            if (n11 == 2) {
                n14 = (n14 << 6) + (0x3F & n10);
                if (bl && n14 == 133) {
                    if (!bl2) {
                        cArray2[n5++] = 10;
                    }
                } else {
                    cArray2[n5++] = (char)n14;
                }
                bl2 = false;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n9 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(3, n7, n10, n9, 0);
            }
            if (n11 == 3) {
                if ((n14 = (n14 << 12) + ((0x3F & n10) << 6) + (0x3F & n9)) >= 55296 && n14 < 57344) {
                    return UTF8Support.charConversionFailure(1, n7, n10, n9, 0);
                }
                cArray2[n5++] = bl && n14 == 8232 ? 10 : (char)n14;
                bl2 = false;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n8 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(4, n7, n10, n9, n8);
            }
            int n15 = (n14 << 8) + ((0x30 & n10) << 2);
            if (n15 > 1024 || n15 == 0) {
                return CharConversionError.invalidUTF8SurrogateEncoding();
            }
            int n16 = n15 - 64;
            int n17 = 55296 + n16 + ((0xF & n10) << 2) + ((0x30 & n9) >> 4);
            int n18 = 56320 + ((0xF & n9) << 6) + (0x3F & n8);
            cArray2[n5] = (char)n17;
            if (n5 + 1 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
            }
            cArray2[n5 + 1] = (char)n18;
            n5 += 2;
        }
    }

    public static CharConversionError convertBytesToCharsAndApplyReplaceWSFacet(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray) {
        byte[] byArray = dataBuffer.bytes;
        int n3 = n;
        char[] cArray2 = cArray[0];
        int n4 = nArray[0];
        if (dataBuffer2 == null && n2 - n3 <= cArray2.length - n4) {
            while (n3 < n2 && byArray[n3] > 13) {
                cArray2[n4++] = (char)byArray[n3++];
            }
            if (n3 == n2) {
                nArray[0] = n4;
                return null;
            }
            n = n3;
            nArray[0] = n4;
        }
        return UTF8Support.convertBytesToCharsAndApplyReplaceWSFacet2(dataBuffer, dataBuffer2, n, n2, cArray, nArray);
    }

    private static CharConversionError convertBytesToCharsAndApplyReplaceWSFacet2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray) {
        int n3;
        DataBuffer dataBuffer3 = dataBuffer;
        byte[] byArray = dataBuffer3.bytes;
        int n4 = n;
        char[] cArray2 = cArray[0];
        int n5 = nArray[0];
        int n6 = cArray2.length;
        int n7 = n6 - n5;
        int n8 = 0;
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer3;
            n3 = n2;
        } else {
            n3 = dataBuffer2 == dataBuffer3 ? n2 : dataBuffer3.endOffset;
        }
        while (true) {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = n3 - n4 <= (n7 = n6 - n5) ? n3 : n4 + n7;
            while (n4 < n13) {
                n8 = byArray[n4];
                if (n8 > 13) {
                    ++n4;
                    cArray2[n5++] = (char)n8;
                    continue;
                }
                if (n8 < 0) break;
                ++n4;
                if (n8 == 9 || n8 == 10 || n8 == 13) {
                    n8 = 32;
                }
                cArray2[n5++] = (char)n8;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return null;
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
                continue;
            }
            if (n5 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
                continue;
            }
            if (n4 == n13) continue;
            if ((n12 = fgMultiByteLength[(n8 = byArray[n4++] & 0xFF) >> 3]) == 0) {
                return UTF8Support.charConversionFailure(1, n8, 0, 0, 0);
            }
            int n14 = n8 & fgFirstByteValueMask[n12];
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n11 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(2, n8, n11, 0, 0);
            }
            if (n12 == 2) {
                n14 = (n14 << 6) + (0x3F & n11);
                cArray2[n5++] = (char)n14;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n10 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(3, n8, n11, n10, 0);
            }
            if (n12 == 3) {
                if ((n14 = (n14 << 12) + ((0x3F & n11) << 6) + (0x3F & n10)) >= 55296 && n14 < 57344) {
                    return UTF8Support.charConversionFailure(1, n8, n11, n10, 0);
                }
                cArray2[n5++] = (char)n14;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n9 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(4, n8, n11, n10, n9);
            }
            int n15 = (n14 << 8) + ((0x30 & n11) << 2);
            if (n15 > 1024 || n15 == 0) {
                return CharConversionError.invalidUTF8SurrogateEncoding();
            }
            int n16 = n15 - 64;
            int n17 = 55296 + n16 + ((0xF & n11) << 2) + ((0x30 & n10) >> 4);
            int n18 = 56320 + ((0xF & n10) << 6) + (0x3F & n9);
            cArray2[n5] = (char)n17;
            if (n5 + 1 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
            }
            cArray2[n5 + 1] = (char)n18;
            n5 += 2;
        }
    }

    public static CharConversionError normalizeBytesToCharsAndApplyReplaceWSFacet(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray, boolean bl) {
        block5: {
            byte[] byArray = dataBuffer.bytes;
            int n3 = n;
            char[] cArray2 = cArray[0];
            int n4 = nArray[0];
            if (dataBuffer2 == null && n2 - n3 <= cArray2.length - n4) {
                while (n3 < n2) {
                    if (byArray[n3] != 13) {
                        if (byArray[n3] > 10) {
                            cArray2[n4++] = (char)byArray[n3++];
                            continue;
                        }
                        break block5;
                    }
                    cArray2[n4++] = 32;
                    if (++n3 < n2 && byArray[n3] == 10) {
                        ++n3;
                        continue;
                    }
                    if (!bl || n3 + 1 >= n2 || (byArray[n3] & 0xFF) != 194 || (byArray[n3 + 1] & 0xFF) != 133) continue;
                    n3 += 2;
                }
                nArray[0] = n4;
                return null;
            }
        }
        return UTF8Support.normalizeBytesToCharsAndApplyReplaceWSFacet2(dataBuffer, dataBuffer2, n, n2, cArray, nArray, bl);
    }

    private static CharConversionError normalizeBytesToCharsAndApplyReplaceWSFacet2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray, boolean bl) {
        int n3;
        DataBuffer dataBuffer3 = dataBuffer;
        byte[] byArray = dataBuffer3.bytes;
        int n4 = n;
        char[] cArray2 = cArray[0];
        int n5 = nArray[0];
        int n6 = cArray2.length;
        boolean bl2 = false;
        int n7 = 0;
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer3;
            n3 = n2;
        } else {
            n3 = dataBuffer2 == dataBuffer3 ? n2 : dataBuffer3.endOffset;
        }
        while (true) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = n3 - n4 <= (n12 = n6 - n5) ? n3 : n4 + n12;
            while (n4 < n13) {
                n7 = byArray[n4];
                if (!bl2) {
                    if (n7 > 13) {
                        ++n4;
                        cArray2[n5++] = (char)n7;
                        continue;
                    }
                    if (n7 < 0) break;
                    ++n4;
                    if (n7 != 13) {
                        if (n7 == 9 || n7 == 10) {
                            n7 = 32;
                        }
                        cArray2[n5++] = (char)n7;
                        continue;
                    }
                    bl2 = true;
                    cArray2[n5++] = 32;
                    continue;
                }
                bl2 = false;
                if (n7 == 10) {
                    ++n4;
                    continue;
                }
                if (n7 >= 0) {
                    ++n4;
                    if (n7 == 13) {
                        n7 = 32;
                        bl2 = true;
                    } else if (n7 == 9 || n7 == 10) {
                        n7 = 32;
                    }
                    cArray2[n5++] = (char)n7;
                    continue;
                }
                bl2 = bl;
                break;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return null;
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
                continue;
            }
            if (n5 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
                continue;
            }
            if (n4 == n13) continue;
            if ((n11 = fgMultiByteLength[(n7 = byArray[n4++] & 0xFF) >> 3]) == 0) {
                return UTF8Support.charConversionFailure(1, n7, 0, 0, 0);
            }
            int n14 = n7 & fgFirstByteValueMask[n11];
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n10 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(2, n7, n10, 0, 0);
            }
            if (n11 == 2) {
                n14 = (n14 << 6) + (0x3F & n10);
                if (bl && n14 == 133) {
                    if (!bl2) {
                        cArray2[n5++] = 32;
                    }
                } else {
                    cArray2[n5++] = (char)n14;
                }
                bl2 = false;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n9 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(3, n7, n10, n9, 0);
            }
            if (n11 == 3) {
                if ((n14 = (n14 << 12) + ((0x3F & n10) << 6) + (0x3F & n9)) >= 55296 && n14 < 57344) {
                    return UTF8Support.charConversionFailure(1, n7, n10, n9, 0);
                }
                cArray2[n5++] = bl && n14 == 8232 ? 32 : (char)n14;
                bl2 = false;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n8 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(4, n7, n10, n9, n8);
            }
            int n15 = (n14 << 8) + ((0x30 & n10) << 2);
            if (n15 > 1024 || n15 == 0) {
                return CharConversionError.invalidUTF8SurrogateEncoding();
            }
            int n16 = n15 - 64;
            int n17 = 55296 + n16 + ((0xF & n10) << 2) + ((0x30 & n9) >> 4);
            int n18 = 56320 + ((0xF & n9) << 6) + (0x3F & n8);
            cArray2[n5] = (char)n17;
            if (n5 + 1 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
            }
            cArray2[n5 + 1] = (char)n18;
            n5 += 2;
        }
    }

    public static CharConversionError decodeCharacter(byte[] byArray, int n, int n2, int[] nArray) {
        if (n < n2) {
            int n3 = byArray[n];
            if (n3 >= 0) {
                nArray[0] = n3;
                nArray[1] = 1;
                return null;
            }
            int n4 = fgMultiByteLength[(n3 &= 0xFF) >> 3];
            if (n4 > 0) {
                nArray[1] = n4;
                if (n + n4 > n2) {
                    return CharConversionError.insufficientInputToDecodeCharacter();
                }
                int n5 = n3 & fgFirstByteValueMask[n4];
                int n6 = byArray[n + 1] & 0xFF;
                if ((0xC0 & n6) != 128) {
                    return UTF8Support.charConversionFailure(2, n3, n6, 0, 0);
                }
                if (n4 == 2) {
                    nArray[0] = n5 = (n5 << 6) + (0x3F & n6);
                    return null;
                }
                int n7 = byArray[n + 2] & 0xFF;
                if ((0xC0 & n7) != 128) {
                    return UTF8Support.charConversionFailure(3, n3, n6, n7, 0);
                }
                if (n4 == 3) {
                    nArray[0] = n5 = (n5 << 12) + ((0x3F & n6) << 6) + (0x3F & n7);
                    return null;
                }
                int n8 = byArray[n + 3] & 0xFF;
                if ((0xC0 & n8) != 128) {
                    return UTF8Support.charConversionFailure(4, n3, n6, n7, n8);
                }
                nArray[0] = n5 = (n5 << 18) + ((0x3F & n6) << 12) + ((0x3F & n7) << 6) + (0x3F & n8);
                return null;
            }
            return UTF8Support.charConversionFailure(1, n3, 0, 0, 0);
        }
        return CharConversionError.insufficientInputToDecodeCharacter();
    }

    public static CharConversionError decodeCharacter(DataBuffer dataBuffer, int n, DataBuffer dataBuffer2, int n2, int[] nArray) {
        int n3;
        byte[] byArray;
        block11: {
            byArray = dataBuffer.bytes;
            n3 = dataBuffer.endOffset;
            while (true) {
                byArray = dataBuffer.bytes;
                if (n < n3) break block11;
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
            }
            return CharConversionError.insufficientInputToDecodeCharacter();
        }
        int n4 = byArray[n++];
        if (n4 >= 0) {
            nArray[0] = n4;
            nArray[1] = 1;
            return null;
        }
        int n5 = fgMultiByteLength[(n4 &= 0xFF) >> 3];
        if (n5 > 1) {
            int n6;
            int n7;
            int n8;
            block14: {
                block13: {
                    block12: {
                        nArray[1] = n5;
                        n8 = n4 & fgFirstByteValueMask[n5];
                        while (true) {
                            if (n < n3) break block12;
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            byArray = dataBuffer.bytes;
                            n = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
                        }
                        return CharConversionError.insufficientInputToDecodeCharacter();
                    }
                    n7 = byArray[n++] & 0xFF;
                    if ((0xC0 & n7) != 128) {
                        return UTF8Support.charConversionFailure(2, n4, n7, 0, 0);
                    }
                    if (n5 == 2) {
                        nArray[0] = n8 = (n8 << 6) + (0x3F & n7);
                        return null;
                    }
                    while (true) {
                        if (n < n3) break block13;
                        if (dataBuffer == dataBuffer2) break;
                        dataBuffer = dataBuffer.next;
                        byArray = dataBuffer.bytes;
                        n = dataBuffer.startOffset;
                        n3 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
                    }
                    return CharConversionError.insufficientInputToDecodeCharacter();
                }
                n6 = byArray[n++] & 0xFF;
                if ((0xC0 & n6) != 128) {
                    return UTF8Support.charConversionFailure(3, n4, n7, n6, 0);
                }
                if (n5 == 3) {
                    nArray[0] = n8 = (n8 << 12) + ((0x3F & n7) << 6) + (0x3F & n6);
                    return null;
                }
                while (true) {
                    if (n < n3) break block14;
                    if (dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
                }
                return CharConversionError.insufficientInputToDecodeCharacter();
            }
            int n9 = byArray[n++] & 0xFF;
            if ((0xC0 & n9) != 128) {
                return UTF8Support.charConversionFailure(4, n4, n7, n6, n9);
            }
            nArray[0] = n8 = (n8 << 18) + ((0x3F & n7) << 12) + ((0x3F & n6) << 6) + (0x3F & n9);
            return null;
        }
        return UTF8Support.charConversionFailure(1, n4, 0, 0, 0);
    }

    public static boolean decodeCharacter(ParsedEntity parsedEntity, int[] nArray) {
        int n;
        int n2;
        byte[] byArray;
        boolean bl;
        block26: {
            bl = false;
            do {
                byArray = parsedEntity.bytes;
                n2 = parsedEntity.offset;
                n = parsedEntity.endOffset;
                if (n2 < n) break block26;
                if (bl) continue;
                parsedEntity.setMark();
                bl = true;
            } while (parsedEntity.loadMore() != 0);
            if (parsedEntity.atEndOfEntity()) {
                parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
            }
            parsedEntity.resetToMark();
            return parsedEntity.error == null;
        }
        int n3 = byArray[n2++];
        if (n3 >= 0) {
            nArray[0] = n3;
            nArray[1] = 1;
            if (bl) {
                parsedEntity.resetToMark();
            }
            return true;
        }
        int n4 = fgMultiByteLength[(n3 &= 0xFF) >> 3];
        if (n4 > 1) {
            int n5;
            int n6;
            int n7;
            block29: {
                block28: {
                    block27: {
                        nArray[1] = n4;
                        n7 = n3 & fgFirstByteValueMask[n4];
                        while (true) {
                            if (n2 < n) break block27;
                            if (!bl) {
                                parsedEntity.setMark();
                                bl = true;
                            }
                            if (parsedEntity.loadMore() == 0) break;
                            byArray = parsedEntity.bytes;
                            n2 = parsedEntity.offset;
                            n = parsedEntity.endOffset;
                        }
                        if (parsedEntity.atEndOfEntity()) {
                            parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                        }
                        parsedEntity.resetToMark();
                        return parsedEntity.error == null;
                    }
                    n6 = byArray[n2++] & 0xFF;
                    if ((0xC0 & n6) != 128) {
                        parsedEntity.error = UTF8Support.charConversionFailure(2, n3, n6, 0, 0);
                        if (bl) {
                            parsedEntity.resetToMark();
                        }
                        return false;
                    }
                    if (n4 == 2) {
                        nArray[0] = n7 = (n7 << 6) + (0x3F & n6);
                        if (bl) {
                            parsedEntity.resetToMark();
                        }
                        return true;
                    }
                    while (true) {
                        if (n2 < n) break block28;
                        if (!bl) {
                            parsedEntity.setMark();
                            bl = true;
                        }
                        if (parsedEntity.loadMore() == 0) break;
                        byArray = parsedEntity.bytes;
                        n2 = parsedEntity.offset;
                        n = parsedEntity.endOffset;
                    }
                    if (parsedEntity.atEndOfEntity()) {
                        parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                    }
                    parsedEntity.resetToMark();
                    return parsedEntity.error == null;
                }
                n5 = byArray[n2++] & 0xFF;
                if ((0xC0 & n5) != 128) {
                    parsedEntity.error = UTF8Support.charConversionFailure(3, n3, n6, n5, 0);
                    if (bl) {
                        parsedEntity.resetToMark();
                    }
                    return false;
                }
                if (n4 == 3) {
                    nArray[0] = n7 = (n7 << 12) + ((0x3F & n6) << 6) + (0x3F & n5);
                    if (bl) {
                        parsedEntity.resetToMark();
                    }
                    return true;
                }
                while (true) {
                    if (n2 < n) break block29;
                    if (!bl) {
                        parsedEntity.setMark();
                        bl = true;
                    }
                    if (parsedEntity.loadMore() == 0) break;
                    byArray = parsedEntity.bytes;
                    n2 = parsedEntity.offset;
                    n = parsedEntity.endOffset;
                }
                if (parsedEntity.atEndOfEntity()) {
                    parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                }
                parsedEntity.resetToMark();
                return parsedEntity.error == null;
            }
            int n8 = byArray[n2++] & 0xFF;
            if ((0xC0 & n8) != 128) {
                parsedEntity.error = UTF8Support.charConversionFailure(4, n3, n6, n5, n8);
                if (bl) {
                    parsedEntity.resetToMark();
                }
                return false;
            }
            nArray[0] = n7 = (n7 << 18) + ((0x3F & n6) << 12) + ((0x3F & n5) << 6) + (0x3F & n8);
            if (bl) {
                parsedEntity.resetToMark();
            }
            return true;
        }
        parsedEntity.error = UTF8Support.charConversionFailure(1, n3, 0, 0, 0);
        if (bl) {
            parsedEntity.resetToMark();
        }
        return false;
    }

    public static int lengthAsCharacters(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, int n3, int[] nArray) {
        boolean bl;
        DataBuffer dataBuffer3 = dataBuffer;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = (n3 & 8) != 0;
        boolean bl4 = bl = bl3 || (n3 & 4) != 0;
        if (nArray != null) {
            nArray[0] = 0;
        }
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer3;
        }
        while (true) {
            byte[] byArray = dataBuffer3.bytes;
            int n5 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
            block7: while (n < n5) {
                int n6;
                ++n4;
                if ((n6 = byArray[n++]) >= 0) {
                    if (!bl) continue;
                    if (bl2) {
                        bl2 = false;
                        if (n6 != 10) continue;
                        --n4;
                        continue;
                    }
                    if (n6 != 13) continue;
                    bl2 = true;
                    continue;
                }
                switch (fgMultiByteLength[(n6 &= 0xFF) >> 3]) {
                    default: {
                        return -1;
                    }
                    case 1: {
                        continue block7;
                    }
                    case 2: {
                        if (bl2 && bl3 && n6 == 194) {
                            if (n < n5) {
                                if ((byArray[n] & 0xFF) == 133) {
                                    --n4;
                                    bl2 = false;
                                }
                            } else if (dataBuffer3 != dataBuffer2 && dataBuffer3.next.bytes[dataBuffer3.next.startOffset] == 133) {
                                --n4;
                                bl2 = false;
                            }
                        }
                        ++n;
                        continue block7;
                    }
                    case 3: {
                        n += 2;
                        continue block7;
                    }
                    case 4: 
                }
                n += 3;
                if (nArray == null) continue;
                nArray[0] = nArray[0] + 1;
            }
            if (dataBuffer3 == dataBuffer2) break;
            dataBuffer3 = dataBuffer3.next;
            n = dataBuffer3.startOffset + (n - n5);
        }
        return n4;
    }

    public static int lengthAsCharacters(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            if (cArray[n] < '\ud800' || cArray[n] >= '\udc00') {
                ++n;
                continue;
            }
            n += 2;
            --n2;
        }
        return n2;
    }

    public static boolean equalsString(byte[] byArray, int n, int n2, String string) {
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3 && n < n2) {
            int n5;
            if ((n5 = string.charAt(n4++)) < 128) {
                if (n5 == byArray[n++]) continue;
                return false;
            }
            if (n5 < 2048) {
                if (n + 1 >= n2) {
                    return false;
                }
                if ((byte)(0xC0 | n5 >> 6) != byArray[n++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n5) == byArray[n++]) continue;
                return false;
            }
            if (n5 < 55296 || n5 >= 57344) {
                if (n + 2 >= n2) {
                    return false;
                }
                if ((byte)(0xE0 | n5 >> 12) != byArray[n++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n5 >> 6) != byArray[n++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n5) == byArray[n++]) continue;
                return false;
            }
            if (n5 < 56320) {
                char c;
                if (n4 == n3 || n + 3 >= n2) {
                    return false;
                }
                if ((c = string.charAt(n4++)) < '\udc00' || c >= '\ue000') {
                    return false;
                }
                if ((byte)(0xF0 | (n5 = 65536 + (n5 - 55296 << 10) + (c - 56320)) >> 18) != byArray[n++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n5 >> 12) != byArray[n++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n5 >> 6) != byArray[n++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n5) == byArray[n++]) continue;
                return false;
            }
            return false;
        }
        return n4 == n3 && n == n2;
    }

    public static int hashCode(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + string.charAt(i);
        }
        assert (n2 == string.hashCode());
        return n2;
    }

    public static int hashCode(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            int n5 = byArray[n4];
            if (n5 >= 0) {
                n3 = n3 * 31 + n5;
                ++n4;
                continue;
            }
            int n6 = fgMultiByteLength[(n5 &= 0xFF) >> 3];
            if (n6 > 0) {
                if (n4 + n6 > n2) {
                    return -1;
                }
                int n7 = n5 & fgFirstByteValueMask[n6];
                int n8 = byArray[n4 + 1] & 0xFF;
                if ((0xC0 & n8) != 128) {
                    return -1;
                }
                if (n6 == 2) {
                    n7 = (n7 << 6) + (0x3F & n8);
                    n3 = n3 * 31 + n7;
                    n4 += 2;
                    continue;
                }
                int n9 = byArray[n4 + 2] & 0xFF;
                if ((0xC0 & n9) != 128) {
                    return -1;
                }
                if (n6 == 3) {
                    n7 = (n7 << 12) + ((0x3F & n8) << 6) + (0x3F & n9);
                    n3 = n3 * 31 + n7;
                    n4 += 3;
                    continue;
                }
                int n10 = byArray[n4 + 3] & 0xFF;
                if ((0xC0 & n10) != 128) {
                    return -1;
                }
                n7 = (n7 << 18) + ((0x3F & n8) << 12) + ((0x3F & n9) << 6) + (0x3F & n10);
                int n11 = n7 - 65536;
                n7 = 55296 + (n11 >> 10);
                n3 = n3 * 31 + n7;
                n7 = 56320 + (n11 & 0x3FF);
                n3 = n3 * 31 + n7;
                n4 += 4;
                continue;
            }
            return -1;
        }
        return n3;
    }

    public static int hashCode(String string, int[] nArray, int n) {
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = n3 * nArray[i & n] + string.charAt(i);
        }
        return n3;
    }

    public static int hashCode(XMLString xMLString, int[] nArray, int n) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        int n2 = xMLString.startOffset;
        int n3 = xMLString.length;
        int n4 = n2 + n3;
        byte[] byArray = dataBuffer.bytes;
        int n5 = n2;
        int n6 = 0;
        int n7 = 0;
        if (n4 <= dataBuffer.endOffset) {
            while (n5 < n4 && byArray[n5] >= 0) {
                n6 = n6 * nArray[n7++ & n] + byArray[n5++];
            }
            if (n5 == n4) {
                return n6;
            }
            n2 = n5;
            n3 = n4 - n2;
        }
        return UTF8Support.hashCode2(dataBuffer, n2, n3, n6, nArray, n, n7);
    }

    private static int hashCode2(DataBuffer dataBuffer, int n, int n2, int n3, int[] nArray, int n4, int n5) {
        int n6 = n + n2;
        DataBuffer dataBuffer2 = dataBuffer;
        byte[] byArray = dataBuffer2.bytes;
        int n7 = n;
        int n8 = Math.min(n6, dataBuffer2.endOffset);
        while (true) {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            if (n7 < n8 && (n13 = byArray[n7]) >= 0) {
                ++n7;
                n3 = n3 * nArray[n5++ & n4] + n13;
                continue;
            }
            if (n7 == n6) {
                return n3;
            }
            if (n7 == n8) {
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n7 = dataBuffer2.startOffset;
                n8 = Math.min(n6 -= n8 - n7, dataBuffer2.endOffset);
                continue;
            }
            if ((n12 = fgMultiByteLength[(n13 = byArray[n7++] & 0xFF) >> 3]) <= 1) {
                return -1;
            }
            int n14 = n13 & fgFirstByteValueMask[n12];
            if (n7 == n8) {
                if (n7 == n6) {
                    return -1;
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n7 = dataBuffer2.startOffset;
                n8 = Math.min(n6 -= n8 - n7, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n11 = byArray[n7++] & 0xFF)) != 128) {
                return -1;
            }
            if (n12 == 2) {
                n14 = (n14 << 6) + (0x3F & n11);
                n3 = n3 * nArray[n5++ & n4] + n14;
                continue;
            }
            if (n7 == n8) {
                if (n7 == n6) {
                    return -1;
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n7 = dataBuffer2.startOffset;
                n8 = Math.min(n6 -= n8 - n7, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n10 = byArray[n7++] & 0xFF)) != 128) {
                return -1;
            }
            if (n12 == 3) {
                if ((n14 = (n14 << 12) + ((0x3F & n11) << 6) + (0x3F & n10)) >= 55296 && n14 < 57344) {
                    return -1;
                }
                n3 = n3 * nArray[n5++ & n4] + n14;
                continue;
            }
            if (n7 == n8) {
                if (n7 == n6) {
                    return -1;
                }
                dataBuffer2 = dataBuffer2.next;
                byArray = dataBuffer2.bytes;
                n7 = dataBuffer2.startOffset;
                n8 = Math.min(n6 -= n8 - n7, dataBuffer2.endOffset);
            }
            if ((0xC0 & (n9 = byArray[n7++] & 0xFF)) != 128) {
                return -1;
            }
            n14 = (n14 << 18) + ((0x3F & n11) << 12) + ((0x3F & n10) << 6) + (0x3F & n9);
            int n15 = n14 - 65536;
            n14 = 55296 + (n15 >> 10);
            n3 = n3 * nArray[n5++ & n4] + n14;
            n14 = 56320 + (n15 & 0x3FF);
            n3 = n3 * nArray[n5++ & n4] + n14;
        }
    }

    private UTF8Support() {
    }

    private static byte[] resize(byte[] byArray) {
        return ArrayAllocator.resizeByteArray(byArray, byArray.length << 1);
    }

    private static char[] resize(char[] cArray) {
        return ArrayAllocator.resizeCharArray(cArray, cArray.length << 1);
    }

    private static CharConversionError charConversionFailure(int n, int n2, int n3, int n4, int n5) {
        return CharConversionError.invalidUTF8CharacterEncoding(n, n2, n3, n4, n5);
    }
}

