/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util.encoding;

import com.ibm.xml.xlxp2.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp2.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import java.io.IOException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class Latin1EncodingSupport
implements EncodingSupport {
    private static EncodingSupport fgSingleton = new Latin1EncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, ByteStreamDataSource byteStreamDataSource) {
        byteStreamDataSource.setEncodingSupport(this);
        byteStreamDataSource.createReadBuffer();
        return byteStreamDataSource.load(parsedEntity);
    }

    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n = dataBuffer.endOffset;
        int n2 = byteStreamDataSource.readOffset;
        int n3 = 0;
        try {
            byte by;
            int n4;
            if (byteStreamDataSource.stream != null && (n2 == 0 || n2 < n && byteStreamDataSource.stream.available() > 0)) {
                int n5 = n - n2;
                int n6 = byteStreamDataSource.stream.read(byArray, n2, n5);
                if (n6 == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                    if (n2 == 0) {
                        byteStreamDataSource.readOffset = 0;
                        dataBuffer.endOffset = n3;
                        return null;
                    }
                    n4 = 0;
                } else {
                    int n7 = n5 >> byteStreamDataSource.bufferLoadFactor;
                    while (n6 < n7) {
                        int n8 = n2 + n6;
                        int n9 = byteStreamDataSource.stream.read(byArray, n8, n5 - n6);
                        if (n9 == -1) {
                            byteStreamDataSource.stream.close();
                            byteStreamDataSource.stream = null;
                            break;
                        }
                        n6 += n9;
                    }
                    n4 = n6;
                }
            } else {
                n4 = 0;
            }
            n4 += n2;
            n2 = 0;
            byArray[n4] = 13;
            while ((by = byArray[n2]) >= 0 && by != 13) {
                ++n2;
            }
            if (n2 == n4) {
                byArray[n4] = 0;
                byteStreamDataSource.readOffset = 0;
                dataBuffer.endOffset = n2;
                if (n2 == n) {
                    return null;
                }
            } else if (this.normalizeLineBreaks(dataBuffer, n2, n4, byteStreamDataSource)) {
                return null;
            }
            return null;
        }
        catch (IOException iOException) {
            return CharConversionError.runtimeIOError(iOException);
        }
    }

    private Latin1EncodingSupport() {
    }

    private byte[] checkReadBuffer(int n, ByteStreamDataSource byteStreamDataSource) {
        int n2;
        if (n <= byteStreamDataSource.readLength) {
            return byteStreamDataSource.readBuffer;
        }
        for (n2 = byteStreamDataSource.readLength << 1; n > n2; n2 <<= 1) {
        }
        byteStreamDataSource.readLength = n2;
        byteStreamDataSource.readBuffer = ArrayAllocator.replaceByteArray(byteStreamDataSource.readBuffer, n2 + 1);
        return byteStreamDataSource.readBuffer;
    }

    private boolean normalizeLineBreaksDoubleBuffered(DataBuffer dataBuffer, int n, int n2, ByteStreamDataSource byteStreamDataSource) {
        byte[] byArray = this.checkReadBuffer(n2 -= n, byteStreamDataSource);
        byte[] byArray2 = dataBuffer.bytes;
        int n3 = byArray2.length - 1;
        int n4 = dataBuffer.endOffset;
        boolean bl = byteStreamDataSource.isXML10;
        int n5 = 0;
        byte by = 0;
        System.arraycopy(byArray2, n, byArray, n5, n2 + 1);
        while (true) {
            int n6;
            if ((by = byArray[n5]) >= 0 && by != 13) {
                int n7;
                n6 = n5++;
                while ((by = byArray[n5]) >= 0 && by != 13) {
                    ++n5;
                }
                if (n5 - n6 <= n3 - n) {
                    n7 = n5 - n6;
                } else {
                    n7 = n3 - n;
                    n5 = n6 + n7;
                }
                System.arraycopy(byArray, n6, byArray2, n, n7);
                n += n7;
            }
            if (n5 == n2 || n == n3) break;
            if (by >= 0) {
                if (++n5 < n2) {
                    if ((by = byArray[n5++]) != 10 && (bl || (by & 0xFF) != 133)) {
                        --n5;
                    }
                    byArray2[n++] = 10;
                    continue;
                }
                if (n5 == n2 && byteStreamDataSource.stream == null) {
                    byArray2[n++] = 10;
                    break;
                }
                --n5;
                break;
            }
            n6 = (char)(by & 0xFF);
            if (!bl && n6 == 133) {
                ++n5;
                byArray2[n++] = 10;
                continue;
            }
            if (n + 1 >= n3) break;
            ++n5;
            byArray2[n++] = (byte)(0xC0 | n6 >> 6);
            byArray2[n++] = (byte)(0x80 | 0x3F & n6);
        }
        dataBuffer.endOffset = n;
        byArray2[n] = 0;
        byteStreamDataSource.readOffset = n2 - n5;
        if (byteStreamDataSource.readOffset > 0) {
            if (n5 > 0) {
                System.arraycopy(byArray, n5, byArray, 0, byteStreamDataSource.readOffset);
            }
            byteStreamDataSource.createReadBuffer();
        }
        return n == n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean normalizeLineBreaks(DataBuffer dataBuffer, int n, int n2, ByteStreamDataSource byteStreamDataSource) {
        byte[] byArray = dataBuffer.bytes;
        int n3 = dataBuffer.endOffset;
        boolean bl = byteStreamDataSource.isXML10;
        int n4 = n;
        byte by = byArray[n];
        while (true) {
            int n5;
            block12: {
                if (by >= 0) {
                    if (++n < n2) {
                        if ((by = byArray[n++]) != 10 && (bl || (by & 0xFF) != 133)) {
                            --n;
                        }
                        byArray[n4++] = 10;
                        break block12;
                    } else {
                        if (n <= n2 && byteStreamDataSource.stream == null) {
                            byArray[n4++] = 10;
                            break;
                        }
                        --n;
                        break;
                    }
                }
                n5 = by & 0xFF;
                if (!bl && n5 == 133) {
                    ++n;
                    byArray[n4++] = 10;
                } else {
                    if (n4 >= n) {
                        return this.normalizeLineBreaksDoubleBuffered(dataBuffer, n, n2, byteStreamDataSource);
                    }
                    ++n;
                    byArray[n4++] = (byte)(0xC0 | n5 >> 6);
                    byArray[n4++] = (byte)(0x80 | 0x3F & n5);
                }
            }
            if ((by = byArray[n]) < 0 || by == 13) continue;
            n5 = n++;
            while ((by = byArray[n]) >= 0 && by != 13) {
                ++n;
            }
            System.arraycopy(byArray, n5, byArray, n4, n - n5);
            n4 += n - n5;
        }
        byArray[n2] = 0;
        dataBuffer.endOffset = n4;
        if (n == n3) {
            byteStreamDataSource.readOffset = 0;
            return true;
        }
        if (n < n2) {
            byteStreamDataSource.readOffset = n2 - n;
            System.arraycopy(byArray, n, byteStreamDataSource.readBuffer, 0, byteStreamDataSource.readOffset);
            byteStreamDataSource.createReadBuffer();
            return true;
        }
        byteStreamDataSource.readOffset = 0;
        return false;
    }
}

