/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util.encoding;

import com.ibm.xml.xlxp2.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp2.api.util.encoding.CharacterStreamDataSource;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.IOException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class EncodingDeclReader {
    public static final int UNKNOWN = 0;
    public static final int UTF8N = 1;
    public static final int UTF16BE = 2;
    public static final int UTF16LE = 3;
    public static final int UTF32BE = 4;
    public static final int UTF32LE = 5;
    public static final int LATIN = 6;
    public static final int EBCDIC = 7;
    public static final int UCS2BE = 8;
    public static final int UCS2LE = 9;
    public static final int UCS4BE = 10;
    public static final int UCS4LE = 11;
    private ByteStreamDataSource fSource;
    private boolean fIsDocumentEntity;
    private int fBytesPerChar;
    private boolean fIsBigEndian;
    private static final int CODEPOINT_ILLEGAL = 0;
    private static final int CODEPOINT_WHITESPACE = 1;
    private static final int CODEPOINT_EQUALSIGN = 2;
    private static final int CODEPOINT_SINGLEQUOTE = 3;
    private static final int CODEPOINT_DOUBLEQUOTE = 4;
    private static final int CODEPOINT_LETTER = 5;
    private static final int CODEPOINT_DIGIT = 6;
    private static final int CODEPOINT_HYPHEN = 7;
    private static final int CODEPOINT_UNDERSCORE = 8;
    private static final int CODEPOINT_PERIOD = 9;
    private static final int CODEPOINT_LESSTHAN = 10;
    private static final int CODEPOINT_GREATERTHAN = 11;
    private static final int CODEPOINT_QUESTIONMARK = 12;
    private static final int LITERAL_STARTPIXML = 0;
    private static final int LITERAL_VERSION = 1;
    private static final int LITERAL_VERSION1X = 2;
    private static final int LITERAL_ENCODING = 3;
    private static final int LITERAL_STANDALONE = 4;
    private static final int LITERAL_YES = 5;
    private static final int LITERAL_NO = 6;
    private static final int LITERAL_ENDPI = 7;
    private static final int STATE_START = 0;
    private static final int STATE_VERSION = 1;
    private static final int STATE_ENCODING = 2;
    private static final int STATE_STANDALONE = 3;
    private static final int STATE_FINISHED = 4;
    private static final byte BAD = 0;
    private static final byte WSP = 1;
    private static final byte PER = 9;
    private static final byte LSS = 10;
    private static final byte HYP = 7;
    private static final byte USC = 8;
    private static final byte GTR = 11;
    private static final byte QST = 12;
    private static final byte SQT = 3;
    private static final byte EQL = 2;
    private static final byte DQT = 4;
    private static final byte LTR = 5;
    private static final byte DIG = 6;
    private static final byte[] fgCodePointMapEBCDIC = new byte[]{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 11, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 4, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 0, 0, 0, 0, 0};
    private static final char BAD_ = '\u0000';
    private static final char[] fgEncodingNameMapEBCDIC = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '.', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '-', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '_', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final int[] STARTPIXML_EBCDIC = new int[]{76, 111, 167, 148, 147};
    private static final int[] VERSION_EBCDIC = new int[]{165, 133, 153, 162, 137, 150, 149};
    private static final int[] VERSION1_EBCDIC = new int[]{241, 75};
    private static final int[] ENCODING_EBCDIC = new int[]{133, 149, 131, 150, 132, 137, 149, 135};
    private static final int[] STANDALONE_EBCDIC = new int[]{162, 163, 129, 149, 132, 129, 147, 150, 149, 133};
    private static final int[] YES_EBCDIC = new int[]{168, 133, 162};
    private static final int[] NO_EBCDIC = new int[]{149, 150};
    private static final int[] ENDPI_EBCDIC = new int[]{111, 110};
    private static final byte[] encNameCharMapLatin = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final int[] STARTPIXML_Latin = new int[]{60, 63, 120, 109, 108};
    private static final int[] VERSION_Latin = new int[]{118, 101, 114, 115, 105, 111, 110};
    private static final int[] VERSION1_Latin = new int[]{49, 46};
    private static final int[] ENCODING_Latin = new int[]{101, 110, 99, 111, 100, 105, 110, 103};
    private static final int[] STANDALONE_Latin = new int[]{115, 116, 97, 110, 100, 97, 108, 111, 110, 101};
    private static final int[] YES_Latin = new int[]{121, 101, 115};
    private static final int[] NO_Latin = new int[]{110, 111};

    public void setSource(ByteStreamDataSource byteStreamDataSource, boolean bl) {
        this.fSource = byteStreamDataSource;
        this.fIsDocumentEntity = bl;
    }

    public int readByte() throws IOException {
        return this.fSource.readByte();
    }

    public int detectEncoding() throws IOException {
        int n = this.readByte();
        switch (n) {
            case 60: {
                n = this.readByte();
                if (n == 63) {
                    n = this.readByte();
                    if (n != 120 || (n = this.readByte()) != 109) break;
                    this.fSource.rewind();
                    return 6;
                }
                if (n != 0) break;
                n = this.readByte();
                if (n == 63) {
                    n = this.readByte();
                    if (n != 0) break;
                    this.fSource.rewind();
                    return 9;
                }
                if (n != 0 || (n = this.readByte()) != 0) break;
                this.fSource.rewind();
                return 11;
            }
            case 239: {
                n = this.readByte();
                if (n != 187 || (n = this.readByte()) != 191) break;
                this.fSource.resetOffsets();
                return 1;
            }
            case 0: {
                n = this.readByte();
                if (n == 60) {
                    n = this.readByte();
                    if (n != 0 || (n = this.readByte()) != 63) break;
                    this.fSource.rewind();
                    return 8;
                }
                if (n != 0) break;
                n = this.readByte();
                if (n == 0) {
                    n = this.readByte();
                    if (n != 60) break;
                    this.fSource.rewind();
                    return 10;
                }
                if (n != 254 || (n = this.readByte()) != 255) break;
                this.fSource.resetOffsets();
                return 4;
            }
            case 254: {
                n = this.readByte();
                if (n != 255) break;
                this.fSource.resetOffsets();
                return 2;
            }
            case 255: {
                n = this.readByte();
                if (n != 254) break;
                this.fSource.resetOffsets();
                n = this.readByte();
                if (n == 0 && (n = this.readByte()) == 0) {
                    this.fSource.resetOffsets();
                    return 5;
                }
                this.fSource.rewind();
                return 3;
            }
            case 76: {
                n = this.readByte();
                if (n != 111 || (n = this.readByte()) != 167 || (n = this.readByte()) != 148) break;
                this.fSource.rewind();
                return 7;
            }
        }
        this.fSource.rewind();
        return 0;
    }

    public boolean getEBCDICEncoding() throws IOException {
        return this.readEBCDICEncodingDecl();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readEBCDICEncodingDecl() throws IOException {
        int n = 0;
        if (!this.skipEBCDICLiteral(0)) {
            return false;
        }
        this.skipEBCDICSpaces();
        do {
            if (!this.fIsDocumentEntity) {
                if (n == 0 && this.skipEBCDICLiteral(1)) {
                    n = 1;
                } else {
                    if (!this.skipEBCDICLiteral(3)) return false;
                    n = 2;
                }
            } else if (n == 0) {
                if (!this.skipEBCDICLiteral(1)) return false;
                n = 1;
            } else if (n != 1 || !this.skipEBCDICLiteral(3)) {
                if (!this.skipEBCDICLiteral(4)) break;
                n = 3;
            } else {
                n = 2;
            }
            this.skipEBCDICSpaces();
            if (!this.skipEBCDICCodePoint(2)) {
                return false;
            }
            this.skipEBCDICSpaces();
            boolean bl = this.skipEBCDICCodePoint(3);
            if (!bl && !this.skipEBCDICCodePoint(4)) {
                return false;
            }
            int n2 = bl ? 3 : 4;
            switch (n) {
                case 1: {
                    if (!this.skipEBCDICLiteral(2) || !this.skipEBCDICCodePoint(n2)) {
                        return false;
                    }
                    if (this.skipEBCDICSpaces()) break;
                    if (!this.fIsDocumentEntity) {
                        return false;
                    }
                    n = 4;
                    break;
                }
                case 2: {
                    if (!this.scanEBCDICEncodingName(n2)) {
                        return false;
                    }
                    if (!this.skipEBCDICSpaces()) {
                        n = 4;
                        break;
                    }
                    if (this.fIsDocumentEntity) break;
                    n = 4;
                    break;
                }
                case 3: {
                    if (!this.skipEBCDICLiteral(5) && !this.skipEBCDICLiteral(6) || !this.skipEBCDICCodePoint(n2)) {
                        return false;
                    }
                    this.skipEBCDICSpaces();
                    n = 4;
                }
            }
        } while (n != 4);
        if (this.skipEBCDICLiteral(7)) return this.fSource.saveEncodingChars();
        return false;
    }

    protected boolean skipEBCDICCodePoint(int n) throws IOException {
        int n2 = this.readByte();
        if (n2 == -1) {
            return false;
        }
        byte by = fgCodePointMapEBCDIC[n2];
        if (by != n) {
            this.fSource.unreadByte();
            return false;
        }
        return true;
    }

    protected boolean skipEBCDICLiteral(int n) throws IOException {
        int n2;
        int n3;
        int[] nArray;
        this.fSource.mark();
        switch (n) {
            case 0: {
                int n4;
                int[] nArray2 = STARTPIXML_EBCDIC;
                for (int i = 0; i < 5; ++i) {
                    n4 = this.readByte();
                    if (n4 == nArray2[i]) continue;
                    this.fSource.reset();
                    return false;
                }
                n4 = this.readByte();
                if (n4 == -1) {
                    this.fSource.reset();
                    return false;
                }
                byte by = fgCodePointMapEBCDIC[n4];
                if (by != 1) {
                    this.fSource.reset();
                    return false;
                }
                return true;
            }
            case 1: {
                nArray = VERSION_EBCDIC;
                n3 = 7;
                break;
            }
            case 2: {
                nArray = VERSION1_EBCDIC;
                n3 = 2;
                break;
            }
            case 3: {
                nArray = ENCODING_EBCDIC;
                n3 = 8;
                break;
            }
            case 4: {
                nArray = STANDALONE_EBCDIC;
                n3 = 10;
                break;
            }
            case 5: {
                nArray = YES_EBCDIC;
                n3 = 3;
                break;
            }
            case 6: {
                nArray = NO_EBCDIC;
                n3 = 2;
                break;
            }
            case 7: {
                nArray = ENDPI_EBCDIC;
                n3 = 2;
                break;
            }
            default: {
                return false;
            }
        }
        for (int i = 0; i < n3; ++i) {
            n2 = this.readByte();
            if (n2 == nArray[i]) continue;
            this.fSource.reset();
            return false;
        }
        if (n == 2) {
            n2 = this.readByte();
            if (n2 < 240 || n2 > 241) {
                this.fSource.reset();
                return false;
            }
            if (n2 == 241) {
                this.fSource.isXML10 = false;
            }
        }
        return true;
    }

    protected boolean skipEBCDICSpaces() throws IOException {
        boolean bl = false;
        while (this.skipEBCDICCodePoint(1)) {
            bl = true;
        }
        return bl;
    }

    protected boolean scanEBCDICEncodingName(int n) throws IOException {
        block7: {
            this.fSource.mark();
            int n2 = this.readByte();
            if (n2 == -1) {
                this.fSource.reset();
                return false;
            }
            byte by = fgCodePointMapEBCDIC[n2];
            if (by != 5) {
                this.fSource.reset();
                return false;
            }
            this.fSource.addEncodingChar(fgEncodingNameMapEBCDIC[n2]);
            block3: while (true) {
                if ((n2 = this.readByte()) == -1) {
                    this.fSource.reset();
                    return false;
                }
                by = fgCodePointMapEBCDIC[n2];
                if (by == n) break block7;
                switch (by) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        this.fSource.addEncodingChar(fgEncodingNameMapEBCDIC[n2]);
                        continue block3;
                    }
                }
                break;
            }
            this.fSource.reset();
            return false;
        }
        return true;
    }

    public boolean getLatinEncoding() throws IOException {
        return this.readLatinEncodingDecl();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readLatinEncodingDecl() throws IOException {
        int n = 0;
        int n2 = this.readByte();
        if (!this.skipLatinLiteral(n2, 0)) {
            return false;
        }
        n2 = this.skipLatinSpaces();
        do {
            boolean bl;
            if (!this.fIsDocumentEntity) {
                if (n == 0 && n2 == 118) {
                    if (!this.skipLatinLiteral(n2, 1)) return false;
                    n = 1;
                } else {
                    if (!this.skipLatinLiteral(n2, 3)) return false;
                    n = 2;
                }
            } else if (n == 0) {
                if (!this.skipLatinLiteral(n2, 1)) return false;
                n = 1;
            } else if (n == 1 && n2 == 101) {
                if (!this.skipLatinLiteral(n2, 3)) return false;
                n = 2;
            } else {
                if (n2 != 115) break;
                if (!this.skipLatinLiteral(n2, 4)) return false;
                n = 3;
            }
            n2 = this.skipLatinSpaces();
            if (n2 != 61) {
                return false;
            }
            n2 = this.skipLatinSpaces();
            boolean bl2 = bl = n2 == 34;
            if (!bl && n2 != 39) {
                return false;
            }
            int n3 = n2;
            n2 = this.readByte();
            switch (n) {
                case 1: {
                    if (!this.skipLatinLiteral(n2, 2) || this.readByte() != n3) {
                        return false;
                    }
                    n2 = this.readByte();
                    if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) {
                        n2 = this.skipLatinSpaces();
                        break;
                    }
                    if (!this.fIsDocumentEntity) {
                        return false;
                    }
                    n = 4;
                    break;
                }
                case 2: {
                    if (!this.scanLatinEncodingName(n2, n3)) {
                        return false;
                    }
                    n2 = this.readByte();
                    if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) {
                        n2 = this.skipLatinSpaces();
                        if (this.fIsDocumentEntity) break;
                        n = 4;
                        break;
                    }
                    n = 4;
                    break;
                }
                case 3: {
                    if (n2 == 121 ? !this.skipLatinLiteral(n2, 5) || this.readByte() != n3 : !this.skipLatinLiteral(n2, 6) || this.readByte() != n3) {
                        return false;
                    }
                    n2 = this.skipLatinSpaces();
                    n = 4;
                }
            }
        } while (n != 4);
        if (n2 == 63 && this.readByte() == 62) return this.fSource.saveEncodingChars();
        return false;
    }

    private boolean skipLatinLiteral(int n, int n2) throws IOException {
        int n3;
        int n4;
        int[] nArray;
        switch (n2) {
            case 0: {
                nArray = STARTPIXML_Latin;
                n4 = 5;
                break;
            }
            case 1: {
                nArray = VERSION_Latin;
                n4 = 7;
                break;
            }
            case 2: {
                nArray = VERSION1_Latin;
                n4 = 2;
                break;
            }
            case 3: {
                nArray = ENCODING_Latin;
                n4 = 8;
                break;
            }
            case 4: {
                nArray = STANDALONE_Latin;
                n4 = 10;
                break;
            }
            case 5: {
                nArray = YES_Latin;
                n4 = 3;
                break;
            }
            case 6: {
                nArray = NO_Latin;
                n4 = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (n != nArray[0]) {
            return false;
        }
        for (int i = 1; i < n4; ++i) {
            n3 = this.readByte();
            if (n3 == nArray[i]) continue;
            return false;
        }
        if (n2 == 0) {
            n3 = this.readByte();
            if (n3 != 32 && n3 != 10 && n3 != 9 && n3 != 13) {
                return false;
            }
        } else if (n2 == 2) {
            n3 = this.readByte();
            if (n3 < 48 || n3 > 49) {
                return false;
            }
            if (n3 == 49) {
                this.fSource.isXML10 = false;
            }
        }
        return true;
    }

    private int skipLatinSpaces() throws IOException {
        int n;
        while ((n = this.readByte()) == 32 || n == 10 || n == 9 || n == 13) {
        }
        return n;
    }

    private boolean scanLatinEncodingName(int n, int n2) throws IOException {
        block3: {
            int n3 = n;
            if (n3 == -1) {
                return false;
            }
            if (n3 >= 128 || encNameCharMapLatin[n3] != 1) {
                return false;
            }
            do {
                this.fSource.addEncodingChar((char)n3);
                n3 = this.readByte();
                if (n3 == n2) break block3;
                if (n3 != -1) continue;
                return false;
            } while (n3 < 128 && encNameCharMapLatin[n3] != 0);
            return false;
        }
        return true;
    }

    public boolean getUCSEncoding(int n, boolean bl) throws IOException {
        this.fBytesPerChar = n;
        this.fIsBigEndian = bl;
        return this.readUCSEncodingDecl();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readUCSEncodingDecl() throws IOException {
        int n = 0;
        int n2 = this.readUCSChar();
        if (!this.skipUCSLiteral(n2, 0)) {
            return false;
        }
        n2 = this.skipUCSSpaces();
        do {
            boolean bl;
            if (!this.fIsDocumentEntity) {
                if (n == 0 && n2 == 118) {
                    if (!this.skipUCSLiteral(n2, 1)) return false;
                    n = 1;
                } else {
                    if (!this.skipUCSLiteral(n2, 3)) return false;
                    n = 2;
                }
            } else if (n == 0) {
                if (!this.skipUCSLiteral(n2, 1)) return false;
                n = 1;
            } else if (n == 1 && n2 == 101) {
                if (!this.skipUCSLiteral(n2, 3)) return false;
                n = 2;
            } else {
                if (n2 != 115) break;
                if (!this.skipUCSLiteral(n2, 4)) return false;
                n = 3;
            }
            n2 = this.skipUCSSpaces();
            if (n2 != 61) {
                return false;
            }
            n2 = this.skipUCSSpaces();
            boolean bl2 = bl = n2 == 34;
            if (!bl && n2 != 39) {
                return false;
            }
            int n3 = n2;
            n2 = this.readUCSChar();
            switch (n) {
                case 1: {
                    if (!this.skipUCSLiteral(n2, 2) || this.readUCSChar() != n3) {
                        return false;
                    }
                    n2 = this.readUCSChar();
                    if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) {
                        n2 = this.skipUCSSpaces();
                        break;
                    }
                    if (!this.fIsDocumentEntity) {
                        return false;
                    }
                    n = 4;
                    break;
                }
                case 2: {
                    if (!this.scanUCSEncodingName(n2, n3)) {
                        return false;
                    }
                    n2 = this.readUCSChar();
                    if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) {
                        n2 = this.skipUCSSpaces();
                        if (this.fIsDocumentEntity) break;
                        n = 4;
                        break;
                    }
                    n = 4;
                    break;
                }
                case 3: {
                    if (n2 == 121 ? !this.skipUCSLiteral(n2, 5) || this.readUCSChar() != n3 : !this.skipUCSLiteral(n2, 6) || this.readUCSChar() != n3) {
                        return false;
                    }
                    n2 = this.skipUCSSpaces();
                    n = 4;
                }
            }
        } while (n != 4);
        if (n2 == 63 && this.readUCSChar() == 62) return this.fSource.saveEncodingChars();
        return false;
    }

    private int readUCSChar() throws IOException {
        int n = this.readByte();
        if (n == -1) {
            return -1;
        }
        int n2 = this.readByte();
        if (n2 == -1) {
            return -1;
        }
        if (this.fBytesPerChar == 2) {
            if (this.fIsBigEndian) {
                return (n << 8) + n2;
            }
            return (n2 << 8) + n;
        }
        int n3 = this.readByte();
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.readByte();
        if (n4 == -1) {
            return -1;
        }
        if (this.fIsBigEndian) {
            return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    private boolean skipUCSLiteral(int n, int n2) throws IOException {
        int n3;
        int n4;
        int[] nArray;
        switch (n2) {
            case 0: {
                nArray = STARTPIXML_Latin;
                n4 = 5;
                break;
            }
            case 1: {
                nArray = VERSION_Latin;
                n4 = 7;
                break;
            }
            case 2: {
                nArray = VERSION1_Latin;
                n4 = 2;
                break;
            }
            case 3: {
                nArray = ENCODING_Latin;
                n4 = 8;
                break;
            }
            case 4: {
                nArray = STANDALONE_Latin;
                n4 = 10;
                break;
            }
            case 5: {
                nArray = YES_Latin;
                n4 = 3;
                break;
            }
            case 6: {
                nArray = NO_Latin;
                n4 = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (n != nArray[0]) {
            return false;
        }
        for (int i = 1; i < n4; ++i) {
            n3 = this.readUCSChar();
            if (n3 == nArray[i]) continue;
            return false;
        }
        if (n2 == 0) {
            n3 = this.readUCSChar();
            if (n3 != 32 && n3 != 10 && n3 != 9 && n3 != 13) {
                return false;
            }
        } else if (n2 == 2) {
            n3 = this.readUCSChar();
            if (n3 < 48 || n3 > 49) {
                return false;
            }
            if (n3 == 49) {
                this.fSource.isXML10 = false;
            }
        }
        return true;
    }

    private int skipUCSSpaces() throws IOException {
        int n;
        while ((n = this.readUCSChar()) == 32 || n == 10 || n == 9 || n == 13) {
        }
        return n;
    }

    private boolean scanUCSEncodingName(int n, int n2) throws IOException {
        block3: {
            int n3 = n;
            if (n3 == -1) {
                return false;
            }
            if (n3 >= 128 || encNameCharMapLatin[n3] != 1) {
                return false;
            }
            do {
                this.fSource.addEncodingChar((char)n3);
                n3 = this.readUCSChar();
                if (n3 == n2) break block3;
                if (n3 != -1) continue;
                return false;
            } while (n3 < 128 && encNameCharMapLatin[n3] != 0);
            return false;
        }
        return true;
    }

    public boolean getVersionNumber(CharacterStreamDataSource characterStreamDataSource, boolean bl) throws IOException {
        this.fIsDocumentEntity = bl;
        return this.readCharStreamVersionInfo(characterStreamDataSource);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readCharStreamVersionInfo(CharacterStreamDataSource characterStreamDataSource) throws IOException {
        int n = 0;
        int n2 = characterStreamDataSource.readChar();
        if (!this.skipCharStreamLiteral(characterStreamDataSource, n2, 0)) {
            return false;
        }
        n2 = this.skipCharStreamSpaces(characterStreamDataSource);
        do {
            boolean bl;
            if (!this.fIsDocumentEntity) {
                if (n == 0 && n2 == 118) {
                    if (!this.skipCharStreamLiteral(characterStreamDataSource, n2, 1)) return false;
                    n = 1;
                } else {
                    if (!this.skipCharStreamLiteral(characterStreamDataSource, n2, 3)) return false;
                    n = 2;
                }
            } else if (n == 0) {
                if (!this.skipCharStreamLiteral(characterStreamDataSource, n2, 1)) return false;
                n = 1;
            } else if (n == 1 && n2 == 101) {
                if (!this.skipCharStreamLiteral(characterStreamDataSource, n2, 3)) return false;
                n = 2;
            } else {
                if (n2 != 115) return n2 == 63 && characterStreamDataSource.readChar() == 62;
                if (!this.skipCharStreamLiteral(characterStreamDataSource, n2, 4)) return false;
                n = 3;
            }
            n2 = this.skipCharStreamSpaces(characterStreamDataSource);
            if (n2 != 61) {
                return false;
            }
            n2 = this.skipCharStreamSpaces(characterStreamDataSource);
            boolean bl2 = bl = n2 == 34;
            if (!bl && n2 != 39) {
                return false;
            }
            int n3 = n2;
            n2 = characterStreamDataSource.readChar();
            switch (n) {
                case 1: {
                    if (!this.skipCharStreamLiteral(characterStreamDataSource, n2, 2) || characterStreamDataSource.readChar() != n3) {
                        return false;
                    }
                    n2 = characterStreamDataSource.readChar();
                    if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) {
                        n2 = this.skipCharStreamSpaces(characterStreamDataSource);
                        break;
                    }
                    if (!this.fIsDocumentEntity) {
                        return false;
                    }
                    n = 4;
                    break;
                }
                case 2: {
                    if (!this.skipCharStreamEncodingName(characterStreamDataSource, n2, n3)) {
                        return false;
                    }
                    n2 = characterStreamDataSource.readChar();
                    if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) {
                        n2 = this.skipCharStreamSpaces(characterStreamDataSource);
                        if (this.fIsDocumentEntity) break;
                        n = 4;
                        break;
                    }
                    n = 4;
                    break;
                }
                case 3: {
                    if (n2 == 121 ? !this.skipCharStreamLiteral(characterStreamDataSource, n2, 5) || characterStreamDataSource.readChar() != n3 : !this.skipCharStreamLiteral(characterStreamDataSource, n2, 6) || characterStreamDataSource.readChar() != n3) {
                        return false;
                    }
                    n2 = this.skipCharStreamSpaces(characterStreamDataSource);
                    n = 4;
                }
            }
        } while (n != 4);
        return n2 == 63 && characterStreamDataSource.readChar() == 62;
    }

    private boolean skipCharStreamLiteral(CharacterStreamDataSource characterStreamDataSource, int n, int n2) throws IOException {
        int n3;
        int n4;
        int[] nArray;
        switch (n2) {
            case 0: {
                nArray = STARTPIXML_Latin;
                n4 = 5;
                break;
            }
            case 1: {
                nArray = VERSION_Latin;
                n4 = 7;
                break;
            }
            case 2: {
                nArray = VERSION1_Latin;
                n4 = 2;
                break;
            }
            case 3: {
                nArray = ENCODING_Latin;
                n4 = 8;
                break;
            }
            case 4: {
                nArray = STANDALONE_Latin;
                n4 = 10;
                break;
            }
            case 5: {
                nArray = YES_Latin;
                n4 = 3;
                break;
            }
            case 6: {
                nArray = NO_Latin;
                n4 = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (n != nArray[0]) {
            return false;
        }
        for (int i = 1; i < n4; ++i) {
            n3 = characterStreamDataSource.readChar();
            if (n3 == nArray[i]) continue;
            return false;
        }
        if (n2 == 0) {
            n3 = characterStreamDataSource.readChar();
            if (n3 != 32 && n3 != 10 && n3 != 9 && n3 != 13) {
                return false;
            }
        } else if (n2 == 2) {
            n3 = characterStreamDataSource.readChar();
            if (n3 < 48 || n3 > 49) {
                return false;
            }
            if (n3 == 49) {
                characterStreamDataSource.isXML10 = false;
            }
        }
        return true;
    }

    private int skipCharStreamSpaces(CharacterStreamDataSource characterStreamDataSource) throws IOException {
        int n;
        while ((n = characterStreamDataSource.readChar()) == 32 || n == 10 || n == 9 || n == 13) {
        }
        return n;
    }

    private boolean skipCharStreamEncodingName(CharacterStreamDataSource characterStreamDataSource, int n, int n2) throws IOException {
        int n3 = n;
        if (n3 == -1) {
            return false;
        }
        if (n3 >= 128 || encNameCharMapLatin[n3] != 1) {
            return false;
        }
        while ((n3 = characterStreamDataSource.readChar()) != n2) {
            if (n3 == -1) {
                return false;
            }
            if (n3 < 128 && encNameCharMapLatin[n3] != 0) continue;
            return false;
        }
        return true;
    }
}

