/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util.encoding;

import com.ibm.xml.xlxp2.api.util.DataBufferHelper;
import com.ibm.xml.xlxp2.api.util.encoding.CharacterStreamDataSource;
import com.ibm.xml.xlxp2.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp2.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp2.api.util.encoding.RewindableInputStream;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp2.scan.util.DataSource;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2013. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ByteStreamDataSource
implements DataSource {
    public int bufferLength;
    public InputStream stream;
    public byte[] readBuffer;
    public int readOffset;
    public int readLength;
    public boolean normalizeLineBreaks;
    public boolean isXML10;
    public int bufferLoadFactor;
    private static final boolean CLEAR_TO_END_OF_BUFFER = false;
    private ByteStreamDataSource fNextFreeDataSource;
    private final DataSourceFactory fSourceFactory;
    private final DataBufferFactory fBufferFactory;
    private final DataBufferReferrer fBufferReferrer;
    private EncodingSupport fEncodingSupport;
    private String fEncodingName;
    private char[] fEncodingBuffer;
    private int fEncodingLength;
    protected DataBuffer fReadDataBuffer;
    private int fReadMark;
    private int fReadLimit;

    public ByteStreamDataSource(DataSourceFactory dataSourceFactory, DataBufferFactory dataBufferFactory, int n, int n2) {
        this.fSourceFactory = dataSourceFactory;
        this.fBufferFactory = dataBufferFactory;
        this.fBufferReferrer = new DataBufferReferrer(){

            public boolean hasReferenceTo(DataBuffer dataBuffer) {
                return dataBuffer == ByteStreamDataSource.this.fReadDataBuffer;
            }

            public void removeReferencesAndUnregister() {
                ByteStreamDataSource.this.fBufferFactory.removeReferrer(this);
                ByteStreamDataSource.this.fReadDataBuffer = null;
            }
        };
        this.bufferLength = n;
        this.readLength = n;
        this.readBuffer = ArrayAllocator.newByteArray(this.readLength + 1);
        this.bufferLoadFactor = n2;
        this.fEncodingBuffer = ArrayAllocator.newCharArray(64);
        this.fBufferFactory.addReferrer(this.fBufferReferrer);
    }

    public void setNextFreeDataSource(ByteStreamDataSource byteStreamDataSource) {
        this.fNextFreeDataSource = byteStreamDataSource;
    }

    public ByteStreamDataSource getNextFreeDataSource() {
        return this.fNextFreeDataSource;
    }

    public void setByteStream(InputStream inputStream, String string) {
        this.stream = inputStream;
        this.fEncodingName = string;
        this.isXML10 = true;
        this.fReadLimit = 0;
        this.readOffset = 0;
        this.fReadMark = 0;
        this.fReadDataBuffer = null;
        this.fEncodingLength = 0;
    }

    public void addEncodingChar(char c) {
        if (this.fEncodingLength == this.fEncodingBuffer.length) {
            this.fEncodingBuffer = ArrayAllocator.resizeCharArray(this.fEncodingBuffer, this.fEncodingLength << 1);
        }
        this.fEncodingBuffer[this.fEncodingLength++] = c;
    }

    public boolean saveEncodingChars() {
        if (this.fEncodingLength > 0) {
            if (this.fEncodingName == null) {
                this.fEncodingName = new String(this.fEncodingBuffer, 0, this.fEncodingLength);
            }
            return true;
        }
        return false;
    }

    public void setEncodingName(String string) {
        this.fEncodingName = string;
    }

    public String getEncodingName() {
        return this.fEncodingName;
    }

    public void setEncodingSupport(EncodingSupport encodingSupport) {
        this.fEncodingSupport = encodingSupport;
        this.readOffset = this.fReadLimit;
        this.fReadLimit = 0;
    }

    public void createReadBuffer() {
        DataBuffer dataBuffer = this.fBufferFactory.createBuffer(this.bufferLength + 1);
        byte[] byArray = dataBuffer.bytes;
        dataBuffer.bytes = this.readBuffer;
        dataBuffer.startOffset = 0;
        dataBuffer.endOffset = this.readLength;
        this.fReadDataBuffer = dataBuffer;
        this.readLength = byArray.length - 1;
        this.readBuffer = byArray;
        this.fBufferReferrer.active = true;
    }

    public void resetOffsets() {
        this.fReadLimit -= this.readOffset;
        System.arraycopy(this.readBuffer, this.readOffset, this.readBuffer, 0, this.fReadLimit);
        this.readOffset = 0;
    }

    public void mark() {
        this.fReadMark = this.readOffset;
    }

    public void reset() {
        this.readOffset = this.fReadMark;
    }

    public void rewind() {
        this.readOffset = 0;
        this.fReadMark = 0;
    }

    public void unreadByte() {
        --this.readOffset;
    }

    public int readMoreBytes() throws IOException {
        int n;
        int n2 = this.readLength;
        if (this.readOffset == n2) {
            this.readLength <<= 1;
            this.readBuffer = ArrayAllocator.resizeByteArray(this.readBuffer, this.readLength + 1);
            n2 = this.readLength;
        }
        if ((n = this.stream.read(this.readBuffer, this.readOffset, n2 - this.readOffset)) == -1) {
            this.stream.close();
            this.stream = null;
            return -1;
        }
        this.fReadLimit += n;
        return this.readBuffer[this.readOffset++] & 0xFF;
    }

    public int readByte() throws IOException {
        if (this.readOffset < this.fReadLimit) {
            return this.readBuffer[this.readOffset++] & 0xFF;
        }
        return this.readMoreBytes();
    }

    public CharConversionError load(ParsedEntity parsedEntity) {
        DataBuffer dataBuffer;
        if (this.fReadDataBuffer != null) {
            dataBuffer = this.fReadDataBuffer;
            this.fReadDataBuffer = null;
            this.fBufferReferrer.active = false;
        } else {
            dataBuffer = this.fBufferFactory.createBuffer(this.bufferLength + 1);
            dataBuffer.endOffset = this.bufferLength;
        }
        parsedEntity.error = this.fEncodingSupport.load(this, dataBuffer);
        int n = dataBuffer.endOffset;
        dataBuffer.bytes[n] = 0;
        dataBuffer.startOffset = 0;
        if (parsedEntity.isCoordinatesAware) {
            if (parsedEntity.buffer != null) {
                if (parsedEntity.isXML10) {
                    DataBufferHelper.computeCoords10(parsedEntity.buffer, dataBuffer);
                } else {
                    DataBufferHelper.computeCoords11(parsedEntity.buffer, dataBuffer);
                }
                dataBuffer.byteOffset = parsedEntity.buffer.byteOffset + parsedEntity.buffer.endOffset - parsedEntity.buffer.startOffset;
            } else {
                dataBuffer.byteOffset = 0;
            }
        }
        if (this.stream == null && this.readOffset == 0) {
            parsedEntity.setValues(dataBuffer, 0, n, null);
            this.release();
        } else {
            parsedEntity.setValues(dataBuffer, 0, n, this);
        }
        return parsedEntity.error;
    }

    public void release() {
        if (this.stream != null) {
            try {
                this.stream.close();
                this.stream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.readOffset = 0;
        this.fEncodingName = null;
        this.fSourceFactory.releaseByteStreamDataSource(this);
    }

    public CharConversionError convertToCharacterStream(ParsedEntity parsedEntity) {
        try {
            RewindableInputStream rewindableInputStream = new RewindableInputStream();
            rewindableInputStream.setStream(this.stream, this.readBuffer, this.fReadLimit);
            this.stream = null;
            this.fReadLimit = 0;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)rewindableInputStream, this.getEncodingName());
            CharacterStreamDataSource characterStreamDataSource = this.fSourceFactory.allocateCharacterStreamDataSource();
            characterStreamDataSource.setCharacterStream(inputStreamReader);
            characterStreamDataSource.isXML10 = this.isXML10;
            return characterStreamDataSource.load(parsedEntity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            parsedEntity.error = CharConversionError.runtimeIOError(unsupportedEncodingException);
            return parsedEntity.error;
        }
    }
}

