/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax;

import com.ibm.xml.xlxp2.api.stax.DOMStreamWriterImpl;
import com.ibm.xml.xlxp2.api.stax.SAXStreamWriterImpl;
import com.ibm.xml.xlxp2.api.stax.StAXLogger;
import com.ibm.xml.xlxp2.api.stax.XMLEventWriterImpl;
import com.ibm.xml.xlxp2.api.stax.XMLStreamWriterImpl;
import com.ibm.xml.xlxp2.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp2.api.util.Pool;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XMLOutputFactoryImpl
extends XMLOutputFactory {
    protected static final ClosedXMLStreamWriter fgClosedStreamWriter = new ClosedXMLStreamWriter();
    protected static final EndDocumentXMLStreamWriter fgEndDocumentStreamWriter = new EndDocumentXMLStreamWriter();
    protected static final boolean ENABLE_LOGGING = false;
    protected boolean fIsRepairingNamespaces = false;
    protected boolean fRecycleWritersOnEndDocument = false;
    private static final Pool fStreamWriters = new Pool();
    private static final Pool fDOMWriters = new Pool();
    private static final Pool fSAXWriters = new Pool();

    protected XMLStreamWriter createProxyFor(XMLStreamWriter xMLStreamWriter) {
        return new XMLStreamWriterProxy(xMLStreamWriter, this.fRecycleWritersOnEndDocument);
    }

    private XMLStreamWriter createXMLStreamWriterInternal(Writer writer) throws XMLStreamException {
        XMLStreamWriterImpl xMLStreamWriterImpl = this.getXMLStreamWriterImpl();
        xMLStreamWriterImpl.setWriter(writer, this.fIsRepairingNamespaces);
        return xMLStreamWriterImpl;
    }

    private XMLStreamWriter createXMLStreamWriterInternal(OutputStream outputStream) throws XMLStreamException {
        XMLStreamWriterImpl xMLStreamWriterImpl = this.getXMLStreamWriterImpl();
        xMLStreamWriterImpl.setOutputStream(outputStream, this.fIsRepairingNamespaces);
        return xMLStreamWriterImpl;
    }

    private XMLStreamWriter createXMLStreamWriterInternal(OutputStream outputStream, String string) throws XMLStreamException {
        XMLStreamWriterImpl xMLStreamWriterImpl = this.getXMLStreamWriterImpl();
        xMLStreamWriterImpl.setOutputStream(outputStream, string, this.fIsRepairingNamespaces);
        return xMLStreamWriterImpl;
    }

    private XMLStreamWriter createXMLStreamWriterInternal(Result result) throws XMLStreamException {
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            if (streamResult.getWriter() != null) {
                return this.createXMLStreamWriterInternal(streamResult.getWriter());
            }
            return this.createXMLStreamWriterInternal(streamResult.getOutputStream());
        }
        if (result instanceof DOMResult) {
            DOMResult dOMResult = (DOMResult)result;
            return this.createXMLStreamWriterInternal(dOMResult.getNode(), dOMResult.getNextSibling());
        }
        if (result instanceof SAXResult) {
            SAXResult sAXResult = (SAXResult)result;
            return this.createXMLStreamWriterInternal(sAXResult.getHandler(), sAXResult.getLexicalHandler());
        }
        StAXMessageProvider.throwUnsupportedOperationException(StAXMessageProvider.createMessage(null, 1, "createXMLStreamWriter(Result)"));
        return null;
    }

    private XMLStreamWriter createXMLStreamWriterInternal(Node node, Node node2) throws XMLStreamException {
        DOMStreamWriterImpl dOMStreamWriterImpl = (DOMStreamWriterImpl)fDOMWriters.get();
        if (dOMStreamWriterImpl == null) {
            dOMStreamWriterImpl = new DOMStreamWriterImpl(node, node2, this.fIsRepairingNamespaces);
            fDOMWriters.assignToPool(dOMStreamWriterImpl);
        } else {
            try {
                dOMStreamWriterImpl.setNodes(node, node2, this.fIsRepairingNamespaces);
            }
            catch (XMLStreamException xMLStreamException) {
                dOMStreamWriterImpl.close();
                throw xMLStreamException;
            }
        }
        return dOMStreamWriterImpl;
    }

    private XMLStreamWriter createXMLStreamWriterInternal(ContentHandler contentHandler, LexicalHandler lexicalHandler) throws XMLStreamException {
        SAXStreamWriterImpl sAXStreamWriterImpl = (SAXStreamWriterImpl)fSAXWriters.get();
        if (sAXStreamWriterImpl == null) {
            sAXStreamWriterImpl = new SAXStreamWriterImpl(contentHandler, lexicalHandler, this.fIsRepairingNamespaces);
            fSAXWriters.assignToPool(sAXStreamWriterImpl);
        } else {
            sAXStreamWriterImpl.setHandlers(contentHandler, lexicalHandler, this.fIsRepairingNamespaces);
        }
        return sAXStreamWriterImpl;
    }

    private XMLStreamWriterImpl getXMLStreamWriterImpl() throws XMLStreamException {
        XMLStreamWriterImpl xMLStreamWriterImpl = (XMLStreamWriterImpl)fStreamWriters.get();
        if (xMLStreamWriterImpl == null) {
            try {
                xMLStreamWriterImpl = new XMLStreamWriterImpl(this.fIsRepairingNamespaces);
                fStreamWriters.assignToPool(xMLStreamWriterImpl);
            }
            catch (Exception exception) {
                StAXMessageProvider.throwXMLStreamException(exception);
            }
        } else {
            xMLStreamWriterImpl.reset(this.fIsRepairingNamespaces);
        }
        return xMLStreamWriterImpl;
    }

    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamWriterInternal(writer));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamWriterInternal(outputStream));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String string) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamWriterInternal(outputStream, string));
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.createProxyFor(this.createXMLStreamWriterInternal(result));
    }

    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriterInternal(result));
    }

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriterInternal(outputStream));
    }

    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String string) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriterInternal(outputStream, string));
    }

    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return this.createXMLEventWriter(this.createXMLStreamWriterInternal(writer));
    }

    public void setProperty(String string, Object object) throws IllegalArgumentException {
        if (string == null) {
            StAXMessageProvider.throwNullPointerException(StAXMessageProvider.createMessage(null, 31));
        }
        if ("javax.xml.stream.isRepairingNamespaces".equals(string)) {
            if (object instanceof Boolean) {
                this.fIsRepairingNamespaces = (Boolean)object;
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 8, object, "javax.xml.stream.isRepairingNamespaces", "Boolean"));
            }
        } else if ("javax.xml.stream.XMLOutputFactory.recycleWritersOnEndDocument".equals(string)) {
            if (object instanceof Boolean) {
                this.fRecycleWritersOnEndDocument = (Boolean)object;
            } else {
                StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 8, object, "javax.xml.stream.XMLOutputFactory.recycleWritersOnEndDocument", "Boolean"));
            }
        } else {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 6, string));
        }
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if ("javax.xml.stream.isRepairingNamespaces".equals(string)) {
            return this.fIsRepairingNamespaces ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.XMLOutputFactory.recycleWritersOnEndDocument".equals(string)) {
            return this.fRecycleWritersOnEndDocument ? Boolean.TRUE : Boolean.FALSE;
        }
        StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 6, string));
        return null;
    }

    public boolean isPropertySupported(String string) {
        if ("javax.xml.stream.isRepairingNamespaces".equals(string)) {
            return true;
        }
        return "javax.xml.stream.XMLOutputFactory.recycleWritersOnEndDocument".equals(string);
    }

    protected XMLEventWriter createXMLEventWriter(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        try {
            return new XMLEventWriterImpl(this, xMLStreamWriter);
        }
        catch (Exception exception) {
            StAXMessageProvider.throwXMLStreamException(exception);
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class XMLStreamWriterTracer
    extends XMLStreamWriterProxy {
        StAXLogger fLogger = new StAXLogger();

        public XMLStreamWriterTracer(XMLStreamWriter xMLStreamWriter, boolean bl) {
            super(xMLStreamWriter, bl);
        }

        public void writeStAXProfile(String string) {
            this.fLogger.writeStAXProfile(string);
        }

        public void writeReadableProfile(String string) {
            this.fLogger.writeReadableProfile(string);
        }

        public void writeStartElement(String string) throws XMLStreamException {
            this.fLogger.log(101, string);
            try {
                super.writeStartElement(string);
            }
            catch (XMLStreamException xMLStreamException) {
                this.fLogger.logException(xMLStreamException);
                throw xMLStreamException;
            }
            catch (RuntimeException runtimeException) {
                this.fLogger.logException(runtimeException);
                throw runtimeException;
            }
            this.fLogger.logReturn();
        }

        public void writeStartElement(String string, String string2) throws XMLStreamException {
            this.fLogger.log(101, string, string2);
            try {
                super.writeStartElement(string, string2);
            }
            catch (XMLStreamException xMLStreamException) {
                this.fLogger.logException(xMLStreamException);
                throw xMLStreamException;
            }
            catch (RuntimeException runtimeException) {
                this.fLogger.logException(runtimeException);
                throw runtimeException;
            }
            this.fLogger.logReturn();
        }

        public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
            this.fLogger.log(101, string, string2, string3);
            try {
                super.writeStartElement(string, string2, string3);
            }
            catch (XMLStreamException xMLStreamException) {
                this.fLogger.logException(xMLStreamException);
                throw xMLStreamException;
            }
            catch (RuntimeException runtimeException) {
                this.fLogger.logException(runtimeException);
                throw runtimeException;
            }
            this.fLogger.logReturn();
        }

        public void writeEmptyElement(String string, String string2) throws XMLStreamException {
            this.fLogger.log(102, string, string2);
            super.writeEmptyElement(string, string2);
            this.fLogger.logReturn();
        }

        public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
            this.fLogger.log(102, string, string2, string3);
            super.writeEmptyElement(string, string2, string3);
            this.fLogger.logReturn();
        }

        public void writeEmptyElement(String string) throws XMLStreamException {
            this.fLogger.log(102, string);
            super.writeEmptyElement(string);
            this.fLogger.logReturn();
        }

        public void writeEndElement() throws XMLStreamException {
            this.fLogger.log(103);
            super.writeEndElement();
            this.fLogger.logReturn();
        }

        public void writeEndDocument() throws XMLStreamException {
            this.fLogger.log(105);
            super.writeEndDocument();
            this.fLogger.logReturn();
        }

        public void close() throws XMLStreamException {
            this.fLogger.log(6);
            super.close();
            this.fLogger.logReturn();
        }

        public void flush() throws XMLStreamException {
            this.fLogger.log(115);
            super.flush();
            this.fLogger.logReturn();
        }

        public void writeAttribute(String string, String string2) throws XMLStreamException {
            this.fLogger.log(106, string, string2);
            super.writeAttribute(string, string2);
            this.fLogger.logReturn();
        }

        public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
            this.fLogger.log(106, new Object[]{string, string2, string3, string4});
            super.writeAttribute(string, string2, string3, string4);
            this.fLogger.logReturn();
        }

        public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
            this.fLogger.log(106, string, string2, string3);
            super.writeAttribute(string, string2, string3);
            this.fLogger.logReturn();
        }

        public void writeNamespace(String string, String string2) throws XMLStreamException {
            this.fLogger.log(107, string, string2);
            super.writeNamespace(string, string2);
            this.fLogger.logReturn();
        }

        public void writeDefaultNamespace(String string) throws XMLStreamException {
            this.fLogger.log(108, string);
            super.writeDefaultNamespace(string);
            this.fLogger.logReturn();
        }

        public void writeComment(String string) throws XMLStreamException {
            this.fLogger.log(111, string);
            super.writeComment(string);
            this.fLogger.logReturn();
        }

        public void writeProcessingInstruction(String string) throws XMLStreamException {
            this.fLogger.log(109, string);
            super.writeProcessingInstruction(string);
            this.fLogger.logReturn();
        }

        public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
            this.fLogger.log(109, string, string2);
            super.writeProcessingInstruction(string, string2);
            this.fLogger.logReturn();
        }

        public void writeCData(String string) throws XMLStreamException {
            this.fLogger.log(110, string);
            super.writeCData(string);
            this.fLogger.logReturn();
        }

        public void writeDTD(String string) throws XMLStreamException {
            this.fLogger.log(112, string);
            super.writeDTD(string);
            this.fLogger.logReturn();
        }

        public void writeEntityRef(String string) throws XMLStreamException {
            this.fLogger.log(113, string);
            super.writeEntityRef(string);
            this.fLogger.logReturn();
        }

        public void writeStartDocument() throws XMLStreamException {
            this.fLogger.log(104);
            super.writeStartDocument();
            this.fLogger.logReturn();
        }

        public void writeStartDocument(String string) throws XMLStreamException {
            this.fLogger.log(104, string);
            super.writeStartDocument(string);
            this.fLogger.logReturn();
        }

        public void writeStartDocument(String string, String string2) throws XMLStreamException {
            this.fLogger.log(104, string, string2);
            super.writeStartDocument(string, string2);
            this.fLogger.logReturn();
        }

        public void writeCharacters(String string) throws XMLStreamException {
            this.fLogger.log(114, string);
            super.writeCharacters(string);
            this.fLogger.logReturn();
        }

        public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
            this.fLogger.log(114, new Object[]{cArray, n, n2});
            super.writeCharacters(cArray, n, n2);
            this.fLogger.logReturn();
        }

        public String getPrefix(String string) throws XMLStreamException {
            this.fLogger.log(38, string);
            String string2 = super.getPrefix(string);
            this.fLogger.logReturn(string2);
            return string2;
        }

        public void setPrefix(String string, String string2) throws XMLStreamException {
            this.fLogger.log(116, string, string2);
            super.setPrefix(string, string2);
            this.fLogger.logReturn();
        }

        public void setDefaultNamespace(String string) throws XMLStreamException {
            this.fLogger.log(117, string);
            super.setDefaultNamespace(string);
            this.fLogger.logReturn();
        }

        public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
            this.fLogger.log(118, new Object[]{namespaceContext});
            super.setNamespaceContext(namespaceContext);
            this.fLogger.logReturn();
        }

        public NamespaceContext getNamespaceContext() {
            this.fLogger.log(25);
            NamespaceContext namespaceContext = super.getNamespaceContext();
            this.fLogger.logReturn();
            return namespaceContext;
        }

        public Object getProperty(String string) throws IllegalArgumentException {
            this.fLogger.log(0, string);
            Object object = super.getProperty(string);
            this.fLogger.logReturn();
            return object;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class ClosedXMLStreamWriter
    implements XMLStreamWriter {
        private ClosedXMLStreamWriter() {
        }

        public void writeStartElement(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeStartElement(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeEmptyElement(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeEmptyElement(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeEndElement() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeEndDocument() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void close() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void flush() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeAttribute(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeNamespace(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeDefaultNamespace(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeComment(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeProcessingInstruction(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeCData(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeDTD(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeEntityRef(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeStartDocument() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeStartDocument(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeStartDocument(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeCharacters(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public String getPrefix(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public void setPrefix(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void setDefaultNamespace(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
        }

        public NamespaceContext getNamespaceContext() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }

        public Object getProperty(String string) throws IllegalArgumentException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 36));
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class EndDocumentXMLStreamWriter
    implements XMLStreamWriter {
        private EndDocumentXMLStreamWriter() {
        }

        public void writeStartElement(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeStartElement(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeEmptyElement(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeEmptyElement(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeEndElement() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeEndDocument() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void close() throws XMLStreamException {
        }

        public void flush() throws XMLStreamException {
        }

        public void writeAttribute(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeNamespace(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeDefaultNamespace(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeComment(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeProcessingInstruction(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeCData(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeDTD(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeEntityRef(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeStartDocument() throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeStartDocument(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeStartDocument(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeCharacters(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public String getPrefix(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
            return null;
        }

        public void setPrefix(String string, String string2) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void setDefaultNamespace(String string) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
        }

        public NamespaceContext getNamespaceContext() {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
            return null;
        }

        public Object getProperty(String string) throws IllegalArgumentException {
            StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 37));
            return null;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class XMLStreamWriterProxy
    implements XMLStreamWriter {
        private XMLStreamWriter fStreamWriter;
        private boolean fRecycleOnEndDocument;

        public XMLStreamWriterProxy(XMLStreamWriter xMLStreamWriter, boolean bl) {
            this.fRecycleOnEndDocument = bl;
            this.fStreamWriter = xMLStreamWriter;
        }

        public void writeStartElement(String string) throws XMLStreamException {
            this.fStreamWriter.writeStartElement(string);
        }

        public void writeStartElement(String string, String string2) throws XMLStreamException {
            this.fStreamWriter.writeStartElement(string, string2);
        }

        public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
            this.fStreamWriter.writeStartElement(string, string2, string3);
        }

        public void writeEmptyElement(String string, String string2) throws XMLStreamException {
            this.fStreamWriter.writeEmptyElement(string, string2);
        }

        public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
            this.fStreamWriter.writeEmptyElement(string, string2, string3);
        }

        public void writeEmptyElement(String string) throws XMLStreamException {
            this.fStreamWriter.writeEmptyElement(string);
        }

        public void writeEndElement() throws XMLStreamException {
            this.fStreamWriter.writeEndElement();
        }

        public void writeEndDocument() throws XMLStreamException {
            this.fStreamWriter.writeEndDocument();
            if (this.fRecycleOnEndDocument) {
                this.fStreamWriter.close();
                this.fStreamWriter = fgEndDocumentStreamWriter;
            }
        }

        public void close() throws XMLStreamException {
            if (this.fStreamWriter != fgClosedStreamWriter) {
                this.fStreamWriter.close();
                this.fStreamWriter = fgClosedStreamWriter;
            }
        }

        public void flush() throws XMLStreamException {
            this.fStreamWriter.flush();
        }

        public void writeAttribute(String string, String string2) throws XMLStreamException {
            this.fStreamWriter.writeAttribute(string, string2);
        }

        public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
            this.fStreamWriter.writeAttribute(string, string2, string3, string4);
        }

        public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
            this.fStreamWriter.writeAttribute(string, string2, string3);
        }

        public void writeNamespace(String string, String string2) throws XMLStreamException {
            this.fStreamWriter.writeNamespace(string, string2);
        }

        public void writeDefaultNamespace(String string) throws XMLStreamException {
            this.fStreamWriter.writeDefaultNamespace(string);
        }

        public void writeComment(String string) throws XMLStreamException {
            this.fStreamWriter.writeComment(string);
        }

        public void writeProcessingInstruction(String string) throws XMLStreamException {
            this.fStreamWriter.writeProcessingInstruction(string);
        }

        public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
            this.fStreamWriter.writeProcessingInstruction(string, string2);
        }

        public void writeCData(String string) throws XMLStreamException {
            this.fStreamWriter.writeCData(string);
        }

        public void writeDTD(String string) throws XMLStreamException {
            this.fStreamWriter.writeDTD(string);
        }

        public void writeEntityRef(String string) throws XMLStreamException {
            this.fStreamWriter.writeEntityRef(string);
        }

        public void writeStartDocument() throws XMLStreamException {
            this.fStreamWriter.writeStartDocument();
        }

        public void writeStartDocument(String string) throws XMLStreamException {
            this.fStreamWriter.writeStartDocument(string);
        }

        public void writeStartDocument(String string, String string2) throws XMLStreamException {
            this.fStreamWriter.writeStartDocument(string, string2);
        }

        public void writeCharacters(String string) throws XMLStreamException {
            this.fStreamWriter.writeCharacters(string);
        }

        public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
            this.fStreamWriter.writeCharacters(cArray, n, n2);
        }

        public String getPrefix(String string) throws XMLStreamException {
            return this.fStreamWriter.getPrefix(string);
        }

        public void setPrefix(String string, String string2) throws XMLStreamException {
            this.fStreamWriter.setPrefix(string, string2);
        }

        public void setDefaultNamespace(String string) throws XMLStreamException {
            this.fStreamWriter.setDefaultNamespace(string);
        }

        public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
            this.fStreamWriter.setNamespaceContext(namespaceContext);
        }

        public NamespaceContext getNamespaceContext() {
            return this.fStreamWriter.getNamespaceContext();
        }

        public Object getProperty(String string) throws IllegalArgumentException {
            return this.fStreamWriter.getProperty(string);
        }
    }
}

