/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appclient.boot;

import com.ibm.ws.appclient.boot.ClientBootstrapConfig;
import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.LaunchArguments;
import com.ibm.ws.kernel.boot.Launcher;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.internal.KernelBootstrap;
import com.ibm.ws.kernel.boot.internal.ServerLock;
import com.ibm.ws.kernel.boot.internal.commands.PackageCommand;
import java.util.ResourceBundle;

public class ClientLauncher
extends Launcher {
    public static void main(String[] args) throws UnsupportedOperationException {
        ClientLauncher launcher = new ClientLauncher();
        System.exit(launcher.createPlatform(args));
    }

    protected BootstrapConfig createBootstrapConfig() {
        return new ClientBootstrapConfig();
    }

    protected boolean isClient() {
        return true;
    }

    protected ReturnCode handleActions(BootstrapConfig bootProps, LaunchArguments launchArgs) {
        ReturnCode rc = launchArgs.getRc();
        switch (rc) {
            case OK: {
                rc = new KernelBootstrap(bootProps).go();
                break;
            }
            case CREATE_ACTION: {
                ServerLock.createServerLock((BootstrapConfig)bootProps);
                rc = ReturnCode.OK;
                break;
            }
            case MESSAGE_ACTION: {
                rc = this.showMessage(launchArgs);
                break;
            }
            case HELP_ACTION: {
                rc = this.showHelp(launchArgs);
                break;
            }
            case PACKAGE_ACTION: {
                rc = new PackageCommand(bootProps, launchArgs).doPackage();
                break;
            }
            default: {
                this.showHelp(launchArgs);
                rc = ReturnCode.BAD_ARGUMENT;
            }
        }
        return rc;
    }

    protected ResourceBundle getOptionsResourceBundle() {
        return ResourceBundle.getBundle("com.ibm.ws.appclient.boot.resources.ClientLauncherOptions");
    }

    protected String getDefaultProcessName() {
        return "defaultClient";
    }

    protected String getDefaultProcessNameMessageKey() {
        return "info.defaultClient";
    }
}

