/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.zip.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.zip.internal.ZipFileContainer;
import com.ibm.ws.artifact.zip.internal.ZipFileEntryIterator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.zip.ZipEntry;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipFileNestedDirContainer
implements ArtifactContainer {
    private final File archiveFile;
    private final ArtifactEntry entryInEnclosingContainer;
    private final ArtifactContainer enclosingContainer;
    private final ZipFileContainer rootContainer;
    private final String name;
    private final NavigableMap<String, ZipEntry> allEntries;
    private final ContainerFactoryHolder containerFactoryHolder;
    static final long serialVersionUID = -6534413250676057052L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ZipFileNestedDirContainer(ZipFileContainer zc, ArtifactContainer c, File af, ArtifactEntry entryInEnclosingContainer, NavigableMap<String, ZipEntry> allEntries, String name, ContainerFactoryHolder cfh) {
        this.enclosingContainer = c;
        this.rootContainer = zc;
        this.archiveFile = af;
        this.entryInEnclosingContainer = entryInEnclosingContainer;
        this.name = name;
        this.allEntries = allEntries;
        this.containerFactoryHolder = cfh;
    }

    public Iterator<ArtifactEntry> iterator() {
        return new ZipFileEntryIterator(this.rootContainer, this, this.archiveFile, this.allEntries, this.getPath(), this.containerFactoryHolder);
    }

    public ArtifactContainer getEnclosingContainer() {
        return this.enclosingContainer;
    }

    public ArtifactEntry getEntryInEnclosingContainer() {
        return this.entryInEnclosingContainer;
    }

    public String getPath() {
        String path = this.enclosingContainer.getPath();
        if (!path.equals("/")) {
            path = path + '/';
        }
        path = path + this.getName();
        return path;
    }

    public String getName() {
        return this.name;
    }

    public void useFastMode() {
    }

    public void stopUsingFastMode() {
    }

    public boolean isRoot() {
        return false;
    }

    public ArtifactEntry getEntry(String pathAndName) {
        if (pathAndName.startsWith("/")) {
            return this.rootContainer.getEntry(pathAndName);
        }
        return this.rootContainer.getEntry(this.getPath() + "/" + pathAndName);
    }

    public ArtifactContainer getRoot() {
        return this.rootContainer;
    }

    public Collection<URL> getURLs() {
        try {
            URL entryUrl = this.rootContainer.createEntryUri(this.getPath() + "/", this.archiveFile).toURL();
            return Collections.singleton(entryUrl);
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileNestedDirContainer", (String)"133", (Object)this, (Object[])new Object[0]);
            return Collections.emptySet();
        }
    }

    public String getPhysicalPath() {
        return null;
    }

    public ArtifactNotifier getArtifactNotifier() {
        return this.rootContainer.getArtifactNotifier();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ZipFileNestedDirContainer.class);
    }
}

