/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.embeddable.impl;

import com.ibm.tx.jta.util.TxBundleTools;
import com.ibm.tx.remote.RecoveryCoordinator;
import com.ibm.tx.remote.RecoveryCoordinatorFactory;
import com.ibm.tx.remote.RecoveryCoordinatorNotAvailableException;
import com.ibm.tx.util.logging.FFDCFilter;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.transaction.SystemException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class WSATRecoveryCoordinator
implements RecoveryCoordinator,
Serializable {
    private static final long serialVersionUID = 5500037426315245114L;
    private static final transient TraceComponent tc = Tr.register(WSATRecoveryCoordinator.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final String _recoveryCoordinatorFactoryFilter;
    private final Serializable _recoveryCoordinatorInfo;
    private final String _globalId;
    private transient RecoveryCoordinator rc;

    public WSATRecoveryCoordinator(String recoveryCoordinatorFactoryFilter, Serializable recoveryCoordinatorInfo, String globalId) {
        this._recoveryCoordinatorFactoryFilter = recoveryCoordinatorFactoryFilter;
        this._recoveryCoordinatorInfo = recoveryCoordinatorInfo;
        this._globalId = globalId;
    }

    public static WSATRecoveryCoordinator fromLogData(byte[] bytes) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fromLogData", (Object[])new Object[]{bytes});
        }
        WSATRecoveryCoordinator wsatRC = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object obj = ois.readObject();
            wsatRC = (WSATRecoveryCoordinator)obj;
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator.fromLogData", (String)"67");
            Throwable se = new SystemException().initCause(e);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fromLogData", (Object)se);
            }
            throw (SystemException)se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fromLogData", (Object)wsatRC);
        }
        return wsatRC;
    }

    public String getGlobalId() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getGlobalId", (Object[])new Object[]{this._globalId});
        }
        return this._globalId;
    }

    public byte[] toLogData() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"toLogData", (Object[])new Object[]{this});
        }
        byte[] logData = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            logData = baos.toByteArray();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator.toLogData", (String)"118", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Exception caught in toLogData " + e), (Object[])new Object[0]);
            }
            Throwable se = new SystemException().initCause((Throwable)e);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"toLogData", (Object)se);
            }
            throw (SystemException)se;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"toLogData", (Object)logData);
        }
        return logData;
    }

    @Override
    public void replayCompletion(String globalId) {
        block4: {
            if (this.rc == null) {
                try {
                    this.rc = this.getRecoveryCoordinator();
                }
                catch (RecoveryCoordinatorNotAvailableException e) {
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)"replayCompletion", (Object[])new Object[]{e});
                }
            }
        }
        if (this.rc != null) {
            this.rc.replayCompletion(globalId);
        }
    }

    private RecoveryCoordinator getRecoveryCoordinator() throws RecoveryCoordinatorNotAvailableException {
        try {
            RecoveryCoordinatorFactory factory = WSATRecoveryCoordinator.lookupRecoveryCoordinatorFactory(this._recoveryCoordinatorFactoryFilter);
            if (factory == null) {
                throw new RecoveryCoordinatorNotAvailableException();
            }
            return factory.getRecoveryCoordinator(this._recoveryCoordinatorInfo);
        }
        catch (RecoveryCoordinatorNotAvailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RecoveryCoordinatorNotAvailableException(e);
        }
    }

    public static RecoveryCoordinatorFactory lookupRecoveryCoordinatorFactory(String filter) {
        BundleContext bundleContext;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupRecoveryCoordinatorFactory", (Object[])new Object[]{filter});
        }
        if ((bundleContext = TxBundleTools.getBundleContext()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"lookupRecoveryCoordinatorFactory", null);
            }
            return null;
        }
        ServiceReference[] results = null;
        try {
            results = bundleContext.getServiceReferences(RecoveryCoordinatorFactory.class.getCanonicalName(), filter);
        }
        catch (InvalidSyntaxException e) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"lookupRecoveryCoordinatorFactory", (Object)"not a filter");
            }
            return null;
        }
        if (results == null || results.length <= 0) {
            if (results == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Results returned from registry are null", (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Results of length " + results.length + " returned from registry"), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"lookupRecoveryCoordinatorFactory", null);
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Found " + results.length + " service references in the registry"), (Object[])new Object[0]);
        }
        RecoveryCoordinatorFactory recoveryCoordinatorFactory = (RecoveryCoordinatorFactory)bundleContext.getService(results[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupRecoveryCoordinatorFactory", (Object)recoveryCoordinatorFactory);
        }
        return recoveryCoordinatorFactory;
    }
}

