/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.remote.client.internal.injection;

import com.ibm.ejs.util.Util;
import com.ibm.ejs.util.dopriv.GetContextClassLoaderPrivileged;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.clientcontainer.remote.common.ClientSupport;
import com.ibm.ws.clientcontainer.remote.common.ClientSupportFactory;
import com.ibm.ws.container.service.naming.RemoteObjectInstance;
import com.ibm.ws.ejbcontainer.remote.client.internal.injection.EJBLinkClientInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.security.AccessController;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.rmi.PortableRemoteObject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ObjectFactory.class, EJBLinkClientObjectFactoryImpl.class})
public class EJBLinkClientObjectFactoryImpl
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(EJBLinkClientObjectFactoryImpl.class);
    private static final TraceComponent tcInjection = Tr.register(EJBLinkClientObjectFactoryImpl.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private ClientSupportFactory clientSupportFactory;
    static final long serialVersionUID = 997826298446147770L;

    @org.osgi.service.component.annotations.Reference(service=LibertyProcess.class, target="(wlp.process.type=client)")
    protected void setLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    protected void unsetLibertyProcess(ServiceReference<LibertyProcess> reference) {
    }

    @org.osgi.service.component.annotations.Reference
    protected void setClientSupportFactory(ClientSupportFactory clientSupportFactory) {
        this.clientSupportFactory = clientSupportFactory;
    }

    protected void unsetClientSupportFactory(ClientSupportFactory clientSupportFactory) {
        this.clientSupportFactory = null;
    }

    @Override
    @Trivial
    @ManualTrace
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectInstance : " + obj), (Object[])new Object[0]);
        }
        Object retObj = null;
        if (!(obj instanceof Reference)) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getObjectInstance", (Object)" : null (non-Reference)");
            }
            return null;
        }
        Reference ref = (Reference)obj;
        if (!this.getClass().getName().equals(ref.getFactoryClassName())) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getObjectInstance", (Object)(" : null (wrong factory class: " + ref.getFactoryClassName() + ")"));
            }
            return null;
        }
        RefAddr addr = ref.get("EJBLinkClientInfo");
        if (addr == null) {
            NamingException nex = new NamingException("The address for this Reference is empty (null)");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getObjectInstance", (Object)(" : " + nex));
            }
            throw nex;
        }
        EJBLinkClientInfo info = (EJBLinkClientInfo)addr.getContent();
        String module = null;
        String logicalModule = null;
        String bean = info.ivBeanName;
        if (bean != null) {
            int bidx;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("bean name specified (" + bean + "), checking for module information..."), (Object[])new Object[0]);
            }
            if ((bidx = bean.indexOf(35)) > -1) {
                int midx = bean.lastIndexOf(47);
                module = midx > -1 && midx < bidx ? bean.substring(midx + 1, bidx) : bean.substring(0, bidx);
                bean = bean.substring(bidx + 1);
                if (!module.endsWith(".jar") && !module.endsWith(".war")) {
                    Tr.error((TraceComponent)tcInjection, (String)"EJB_MODULE_MUST_END_WITH_JAR_CWNEN0034E", (Object[])new Object[]{bean, module});
                    throw new InjectionConfigurationException("The ejb-link/beanName is specified incorrectly. The " + bean + " bean : " + module + " module name must end with .jar or .war.");
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Used ejb-link style 2 to get module name " + module + " and beanName " + bean), (Object[])new Object[0]);
                }
            } else {
                int forwardSlashIndex = bean.lastIndexOf(47);
                if (forwardSlashIndex > -1) {
                    logicalModule = bean.substring(0, forwardSlashIndex);
                    bean = bean.substring(forwardSlashIndex + 1);
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Used ejb-link style 3 to get module name " + logicalModule + " and beanName " + bean), (Object[])new Object[0]);
                    }
                }
            }
        }
        ClientSupport ejbFactory = this.clientSupportFactory.getRemoteClientSupport();
        String beanInterface = info.ivHomeInterface != null ? info.ivHomeInterface : info.ivBeanInterface;
        try {
            RemoteObjectInstance roi = null;
            roi = bean != null ? (module != null ? ejbFactory.createEJB(info.ivApplication, module, bean, beanInterface) : (logicalModule != null ? ejbFactory.createEJB(info.ivApplication, info.ivBeanName, beanInterface) : ejbFactory.findEJBByBeanName(info.ivApplication, bean, beanInterface))) : ejbFactory.findEJBByInterface(info.ivApplication, beanInterface);
            retObj = roi.getObject();
        }
        catch (EJBException roi) {
            FFDCFilter.processException((Throwable)roi, (String)"com.ibm.ws.ejbcontainer.remote.client.internal.injection.EJBLinkClientObjectFactoryImpl", (String)"219", (Object)this, (Object[])new Object[]{obj, name, nameCtx, environment});
            if (bean == null) {
                Tr.error((TraceComponent)tcInjection, (String)"ENTERPRISE_BEAN_INTERFACE_NOT_FOUND_ON_NODE_CWNEN0068E", (Object[])new Object[]{info.ivRefName, info.ivModule, beanInterface});
                throw new InjectionException("The " + info.ivRefName + " EJB reference in the " + info.ivModule + " module to the " + beanInterface + " interface of an enterprise bean cannot be resolved on this node.");
            }
            Tr.error((TraceComponent)tcInjection, (String)"ENTERPRISE_BEAN_NOT_FOUND_ON_NODE_CWNEN0041E", (Object[])new Object[]{info.ivRefName, info.ivModule, beanInterface, bean});
            throw new InjectionException("The " + info.ivRefName + " EJB reference in the " + info.ivModule + " module to the " + beanInterface + " interface of the " + bean + " enterprise bean cannot be resolved on this node.");
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("narrowing " + Util.identity((Object)retObj)), (Object[])new Object[0]);
        }
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new GetContextClassLoaderPrivileged());
        Class<?> beanInterfaceClass = loader.loadClass(beanInterface);
        retObj = PortableRemoteObject.narrow((Object)retObj, beanInterfaceClass);
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("narrowed " + Util.identity((Object)retObj)), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjectInstance", (Object)(" : " + retObj.getClass().getName()));
        }
        return retObj;
    }
}

