/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transaction.services;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.util.TMHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.resource.ResourceFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DeferredRecoveryStarter
implements Runnable {
    private static final TraceComponent tc = Tr.register(DeferredRecoveryStarter.class);
    private ConfigurationProvider _cp = null;
    private ResourceFactory _dataSourceFactory = null;
    static final long serialVersionUID = 2623606793527456231L;

    public DeferredRecoveryStarter(ConfigurationProvider cp, ResourceFactory dataSourceFactory) {
        this._cp = cp;
        this._dataSourceFactory = dataSourceFactory;
    }

    @Override
    @FFDCIgnore(value={InterruptedException.class})
    public void run() {
        boolean refSet = false;
        DataSource nonTranDataSource = null;
        while (!refSet) {
            block8: {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)"Sleep Interrupted", (Object[])new Object[0]);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getDataSource after sleep", (Object[])new Object[0]);
            }
            refSet = this.checkDataSource(nonTranDataSource);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Done sleeping drive startup", (Object[])new Object[0]);
        }
        if (this._cp.isRecoverOnStartup()) {
            try {
                TMHelper.start((boolean)this._cp.isWaitForRecovery());
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transaction.services.DeferredRecoveryStarter", (String)"70", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.transaction.services.TransactionManagerService.activate", (String)"60", (Object)this);
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    private boolean checkDataSource(DataSource nonTranDataSource) {
        boolean fullyFormedDS;
        block6: {
            fullyFormedDS = false;
            try {
                nonTranDataSource = (DataSource)this._dataSourceFactory.createResource(null);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Non Tran dataSource is " + nonTranDataSource), (Object[])new Object[0]);
                }
                Connection conn = nonTranDataSource.getConnection();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Established connection " + conn), (Object[])new Object[0]);
                }
                DatabaseMetaData mdata = conn.getMetaData();
                String dbName = mdata.getDatabaseProductName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Database name " + dbName), (Object[])new Object[0]);
                }
                String dbVersion = mdata.getDatabaseProductVersion();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Database version " + dbVersion), (Object[])new Object[0]);
                }
                fullyFormedDS = true;
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)("Caught exception: " + e), (Object[])new Object[0]);
            }
        }
        return fullyFormedDS;
    }
}

