/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.StatementCacheKey;
import java.lang.reflect.InvocationTargetException;

public class DB2SQLJPSCacheKey
extends StatementCacheKey {
    public static final int DB2_SQLJ_PREPARED_STATEMENT = 3;

    public DB2SQLJPSCacheKey(String theSQL, int theType, int theConcurrency, int theHoldability, Object theSection, int isolation, String dbSchema, String cacheKeySuffix) {
        this.type = theType;
        this.concurrency = theConcurrency;
        this.holdability = theHoldability;
        this.statementIsoLevel = isolation;
        this.schema = dbSchema;
        try {
            Class<?> SQLJSection = theSection.getClass();
            Object thePackage = SQLJSection.getMethod("getPackage", new Class[0]).invoke(theSection, new Object[0]);
            Class<?> SQLJPackage = thePackage.getClass();
            this.consistencyToken = DB2SQLJPSCacheKey.toLong((byte[])SQLJPackage.getMethod("getConsistencyToken", new Class[0]).invoke(thePackage, new Object[0]));
            this.sql = theSQL;
            this.sectionNumber = (Integer)SQLJSection.getMethod("getSectionNumber", new Class[0]).invoke(theSection, new Object[0]);
            this.packageName = (String)SQLJPackage.getMethod("getPackageName", new Class[0]).invoke(thePackage, new Object[0]);
            this.hCode = this.sql.hashCode() + this.sectionNumber + this.packageName.hashCode();
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"60", (Object)this);
            Throwable throwable = x = x instanceof InvocationTargetException ? x.getCause() : x;
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            if (x instanceof Error) {
                throw (Error)x;
            }
            throw new RuntimeException(x);
        }
        this.statementType = 3;
        this.cacheKeySuffix = cacheKeySuffix;
    }

    public final boolean equals(Object keyToCheck) {
        try {
            StatementCacheKey k = (StatementCacheKey)keyToCheck;
            return this.sql.equals(k.sql) && this.statementType == k.statementType && this.holdability == k.holdability && this.type == k.type && this.concurrency == k.concurrency && this.consistencyToken == k.consistencyToken && this.sectionNumber == k.sectionNumber && this.packageName.equals(k.packageName) && this.statementIsoLevel == k.statementIsoLevel && AdapterUtil.match(this.schema, k.schema) && AdapterUtil.match(this.cacheKeySuffix, k.cacheKeySuffix);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String toString() {
        return "DB2 SQLJ PSTMT: " + this.sql + ' ' + this.type + ' ' + this.concurrency + ' ' + this.holdability + ' ' + this.statementIsoLevel + ' ' + this.schema + ' ' + this.sectionNumber + ' ' + this.packageName + " 0x" + Long.toHexString(this.consistencyToken) + ' ' + this.cacheKeySuffix;
    }
}

