/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.persistence.jpa;

import com.ibm.jbatch.container.persistence.CheckpointData;
import com.ibm.jbatch.container.persistence.jpa.EntityConstants;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceKey;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@IdClass(value=StepThreadInstanceKey.class)
@DiscriminatorColumn(name="THREADTYPE", discriminatorType=DiscriminatorType.CHAR)
@DiscriminatorValue(value="P")
@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"FK_JOBINSTANCEID", "STEPNAME", "PARTNUM"})})
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class StepThreadInstanceEntity
implements EntityConstants {
    @Id
    @ManyToOne
    @JoinColumn(name="FK_JOBINSTANCEID", nullable=false)
    private JobInstanceEntity jobInstance;
    @Id
    @Column(name="STEPNAME", nullable=false, length=128)
    private String stepName;
    @Id
    @Column(name="PARTNUM", nullable=false)
    private int partitionNumber = -1;
    @Lob
    @Column(name="CHECKPOINTDATA")
    private byte[] checkpointData;
    @OneToOne
    @JoinColumn(name="FK_LATEST_STEPEXECID", nullable=false)
    private StepThreadExecutionEntity latestStepThreadExecution;
    static final long serialVersionUID = -9219936707734915709L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public StepThreadInstanceEntity() {
    }

    public StepThreadInstanceEntity(JobInstanceEntity jobInstance, String stepName, int partitionNumber) {
        this.jobInstance = jobInstance;
        this.stepName = stepName;
        this.partitionNumber = partitionNumber;
    }

    @Trivial
    public JobInstanceEntity getJobInstance() {
        return this.jobInstance;
    }

    public void setJobInstance(JobInstanceEntity jobInstance) {
        this.jobInstance = jobInstance;
    }

    @Trivial
    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public StepThreadExecutionEntity getLatestStepThreadExecution() {
        return this.latestStepThreadExecution;
    }

    public void setLatestStepThreadExecution(StepThreadExecutionEntity latestStepThreadExecution) {
        this.latestStepThreadExecution = latestStepThreadExecution;
    }

    @Trivial
    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public void setPartitionNumber(int partitionNumber) {
        this.partitionNumber = partitionNumber;
    }

    public CheckpointData getCheckpointData() {
        return this.checkpointData == null ? null : new CheckpointData(this.checkpointData);
    }

    @Trivial
    public void setCheckpointData(CheckpointData data) {
        this.checkpointData = data.getBytesForDB();
    }

    public void deleteCheckpointData() {
        this.checkpointData = null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("For StepThreadInstanceEntity:");
        buf.append(" step Name = " + this.stepName);
        buf.append(", partition Number = " + this.partitionNumber);
        buf.append(", instance = " + this.jobInstance);
        return buf.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(StepThreadInstanceEntity.class);
    }
}

