/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.persistence.jpa;

import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionKey;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.jbatch.container.ws.RemotablePartitionState;
import com.ibm.jbatch.container.ws.WSRemotablePartitionExecution;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Date;
import javax.batch.runtime.JobExecution;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@IdClass(value=RemotablePartitionKey.class)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RemotablePartitionEntity
implements WSRemotablePartitionExecution {
    public static final String GET_ALL_RELATED_REMOTABLE_PARTITIONS = "RemotablePartitionEntity.getAllRelatedRemotablePartitions";
    public static final String GET_PARTITION_STEP_THREAD_EXECUTIONIDS_BY_SERVERID_AND_STATUSES_QUERY = "RemotablePartitionEntity.getPartitionStepExecutionByServerIdAndStatusesQuery";
    @Id
    @ManyToOne
    @JoinColumn(name="FK_JOBEXECUTIONID", nullable=false)
    private JobExecutionEntity jobExec;
    @JoinColumn(name="FK_STEPEXECUTIONID")
    private StepThreadExecutionEntity stepExecutionEntity;
    @Id
    @Column(name="STEPNAME")
    private String stepName;
    @Column(name="PARTNUM")
    @Id
    private int partitionNumber;
    @Column(name="INTERNALSTATE")
    private RemotablePartitionState internalStatus;
    @Column(name="SERVERID", length=256)
    private String serverId;
    @Column(name="RESTURL", length=512)
    private String restUrl;
    @Column(name="LOGPATH", nullable=true, length=512)
    private String logpath;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="LASTUPDATED")
    private Date lastUpdated;
    static final long serialVersionUID = -4601156087314751838L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RemotablePartitionEntity() {
    }

    public RemotablePartitionEntity(JobExecutionEntity jobExecution, RemotablePartitionKey partitionKey) {
        this.jobExec = jobExecution;
        this.stepName = partitionKey.getStepName();
        this.partitionNumber = partitionKey.getPartitionNumber();
    }

    public RemotablePartitionEntity(JobExecutionEntity jobExecution, String stepName, int partitionNum) {
        this.jobExec = jobExecution;
        this.stepName = stepName;
        this.partitionNumber = partitionNum;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date queuedTime) {
        this.lastUpdated = queuedTime;
    }

    @Override
    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    @Override
    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public void setPartitionNumber(int partitionNumber) {
        this.partitionNumber = partitionNumber;
    }

    public RemotablePartitionState getInternalStatus() {
        return this.internalStatus;
    }

    public void setInternalStatus(RemotablePartitionState execution) {
        this.internalStatus = execution;
    }

    public JobExecutionEntity getJobExec() {
        return this.jobExec;
    }

    @Override
    public JobExecution getJobExecution() {
        return this.jobExec;
    }

    public void setJobExec(JobExecutionEntity jobExecutionId) {
        this.jobExec = jobExecutionId;
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    @Override
    public String getRestUrl() {
        return this.restUrl;
    }

    public void setRestUrl(String restUrl) {
        this.restUrl = restUrl;
    }

    @Override
    public String getLogpath() {
        return this.logpath;
    }

    public void setLogpath(String logpath) {
        this.logpath = logpath;
    }

    public StepThreadExecutionEntity getStepExecution() {
        return this.stepExecutionEntity;
    }

    public void setStepExecution(StepThreadExecutionEntity stepExecution) {
        this.stepExecutionEntity = stepExecution;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Long jobExecutionId = this.jobExec == null ? null : Long.valueOf(this.jobExec.getExecutionId());
        buf.append(super.toString() + System.getProperty("line.separator"));
        buf.append("For RemotablePartitionExecutionEntity:");
        buf.append(", job executionId = " + jobExecutionId);
        buf.append(" stepName = " + this.stepName);
        buf.append(", partition number = " + this.partitionNumber);
        return buf.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RemotablePartitionEntity.class);
    }
}

