/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jsl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JSLLoader {
    private static final Logger logger = Logger.getLogger(JSLLoader.class.getName());
    private Set<URI> jobFilelist;
    public static final String JOBS_FOLDER = "META-INF/jobs";
    static final long serialVersionUID = 4918714386203967190L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JSLLoader() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.jsl.JSLLoader", "<init>", new Object[0]);
        }
        this.jobFilelist = Collections.synchronizedSet(new LinkedHashSet());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.jsl.JSLLoader", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void traverseJobPath() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.jsl.JSLLoader", "traverseJobPath", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.jsl.JSLLoader", "traverseJobPath");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<URI> getArtifacts(URL rootURL) throws FileNotFoundException, IOException, URISyntaxException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.jsl.JSLLoader", "getArtifacts", new Object[]{rootURL});
        }
        JarFile jarfile = new JarFile(new File(rootURL.toURI()));
        Enumeration<JarEntry> jarEntries = jarfile.entries();
        if (jarEntries == null) {
            throw new IllegalArgumentException();
        }
        while (jarEntries.hasMoreElements()) {
            String entry = jarEntries.nextElement().getName();
            if (!entry.startsWith(JOBS_FOLDER) || entry.endsWith("/")) continue;
            this.jobFilelist.add(new URI(null, entry, null));
        }
        Set<URI> set = this.jobFilelist;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.jbatch.container.jsl.JSLLoader", "getArtifacts", set);
        }
        return set;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Set<URI> getFolderArtifacts(File directory) throws FileNotFoundException, IOException, URISyntaxException {
        File[] xmlFiles;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.jsl.JSLLoader", "getFolderArtifacts", new Object[]{directory});
        }
        for (File file : xmlFiles = directory.listFiles(new XMLFilenameFilter())) {
            this.jobFilelist.add(file.toURI());
        }
        Set<URI> set = this.jobFilelist;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.jbatch.container.jsl.JSLLoader", "getFolderArtifacts", set);
        }
        return set;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class XMLFilenameFilter
    implements FilenameFilter {
        static final long serialVersionUID = 9037421865984020676L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private XMLFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String fileName) {
            return fileName.endsWith(".xml");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(XMLFilenameFilter.class);
        }
    }
}

